/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.filters.degree;

import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;

public class DegreeRange {
    private boolean updated = false;
    private final PairImpl incoming = new PairImpl();
    private final PairImpl outgoing = new PairImpl();

    public void update(CyNetwork network, CyEdge edge) {
        this.update(this.incoming, network, edge.getSource(), CyEdge.Type.INCOMING);
        this.update(this.outgoing, network, edge.getSource(), CyEdge.Type.OUTGOING);
        this.update(this.incoming, network, edge.getTarget(), CyEdge.Type.INCOMING);
        this.update(this.outgoing, network, edge.getTarget(), CyEdge.Type.OUTGOING);
    }

    public void update(CyNetwork network) {
        for (CyNode node : network.getNodeList()) {
            this.update(this.incoming, network, node, CyEdge.Type.INCOMING);
            this.update(this.outgoing, network, node, CyEdge.Type.OUTGOING);
        }
    }

    private void update(PairImpl pair, CyNetwork network, CyNode node, CyEdge.Type type) {
        int degree = DegreeRange.computeDegree(network, node, type);
        pair.low = Integer.min(pair.low, degree);
        pair.high = Integer.max(pair.high, degree);
        this.updated = true;
    }

    private static int computeDegree(CyNetwork network, CyNode node, CyEdge.Type type) {
        int degree = 0;
        for (CyEdge edge : network.getAdjacentEdgeIterable(node, type)) {
            ++degree;
        }
        return degree;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public Pair getInRange() {
        return this.incoming;
    }

    public Pair getOutRange() {
        return this.outgoing;
    }

    public Pair getAnyRange() {
        return new Pair(){

            @Override
            public int getLow() {
                return DegreeRange.this.incoming.low + DegreeRange.this.outgoing.low;
            }

            @Override
            public int getHigh() {
                return DegreeRange.this.incoming.high + DegreeRange.this.outgoing.high;
            }
        };
    }

    public Pair getRange(CyEdge.Type type) {
        switch (type) {
            case ANY: {
                return this.getAnyRange();
            }
            case INCOMING: {
                return this.getInRange();
            }
            case OUTGOING: {
                return this.getOutRange();
            }
        }
        throw new IllegalArgumentException();
    }

    private static class PairImpl
    implements Pair {
        int low = Integer.MAX_VALUE;
        int high = Integer.MIN_VALUE;

        private PairImpl() {
        }

        @Override
        public int getLow() {
            return this.low == Integer.MAX_VALUE ? 0 : this.low;
        }

        @Override
        public int getHigh() {
            return this.high == Integer.MIN_VALUE ? 0 : this.high;
        }
    }

    public static interface Pair {
        public int getLow();

        public int getHigh();
    }
}

