/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.filters.composite;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.cytoscape.filter.internal.filters.composite.CompositeFilterController;
import org.cytoscape.filter.internal.filters.composite.CompositeSeparator;
import org.cytoscape.filter.internal.view.AbstractPanelController;
import org.cytoscape.filter.internal.view.CompositePanelComponent;
import org.cytoscape.filter.internal.view.DragHandler;
import org.cytoscape.filter.internal.view.DynamicComboBoxModel;
import org.cytoscape.filter.internal.view.Matcher;
import org.cytoscape.filter.internal.view.SelectPanelComponent;
import org.cytoscape.filter.internal.view.TransformerElementViewModel;
import org.cytoscape.filter.internal.view.ViewUtil;
import org.cytoscape.filter.model.CompositeFilter;
import org.cytoscape.filter.model.Filter;
import org.cytoscape.filter.model.Transformer;
import org.cytoscape.filter.model.ValidatableTransformer;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class CompositeFilterPanel<P extends SelectPanelComponent>
extends JPanel
implements CompositePanelComponent {
    private static final Border NO_BORDER = BorderFactory.createEmptyBorder();
    private Map<Transformer<CyNetwork, CyIdentifiable>, TransformerElementViewModel<P>> viewModels;
    private GroupLayout layout;
    private int depth;
    private final JPanel combiningMethodPanel;
    private final Component topView;
    private AbstractPanelController<?, P> filterPanelController;
    private CompositeFilterController compositeFilterController;
    private final JButton addButton;
    private P parent;
    private CompositeFilter<CyNetwork, CyIdentifiable> model;
    private JComponent separator;
    private JComboBox<?> combiningMethodComboBox;

    public CompositeFilterPanel(P parent, AbstractPanelController<?, P> filterPanelController, CompositeFilterController controller, CompositeFilter<CyNetwork, CyIdentifiable> model, int depth) {
        this.parent = parent;
        this.filterPanelController = filterPanelController;
        this.compositeFilterController = controller;
        this.depth = depth;
        this.model = model;
        this.separator = new CompositeSeparator();
        new DropTarget(this.separator, new DragHandler<P>(this.separator, filterPanelController, parent, null));
        ViewUtil.configureFilterView(this);
        this.viewModels = new WeakHashMap<Transformer<CyNetwork, CyIdentifiable>, TransformerElementViewModel<P>>();
        this.layout = new GroupLayout(this);
        this.setLayout(this.layout);
        this.updateBorder();
        this.combiningMethodPanel = new JPanel(new BorderLayout());
        this.combiningMethodPanel.setBackground(this.getBackground());
        this.topView = controller.createFilterView(model);
        if (this.topView != null) {
            this.topView.setBackground(this.getBackground());
            this.combiningMethodPanel.add(this.topView, "Center");
        }
        this.combiningMethodComboBox = this.createCombiningMethodComboBox();
        this.combiningMethodPanel.add(this.combiningMethodComboBox, "South");
        this.addButton = this.createAddConditionButton();
        for (int i = 0; i < model.getLength(); ++i) {
            Filter filter = model.get(i);
            TransformerElementViewModel<P> viewModel = this.createViewModel((Filter<CyNetwork, CyIdentifiable>)filter);
            this.viewModels.put((Transformer<CyNetwork, CyIdentifiable>)filter, viewModel);
        }
    }

    private TransformerElementViewModel<P> createViewModel(Filter<CyNetwork, CyIdentifiable> filter) {
        JComponent component = this.filterPanelController.createView(this.parent, (Transformer<CyNetwork, CyIdentifiable>)filter, this.depth + 1);
        TransformerElementViewModel<P> viewModel = new TransformerElementViewModel<P>(component, this.filterPanelController, this.parent);
        if (filter instanceof ValidatableTransformer) {
            this.filterPanelController.getValidationManager().register((ValidatableTransformer<CyNetwork, CyIdentifiable>)((ValidatableTransformer)filter), viewModel);
        }
        return viewModel;
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.combiningMethodPanel != null) {
            this.combiningMethodPanel.setBackground(bg);
        }
        if (this.topView != null) {
            this.topView.setBackground(bg);
        }
    }

    private void updateBorder() {
        if (this.depth > 0) {
            this.setBorder(ViewUtil.COMPOSITE_PANEL_BORDER);
        } else {
            this.setBorder(NO_BORDER);
        }
    }

    @Override
    public void updateLayout() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this::updateLayout);
            return;
        }
        this.removeAll();
        GroupLayout.ParallelGroup checkBoxGroup = this.layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup viewGroup = this.layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup columns = this.layout.createParallelGroup(GroupLayout.Alignment.LEADING, true);
        GroupLayout.SequentialGroup rows = this.layout.createSequentialGroup();
        this.combiningMethodComboBox.setVisible(this.depth > 0 && !this.compositeFilterController.autoHideComboBox() || this.model.getLength() > 1);
        ((GroupLayout.Group)columns).addComponent(this.combiningMethodPanel, -2, -1, -2);
        ((GroupLayout.Group)rows).addComponent(this.combiningMethodPanel, -2, -1, -2);
        ((GroupLayout.Group)columns).addGroup(this.layout.createSequentialGroup().addGap(4).addGroup(checkBoxGroup).addGap(4).addGroup(viewGroup));
        int separatorHeight = 5;
        viewGroup.addComponent(this.separator);
        ((GroupLayout.Group)rows).addComponent(this.separator, separatorHeight, separatorHeight, separatorHeight);
        for (int i = 0; i < this.model.getLength(); ++i) {
            TransformerElementViewModel<P> viewModel = this.getViewModel((Transformer<CyNetwork, CyIdentifiable>)this.model.get(i));
            if (viewModel.view instanceof CompositeFilterPanel) {
                CompositeFilterPanel panel = (CompositeFilterPanel)viewModel.view;
                panel.updateLayout();
            }
            checkBoxGroup.addGroup(this.layout.createParallelGroup().addGroup(this.layout.createSequentialGroup().addComponent(viewModel.deleteButton, -1, -1, -1).addGap(4).addComponent(viewModel.handle, -1, -1, -1)).addGap(4).addComponent(viewModel.warnIcon, GroupLayout.Alignment.CENTER));
            viewGroup.addComponent(viewModel.view, 0, -2, Short.MAX_VALUE).addComponent(viewModel.separator);
            ((GroupLayout.Group)rows).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(this.layout.createSequentialGroup().addGap(4).addGroup(this.layout.createSequentialGroup().addGroup(this.layout.createParallelGroup().addComponent(viewModel.deleteButton, -1, -1, -1).addComponent(viewModel.handle, -2, -2, -2)).addGap(4).addComponent(viewModel.warnIcon))).addComponent(viewModel.view, -2, -1, -2));
            ((GroupLayout.Group)rows).addComponent(viewModel.separator, separatorHeight, separatorHeight, separatorHeight);
        }
        ((GroupLayout.Group)columns).addComponent(this.addButton);
        ((GroupLayout.Group)rows).addGap(4).addComponent(this.addButton);
        this.layout.setHorizontalGroup(columns);
        this.layout.setVerticalGroup(rows);
    }

    JButton createAddConditionButton() {
        JButton button = new JButton("\uf067");
        button.setFont(this.filterPanelController.getIconManager().getIconFont(11.0f));
        String tooltip = this.compositeFilterController.getAddButtonTooltip();
        button.setToolTipText(tooltip == null ? "Add new condition..." : tooltip);
        if (LookAndFeelUtil.isAquaLAF()) {
            button.putClientProperty("JButton.buttonType", "gradient");
        }
        button.addActionListener(evt -> {
            JPopupMenu menu = this.filterPanelController.createAddConditionMenu(this);
            menu.show(button, 0, button.getHeight());
        });
        return button;
    }

    private List<CombiningMethodElement> getCombiningMethods() {
        ArrayList<CombiningMethodElement> methods = new ArrayList<CombiningMethodElement>(2);
        methods.add(new CombiningMethodElement("Match all (AND)", CompositeFilter.Type.ALL));
        methods.add(new CombiningMethodElement("Match any (OR)", CompositeFilter.Type.ANY));
        return methods;
    }

    public JComboBox<CombiningMethodElement> createCombiningMethodComboBox() {
        List<CombiningMethodElement> methods = this.getCombiningMethods();
        DynamicComboBoxModel<CombiningMethodElement> comboBoxModel = new DynamicComboBoxModel<CombiningMethodElement>(methods);
        final JComboBox<CombiningMethodElement> combiningMethodComboBox = this.filterPanelController.getStyle().createCombo(comboBoxModel);
        combiningMethodComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CompositeFilterPanel.this.model.setType(((CombiningMethodElement)combiningMethodComboBox.getSelectedItem()).combiningMethod);
            }
        });
        DynamicComboBoxModel.select(combiningMethodComboBox, 0, new Matcher<CombiningMethodElement>(){

            @Override
            public boolean matches(CombiningMethodElement item) {
                return CompositeFilterPanel.this.model.getType().equals((Object)item.combiningMethod);
            }
        });
        return combiningMethodComboBox;
    }

    public void addViewModel(int index, Filter<CyNetwork, CyIdentifiable> filter, TransformerElementViewModel<P> viewModel) {
        this.model.insert(index, filter);
        this.viewModels.put((Transformer<CyNetwork, CyIdentifiable>)filter, viewModel);
    }

    public void addViewModel(Filter<CyNetwork, CyIdentifiable> filter, TransformerElementViewModel<P> viewModel) {
        this.model.append(filter);
        this.viewModels.put((Transformer<CyNetwork, CyIdentifiable>)filter, viewModel);
    }

    public void addFilter(Filter<CyNetwork, CyIdentifiable> filter) {
        TransformerElementViewModel<P> viewModel = this.createViewModel(filter);
        this.addViewModel(filter, viewModel);
    }

    public TransformerElementViewModel<P> getViewModel(Transformer<CyNetwork, CyIdentifiable> filter) {
        return this.viewModels.get(filter);
    }

    public CompositeFilter<CyNetwork, CyIdentifiable> getModel() {
        return this.model;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
        this.updateBorder();
        for (TransformerElementViewModel<P> viewModel : this.viewModels.values()) {
            if (!(viewModel.view instanceof CompositeFilterPanel)) continue;
            CompositeFilterPanel panel = (CompositeFilterPanel)viewModel.view;
            panel.setDepth(depth + 1);
        }
    }

    @Override
    public void removeTransformer(int index, boolean unregister) {
        Filter filter = this.model.remove(index);
        TransformerElementViewModel<P> model = this.viewModels.remove(filter);
        if (unregister && model != null && model.view != null) {
            this.filterPanelController.unregisterView(model.view);
            if (model.view instanceof CompositeFilterPanel) {
                ((CompositeFilterPanel)model.view).removeAllFilters();
            }
        }
        if (filter instanceof ValidatableTransformer) {
            this.filterPanelController.getValidationManager().unregister((ValidatableTransformer<CyNetwork, CyIdentifiable>)((ValidatableTransformer)filter));
        }
    }

    void removeAllFilters() {
        while (this.model.getLength() > 0) {
            this.removeTransformer(0, true);
        }
    }

    public Collection<TransformerElementViewModel<P>> getViewModels() {
        return this.viewModels.values();
    }

    @Override
    public JComponent getSeparator() {
        return this.separator;
    }

    @Override
    public int getTransformerCount() {
        return this.model.getLength();
    }

    public Filter<CyNetwork, CyIdentifiable> getTransformerAt(int index) {
        return this.model.get(index);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    class CombiningMethodElement {
        public final String name;
        public final CompositeFilter.Type combiningMethod;

        public CombiningMethodElement(String name, CompositeFilter.Type combiningMethod) {
            this.name = name;
            this.combiningMethod = combiningMethod;
        }

        public String toString() {
            return this.name;
        }
    }
}

