/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal;

import java.util.HashMap;
import java.util.Map;
import org.cytoscape.filter.internal.MemoizableTransformer;
import org.cytoscape.filter.model.AbstractTransformer;
import org.cytoscape.filter.model.CompositeFilter;
import org.cytoscape.filter.model.Filter;
import org.cytoscape.filter.model.TransformerListener;
import org.cytoscape.model.CyIdentifiable;

public abstract class AbstractMemoizableTransformer<C, E extends CyIdentifiable>
extends AbstractTransformer<C, E>
implements MemoizableTransformer {
    private Filter<C, E> memoizedFilter;

    protected abstract CompositeFilter<C, E> getCompositeFilter();

    protected Filter<C, E> getMemoizedFilter() {
        if (this.memoizedFilter == null) {
            this.memoizedFilter = this.getCompositeFilter();
        }
        return this.memoizedFilter;
    }

    @Override
    public void startCaching() {
        CompositeFilter<C, E> subfilter = this.getCompositeFilter();
        if (subfilter.getLength() > 0) {
            if (subfilter instanceof MemoizableTransformer) {
                ((MemoizableTransformer)subfilter).startCaching();
            }
            this.memoizedFilter = this.memoize((Filter)subfilter);
        }
    }

    @Override
    public void clearCache() {
        CompositeFilter<C, E> subfilter = this.getCompositeFilter();
        this.memoizedFilter = subfilter;
        if (subfilter instanceof MemoizableTransformer) {
            ((MemoizableTransformer)subfilter).clearCache();
        }
    }

    public <A, B extends CyIdentifiable> Filter<A, B> memoize(final Filter<A, B> filter) {
        return new Filter<A, B>(){
            private Map<Long, Boolean> cache = new HashMap<Long, Boolean>();

            public boolean accepts(A context, B element) {
                Boolean value = this.cache.get(element.getSUID());
                if (value == null) {
                    value = filter.accepts(context, element);
                    this.cache.put(element.getSUID(), value);
                }
                return value;
            }

            public String getName() {
                return filter.getName();
            }

            public String getId() {
                return filter.getId();
            }

            public Class<A> getContextType() {
                return filter.getContextType();
            }

            public Class<B> getElementType() {
                return filter.getElementType();
            }

            public void addListener(TransformerListener listener) {
                filter.addListener(listener);
            }

            public void removeListener(TransformerListener listener) {
                filter.removeListener(listener);
            }

            public boolean isAlwaysFalse() {
                return filter.isAlwaysFalse();
            }
        };
    }
}

