/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal.column;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cytoscape.equations.Equation;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.internal.column.ColumnData;

public class EquationSupport
implements ColumnData {
    private final ColumnData delegate;
    private final Map<Object, Object> equations;

    public EquationSupport(ColumnData delegate) {
        this.delegate = delegate;
        this.equations = new HashMap<Object, Object>();
    }

    @Override
    public boolean put(Object key, Object value) {
        if (value instanceof Equation) {
            this.equations.put(key, value);
            this.delegate.remove(key);
            return true;
        }
        this.equations.remove(key);
        return this.delegate.put(key, value);
    }

    @Override
    public Object get(Object key) {
        Object equation = this.equations.get(key);
        if (equation == null) {
            return this.delegate.get(key);
        }
        return equation;
    }

    @Override
    public boolean remove(Object key) {
        if (this.equations.remove(key) != null) {
            return true;
        }
        return this.delegate.remove(key);
    }

    @Override
    public Set<Object> keySet() {
        return Sets.union(this.delegate.keySet(), this.equations.keySet());
    }

    @Override
    public int countMatchingRows(Object value) {
        return this.delegate.countMatchingRows(value);
    }

    @Override
    public Collection<CyRow> getMatchingRows(Map<Object, CyRow> rows, Object value) {
        return this.delegate.getMatchingRows(rows, value);
    }

    @Override
    public <T> Collection<T> getMatchingKeys(Object value, Class<T> type) {
        return this.delegate.getMatchingKeys(value, type);
    }
}

