/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import java.util.List;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.ColumnCreatedEvent;
import org.cytoscape.model.events.ColumnCreatedListener;
import org.cytoscape.model.internal.WeakMapList;

class VirtualColumnAdder
implements ColumnCreatedListener {
    private final WeakMapList<CyTable, CyTable> tables;
    private final Object lock = new Object();

    VirtualColumnAdder() {
        this.tables = new WeakMapList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(ColumnCreatedEvent e) {
        List<CyTable> targets;
        CyTable src = (CyTable)e.getSource();
        Object object = this.lock;
        synchronized (object) {
            targets = this.tables.get(src);
        }
        String srcName = e.getColumnName();
        CyColumn srcCol = src.getColumn(srcName);
        for (CyTable tgt : targets) {
            tgt.addVirtualColumn(srcName, srcName, src, "SUID", srcCol.isImmutable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInterestedTables(CyTable src, CyTable tgt) {
        if (src == null) {
            throw new NullPointerException("source table is null");
        }
        if (tgt == null) {
            throw new NullPointerException("target table is null");
        }
        if (src == tgt) {
            throw new IllegalArgumentException("source and target tables cannot be the same.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.tables.put(src, tgt);
        }
    }
}

