/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.VirtualColumnInfo;
import org.cytoscape.model.internal.CyTableImpl;

final class VirtualColumn
implements VirtualColumnInfo {
    private final CyTableImpl sourceTable;
    private final CyColumn sourceColumn;
    private final CyTableImpl targetTable;
    private final CyColumn sourceJoinColumn;
    private final CyColumn targetJoinColumn;
    private final boolean isImmutable;

    VirtualColumn(CyTableImpl sourceTable, String sourceColumnName, CyTableImpl targetTable, String sourceJoinColumnName, String targetJoinColumnName, boolean isImmutable) {
        this.sourceTable = sourceTable;
        this.sourceColumn = sourceTable.getColumn(sourceColumnName);
        this.targetTable = targetTable;
        this.sourceJoinColumn = sourceTable.getColumn(sourceJoinColumnName);
        this.targetJoinColumn = targetTable.getColumn(targetJoinColumnName);
        this.isImmutable = isImmutable;
    }

    Object getRawValue(Object targetKey) {
        CyRow sourceRow = this.getSourceRow(targetKey);
        return sourceRow == null ? null : sourceRow.getRaw(this.sourceColumn.getName());
    }

    void setValue(Object targetKey, Object value) {
        CyRow sourceRow = this.getSourceRow(targetKey);
        if (sourceRow == null) {
            throw new IllegalArgumentException("can't set a value for a virtual column.");
        }
        sourceRow.set(this.sourceColumn.getName(), value);
    }

    Object getValue(Object targetKey) {
        CyRow sourceRow = this.getSourceRow(targetKey);
        if (sourceRow == null) {
            return null;
        }
        Object retValue = sourceRow.get(this.sourceColumn.getName(), this.sourceColumn.getType());
        if (retValue == null) {
            this.targetTable.lastInternalError = this.sourceTable.getLastInternalError();
        }
        return retValue;
    }

    Object getListValue(Object targetKey) {
        CyRow sourceRow = this.getSourceRow(targetKey);
        if (sourceRow == null) {
            return null;
        }
        List retValue = sourceRow.getList(this.sourceColumn.getName(), this.sourceColumn.getListElementType());
        if (retValue == null) {
            this.targetTable.lastInternalError = this.sourceTable.getLastInternalError();
        }
        return retValue;
    }

    private CyRow getSourceRow(Object targetKey) {
        Object joinKey = this.targetTable.getValue(targetKey, this.targetJoinColumn.getName());
        if (joinKey == null) {
            return null;
        }
        return this.sourceTable.getRow(joinKey);
    }

    Collection<CyRow> getMatchingRows(Object value) {
        Collection<CyRow> sourceRows = this.sourceTable.getMatchingRows(this.sourceColumn.getName(), value);
        HashSet<CyRow> targetRows = new HashSet<CyRow>();
        for (CyRow sourceRow : sourceRows) {
            Object targetValue = sourceRow.get(this.sourceJoinColumn.getName(), this.sourceJoinColumn.getType());
            if (targetValue == null) continue;
            Collection<CyRow> rows = this.targetTable.getMatchingRows(this.targetJoinColumn.getName(), targetValue);
            targetRows.addAll(rows);
        }
        return targetRows;
    }

    <T> Collection<T> getMatchingKeys(Object value, Class<T> type) {
        Collection<T> keys = this.sourceTable.getMatchingKeys(this.sourceColumn.getName(), value, type);
        keys.retainAll(this.targetJoinColumn.getValues(this.targetJoinColumn.getType()));
        return keys;
    }

    int countMatchingRows(Object value) {
        return this.getMatchingKeys(value, this.sourceColumn.getType()).size();
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public String getSourceColumn() {
        return this.sourceColumn.getName();
    }

    public String getSourceJoinKey() {
        return this.sourceJoinColumn.getName();
    }

    public CyTable getSourceTable() {
        return this.sourceTable;
    }

    public String getTargetJoinKey() {
        return this.targetJoinColumn.getName();
    }

    public boolean isVirtual() {
        return true;
    }
}

