/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import cern.colt.map.tobject.OpenLongObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.internal.EdgePointer;
import org.cytoscape.model.internal.NodePointer;

class SimpleNetwork {
    private final Long suid;
    private final OpenLongObjectHashMap nodePointers;
    private final OpenLongObjectHashMap edgePointers;
    private int nodeCount;
    private int edgeCount;
    private NodePointer firstNode;
    private Object lock = new Object();

    SimpleNetwork(long suid) {
        this.suid = suid;
        this.nodeCount = 0;
        this.edgeCount = 0;
        this.firstNode = null;
        this.nodePointers = new OpenLongObjectHashMap();
        this.edgePointers = new OpenLongObjectHashMap();
    }

    public Long getSUID() {
        return this.suid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNodeCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.nodeCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEdgeCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.edgeCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyEdge getEdge(long e) {
        Object object = this.lock;
        synchronized (object) {
            EdgePointer ep = (EdgePointer)this.edgePointers.get(e);
            if (ep != null) {
                return ep.cyEdge;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyNode getNode(long n) {
        Object object = this.lock;
        synchronized (object) {
            NodePointer np = (NodePointer)this.nodePointers.get(n);
            if (np != null) {
                return np.cyNode;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CyNode> getNodeList() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<CyNode> ret = new ArrayList<CyNode>(this.nodeCount);
            NodePointer node = this.firstNode;
            for (int numRemaining = this.nodeCount; numRemaining > 0; --numRemaining) {
                CyNode toAdd = node.cyNode;
                node = node.nextNode;
                ret.add(toAdd);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CyEdge> getEdgeList() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<CyEdge> ret = new ArrayList<CyEdge>(this.edgeCount);
            EdgePointer edge = null;
            NodePointer node = this.firstNode;
            for (int numRemaining = this.edgeCount; numRemaining > 0; --numRemaining) {
                CyEdge retEdge;
                if (edge != null) {
                    retEdge = edge.cyEdge;
                } else {
                    edge = node.firstOutEdge;
                    while (edge == null) {
                        node = node.nextNode;
                        edge = node.firstOutEdge;
                    }
                    node = node.nextNode;
                    retEdge = edge.cyEdge;
                }
                edge = edge.nextOutEdge;
                ret.add(retEdge);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CyNode> getNeighborList(CyNode n, CyEdge.Type e) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.containsNode(n)) {
                return Collections.emptyList();
            }
            NodePointer np = this.getNodePointer(n);
            ArrayList<CyNode> ret = new ArrayList<CyNode>(this.countEdges(np, e));
            Iterator<EdgePointer> it = this.edgesAdjacent(np, e);
            while (it.hasNext()) {
                EdgePointer edge = it.next();
                long neighborIndex = np.index ^ edge.source.index ^ edge.target.index;
                ret.add(this.getNode(neighborIndex));
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CyEdge> getAdjacentEdgeList(CyNode n, CyEdge.Type e) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.containsNode(n)) {
                return Collections.emptyList();
            }
            NodePointer np = this.getNodePointer(n);
            ArrayList<CyEdge> ret = new ArrayList<CyEdge>(this.countEdges(np, e));
            Iterator<EdgePointer> it = this.edgesAdjacent(np, e);
            while (it.hasNext()) {
                ret.add(it.next().cyEdge);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<CyEdge> getAdjacentEdgeIterable(CyNode n, CyEdge.Type e) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.containsNode(n)) {
                return Collections.emptyList();
            }
            NodePointer np = this.getNodePointer(n);
            return new IterableEdgeIterator(this.edgesAdjacent(np, e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CyEdge> getConnectingEdgeList(CyNode src, CyNode trg, CyEdge.Type e) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.containsNode(src)) {
                return Collections.emptyList();
            }
            if (!this.containsNode(trg)) {
                return Collections.emptyList();
            }
            NodePointer srcP = this.getNodePointer(src);
            NodePointer trgP = this.getNodePointer(trg);
            ArrayList<CyEdge> ret = new ArrayList<CyEdge>(Math.min(this.countEdges(srcP, e), this.countEdges(trgP, e)));
            Iterator<EdgePointer> it = this.edgesConnecting(srcP, trgP, e);
            while (it.hasNext()) {
                ret.add(it.next().cyEdge);
            }
            return ret;
        }
    }

    CyNode addNodeInternal(CyNode node) {
        if (this.containsNode(node)) {
            return node;
        }
        NodePointer n = new NodePointer(node);
        this.nodePointers.put(node.getSUID().longValue(), (Object)n);
        ++this.nodeCount;
        this.firstNode = n.insert(this.firstNode);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeNodesInternal(Collection<CyNode> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return false;
        }
        boolean madeChanges = false;
        Object object = this.lock;
        synchronized (object) {
            for (CyNode n : nodes) {
                if (!this.containsNode(n)) continue;
                this.removeEdgesInternal(this.getAdjacentEdgeList(n, CyEdge.Type.ANY));
                NodePointer node = (NodePointer)this.nodePointers.get(n.getSUID().longValue());
                this.nodePointers.removeKey(n.getSUID().longValue());
                this.firstNode = node.remove(this.firstNode);
                --this.nodeCount;
                madeChanges = true;
            }
        }
        return madeChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CyEdge addEdgeInternal(CyNode s, CyNode t, boolean directed, CyEdge edge) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.containsNode(s)) {
                throw new IllegalArgumentException("source node is not a member of this network");
            }
            if (!this.containsNode(t)) {
                throw new IllegalArgumentException("target node is not a member of this network");
            }
            if (this.containsEdge(edge)) {
                return edge;
            }
            NodePointer source = this.getNodePointer(s);
            NodePointer target = this.getNodePointer(t);
            EdgePointer e = new EdgePointer(source, target, directed, edge);
            this.edgePointers.put(edge.getSUID().longValue(), (Object)e);
            ++this.edgeCount;
        }
        return edge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeEdgesInternal(Collection<CyEdge> edges) {
        if (edges == null || edges.isEmpty()) {
            return false;
        }
        boolean madeChanges = false;
        Object object = this.lock;
        synchronized (object) {
            for (CyEdge edge : edges) {
                if (!this.containsEdge(edge)) continue;
                EdgePointer e = (EdgePointer)this.edgePointers.get(edge.getSUID().longValue());
                this.edgePointers.removeKey(edge.getSUID().longValue());
                e.remove();
                --this.edgeCount;
                madeChanges = true;
            }
        }
        return madeChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsNode(CyNode node) {
        NodePointer thisNode;
        if (node == null) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            thisNode = (NodePointer)this.nodePointers.get(node.getSUID().longValue());
        }
        if (thisNode == null) {
            return false;
        }
        return thisNode.cyNode.equals(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEdge(CyEdge edge) {
        EdgePointer thisEdge;
        if (edge == null) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            thisEdge = (EdgePointer)this.edgePointers.get(edge.getSUID().longValue());
        }
        if (thisEdge == null) {
            return false;
        }
        return thisEdge.cyEdge.equals(edge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEdge(CyNode n1, CyNode n2) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.containsNode(n1)) {
                return false;
            }
            if (!this.containsNode(n2)) {
                return false;
            }
            Iterator<EdgePointer> it = this.edgesConnecting(this.getNodePointer(n1), this.getNodePointer(n2), CyEdge.Type.ANY);
            return it.hasNext();
        }
    }

    private Iterator<EdgePointer> edgesAdjacent(NodePointer n, CyEdge.Type edgeType) {
        assert (n != null);
        final boolean incoming = this.assessIncoming(edgeType);
        final boolean outgoing = this.assessOutgoing(edgeType);
        final boolean undirected = this.assessUndirected(edgeType);
        final EdgePointer[] edgeLists = undirected || outgoing && incoming ? new EdgePointer[]{n.firstOutEdge, n.firstInEdge} : (outgoing ? new EdgePointer[]{n.firstOutEdge, null} : (incoming ? new EdgePointer[]{null, n.firstInEdge} : new EdgePointer[]{null, null}));
        final int inEdgeCount = this.countEdges(n, edgeType);
        return new Iterator<EdgePointer>(){
            private int numRemaining;
            private int edgeListIndex;
            private EdgePointer edge;
            {
                this.numRemaining = inEdgeCount;
                this.edgeListIndex = -1;
            }

            @Override
            public boolean hasNext() {
                return this.numRemaining > 0;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public EdgePointer next() {
                while (this.edge == null) {
                    this.edge = edgeLists[++this.edgeListIndex];
                }
                long returnIndex = -1L;
                if (this.edgeListIndex == 0) {
                    while (!(this.edge == null || outgoing && this.edge.directed || undirected && !this.edge.directed)) {
                        this.edge = this.edge.nextOutEdge;
                        if (this.edge != null) continue;
                        this.edge = edgeLists[++this.edgeListIndex];
                        break;
                    }
                    if (this.edge != null && this.edgeListIndex == 0) {
                        returnIndex = this.edge.index;
                        this.edge = this.edge.nextOutEdge;
                    }
                }
                if (this.edgeListIndex == 1) {
                    while (this.edge.source.index == this.edge.target.index && (outgoing && this.edge.directed || undirected && !this.edge.directed) || (!incoming || !this.edge.directed) && (!undirected || this.edge.directed)) {
                        this.edge = this.edge.nextInEdge;
                    }
                    returnIndex = this.edge.index;
                    this.edge = this.edge.nextInEdge;
                }
                --this.numRemaining;
                return (EdgePointer)SimpleNetwork.this.edgePointers.get(returnIndex);
            }
        };
    }

    private Iterator<EdgePointer> edgesConnecting(NodePointer node0, NodePointer node1, CyEdge.Type et) {
        long nodeOne;
        long nodeZero;
        Iterator<EdgePointer> theAdj;
        assert (node0 != null);
        assert (node1 != null);
        if (this.countEdges(node0, et) <= this.countEdges(node1, et)) {
            theAdj = this.edgesAdjacent(node0, et);
            nodeZero = node0.index;
            nodeOne = node1.index;
        } else {
            theAdj = this.edgesAdjacent(node1, et);
            nodeZero = node1.index;
            nodeOne = node0.index;
        }
        return new Iterator<EdgePointer>(){
            private long nextIndex = -1L;

            private void ensureComputeNext() {
                if (this.nextIndex != -1L) {
                    return;
                }
                while (theAdj.hasNext()) {
                    EdgePointer e = (EdgePointer)theAdj.next();
                    if (nodeOne != (nodeZero ^ e.source.index ^ e.target.index)) continue;
                    this.nextIndex = e.index;
                    return;
                }
                this.nextIndex = -2L;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                this.ensureComputeNext();
                return this.nextIndex >= 0L;
            }

            @Override
            public EdgePointer next() {
                this.ensureComputeNext();
                long returnIndex = this.nextIndex;
                this.nextIndex = -1L;
                return (EdgePointer)SimpleNetwork.this.edgePointers.get(returnIndex);
            }
        };
    }

    private boolean assessUndirected(CyEdge.Type e) {
        return e == CyEdge.Type.UNDIRECTED || e == CyEdge.Type.ANY;
    }

    private boolean assessIncoming(CyEdge.Type e) {
        return e == CyEdge.Type.DIRECTED || e == CyEdge.Type.ANY || e == CyEdge.Type.INCOMING;
    }

    private boolean assessOutgoing(CyEdge.Type e) {
        return e == CyEdge.Type.DIRECTED || e == CyEdge.Type.ANY || e == CyEdge.Type.OUTGOING;
    }

    private int countEdges(NodePointer n, CyEdge.Type edgeType) {
        assert (n != null);
        boolean undirected = this.assessUndirected(edgeType);
        boolean incoming = this.assessIncoming(edgeType);
        boolean outgoing = this.assessOutgoing(edgeType);
        int count = 0;
        if (outgoing) {
            count += n.outDegree;
        }
        if (incoming) {
            count += n.inDegree;
        }
        if (undirected) {
            count += n.undDegree;
        }
        if (outgoing && incoming) {
            count -= n.selfEdges;
        }
        return count;
    }

    private NodePointer getNodePointer(CyNode node) {
        assert (node != null);
        return (NodePointer)this.nodePointers.get(node.getSUID().longValue());
    }

    public boolean equals(Object o) {
        if (!(o instanceof SimpleNetwork)) {
            return false;
        }
        SimpleNetwork ag = (SimpleNetwork)o;
        return ag.suid.longValue() == this.suid.longValue();
    }

    public int hashCode() {
        return (int)(this.suid ^ this.suid >>> 32);
    }

    public String toString() {
        return "CyNetwork: " + this.suid;
    }

    private class IterableEdgeIterator
    implements Iterator<CyEdge>,
    Iterable<CyEdge> {
        private final Iterator<EdgePointer> epIterator;

        IterableEdgeIterator(Iterator<EdgePointer> epIterator) {
            this.epIterator = epIterator;
        }

        @Override
        public CyEdge next() {
            return this.epIterator.next().cyEdge;
        }

        @Override
        public boolean hasNext() {
            return this.epIterator.hasNext();
        }

        @Override
        public void remove() {
            this.epIterator.remove();
        }

        @Override
        public Iterator<CyEdge> iterator() {
            return this;
        }
    }
}

