/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import java.util.ArrayList;
import java.util.List;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.internal.AbstractTableFacade;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SharedTableFacade
extends AbstractTableFacade
implements CyTable {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final CyTable shared;
    private final CyRootNetwork rootNetwork;
    private final Class<? extends CyIdentifiable> type;
    private final CyNetworkTableManager netTableMgr;

    public SharedTableFacade(CyTable shared, CyRootNetwork rootNetwork, Class<? extends CyIdentifiable> type, CyNetworkTableManager netTableMgr, CyEventHelper eventHelper) {
        super(shared, eventHelper);
        this.shared = shared;
        this.rootNetwork = rootNetwork;
        this.type = type;
        this.netTableMgr = netTableMgr;
    }

    CyTable getActualTable() {
        return this.shared;
    }

    private List<CyTable> localTables() {
        logger.debug("  - looking for local tables: ");
        ArrayList<CyTable> tables = new ArrayList<CyTable>();
        CyTable rootTbl = this.netTableMgr.getTable((CyNetwork)this.rootNetwork, this.type, "LOCAL_ATTRS");
        if (rootTbl != null) {
            tables.add(rootTbl);
        }
        for (CyNetwork sub : this.rootNetwork.getSubNetworkList()) {
            logger.debug("  -- found subnetwork with local tables: " + sub.toString());
            CyTable netTbl = this.netTableMgr.getTable(sub, this.type, "LOCAL_ATTRS");
            if (netTbl == null) continue;
            tables.add(netTbl);
        }
        return tables;
    }

    private void checkIfAlreadyExists(String columnName) {
        List<CyTable> tables = this.localTables();
        if (this.shared != null) {
            tables.add(0, this.shared);
        }
        for (CyTable table : tables) {
            CyColumn column = table.getColumn(columnName);
            if (column == null) continue;
            throw new IllegalArgumentException("column already exists with name: '" + columnName + "' with type: " + column.getType() + "\nin table: " + table.getTitle());
        }
    }

    public void deleteColumn(String columnName) {
        for (CyTable local : this.localTables()) {
            logger.debug("deleting virtual column: " + columnName + " from local table: " + local.getTitle());
            local.deleteColumn(columnName);
        }
        logger.debug("deleting shared column: " + columnName + " from shared table: " + this.shared.getTitle());
        this.shared.deleteColumn(columnName);
    }

    public <T> void createColumn(String columnName, Class<? extends T> type, boolean isImmutable) {
        this.createColumn(columnName, type, isImmutable, null);
    }

    public <T> void createColumn(String columnName, Class<? extends T> type, boolean isImmutable, T defaultValue) {
        this.checkIfAlreadyExists(columnName);
        logger.debug("adding real column: '" + columnName + "' to table: " + this.shared.getTitle());
        this.shared.createColumn(columnName, type, isImmutable, defaultValue);
        for (CyTable local : this.localTables()) {
            logger.debug("adding virtual column: " + columnName + " to local table: " + local.getTitle());
            local.addVirtualColumn(columnName, columnName, this.shared, "SUID", isImmutable);
        }
    }

    public <T> void createListColumn(String columnName, Class<T> listElementType, boolean isImmutable) {
        this.createListColumn(columnName, listElementType, isImmutable, null);
    }

    public <T> void createListColumn(String columnName, Class<T> listElementType, boolean isImmutable, List<T> defaultValue) {
        this.checkIfAlreadyExists(columnName);
        logger.debug("adding real List column: '" + columnName + "' to table: " + this.shared.getTitle());
        this.shared.createListColumn(columnName, listElementType, isImmutable, defaultValue);
        for (CyTable local : this.localTables()) {
            logger.debug("adding virtual list column: " + columnName + " to local table: " + local.getTitle());
            local.addVirtualColumn(columnName, columnName, this.shared, "SUID", isImmutable);
        }
    }

    public String addVirtualColumn(String virtualColumn, String sourceColumn, CyTable sourceTable, String targetJoinKey, boolean isImmutable) {
        this.checkIfAlreadyExists(virtualColumn);
        this.shared.addVirtualColumn(virtualColumn, sourceColumn, sourceTable, targetJoinKey, isImmutable);
        for (CyTable local : this.localTables()) {
            local.addVirtualColumn(virtualColumn, sourceColumn, sourceTable, targetJoinKey, isImmutable);
        }
        return virtualColumn;
    }

    public void addVirtualColumns(CyTable sourceTable, String targetJoinKey, boolean isImmutable) {
        for (CyColumn column : sourceTable.getColumns()) {
            if (column == sourceTable.getPrimaryKey()) continue;
            this.checkIfAlreadyExists(column.getName());
        }
        this.shared.addVirtualColumns(sourceTable, targetJoinKey, isImmutable);
        for (CyTable local : this.localTables()) {
            local.addVirtualColumns(sourceTable, targetJoinKey, isImmutable);
        }
    }

    @Override
    protected void updateColumnName(String oldName, String newName) {
        for (CyTable local : this.localTables()) {
            local.getColumn(oldName).setName(newName);
        }
        this.shared.getColumn(oldName).setName(newName);
    }
}

