/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.SavePolicy;
import org.cytoscape.model.events.AboutToRemoveEdgesEvent;
import org.cytoscape.model.events.AboutToRemoveNodesEvent;
import org.cytoscape.model.events.AddedEdgesEvent;
import org.cytoscape.model.events.AddedNodesEvent;
import org.cytoscape.model.events.NetworkAddedEvent;
import org.cytoscape.model.events.NetworkAddedListener;
import org.cytoscape.model.events.RemovedEdgesEvent;
import org.cytoscape.model.events.RemovedNodesEvent;
import org.cytoscape.model.internal.CyRootNetworkImpl;
import org.cytoscape.model.internal.DefaultTablesNetwork;
import org.cytoscape.model.internal.SharedTableFacade;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;

public final class CySubNetworkImpl
extends DefaultTablesNetwork
implements CySubNetwork,
NetworkAddedListener {
    private SavePolicy savePolicy;
    private final CyRootNetworkImpl parent;
    private boolean fireAddedNodesAndEdgesEvents;
    private final CyTableManager tableMgr;
    private final CyNetworkTableManager networkTableMgr;

    CySubNetworkImpl(CyRootNetworkImpl par, long suid, CyEventHelper eventHelper, CyTableManager tableMgr, CyNetworkTableManager netTableMgr, CyTableFactory tableFactory, boolean publicTables, int tableSizeDeterminer, SavePolicy savePolicy) {
        super(suid, netTableMgr, tableFactory, publicTables, tableSizeDeterminer, eventHelper);
        assert (par != null);
        assert (savePolicy != null);
        this.parent = par;
        this.tableMgr = tableMgr;
        this.networkTableMgr = netTableMgr;
        this.savePolicy = savePolicy;
        this.initTables((CyNetwork)this, (SharedTableFacade)this.networkTableMgr.getTable((CyNetwork)this.parent, CyNetwork.class, "SHARED_DEFAULT_ATTRS"), (SharedTableFacade)this.networkTableMgr.getTable((CyNetwork)this.parent, CyNode.class, "SHARED_DEFAULT_ATTRS"), (SharedTableFacade)this.networkTableMgr.getTable((CyNetwork)this.parent, CyEdge.class, "SHARED_DEFAULT_ATTRS"));
        this.fireAddedNodesAndEdgesEvents = false;
    }

    public CyRootNetwork getRootNetwork() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyNode addNode() {
        CyNode ret;
        CySubNetworkImpl cySubNetworkImpl = this;
        synchronized (cySubNetworkImpl) {
            ret = this.parent.addNode();
            this.addNodeInternal(ret);
            this.getRow((CyIdentifiable)ret).set("selected", (Object)false);
        }
        if (this.fireAddedNodesAndEdgesEvents) {
            this.eventHelper.addEventPayload((Object)this, (Object)ret, AddedNodesEvent.class);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addNode(CyNode node) {
        if (node == null) {
            throw new NullPointerException("node is null");
        }
        CySubNetworkImpl cySubNetworkImpl = this;
        synchronized (cySubNetworkImpl) {
            if (this.containsNode(node)) {
                return false;
            }
            if (!this.parent.containsNode(node) && !this.parent.cachedNode(node)) {
                throw new IllegalArgumentException("node is not contained in parent network.");
            }
            this.addNodeInternal(node);
            if (this.parent.cachedNode(node)) {
                this.parent.restoreNode(node);
            }
            this.copyTableData((CyIdentifiable)node);
        }
        if (this.fireAddedNodesAndEdgesEvents) {
            this.eventHelper.addEventPayload((Object)this, (Object)node, AddedNodesEvent.class);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyEdge addEdge(CyNode source, CyNode target, boolean isDirected) {
        CyEdge ret;
        CySubNetworkImpl cySubNetworkImpl = this;
        synchronized (cySubNetworkImpl) {
            ret = this.parent.addEdge(source, target, isDirected);
            this.addEdgeInternal(source, target, isDirected, ret);
            this.getRow((CyIdentifiable)ret).set("selected", (Object)false);
        }
        if (this.fireAddedNodesAndEdgesEvents) {
            this.eventHelper.addEventPayload((Object)this, (Object)ret, AddedEdgesEvent.class);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEdge(CyEdge edge) {
        if (edge == null) {
            throw new NullPointerException("edge is null");
        }
        CySubNetworkImpl cySubNetworkImpl = this;
        synchronized (cySubNetworkImpl) {
            if (this.containsEdge(edge)) {
                return false;
            }
            if (!this.parent.containsEdge(edge) && !this.parent.cachedEdge(edge)) {
                throw new IllegalArgumentException("edge is not contained in parent network.");
            }
            this.addNode(edge.getSource());
            this.addNode(edge.getTarget());
            this.addEdgeInternal(edge.getSource(), edge.getTarget(), edge.isDirected(), edge);
            if (this.parent.cachedEdge(edge)) {
                this.parent.restoreEdge(edge);
            }
            this.copyTableData((CyIdentifiable)edge);
        }
        if (this.fireAddedNodesAndEdgesEvents) {
            this.eventHelper.addEventPayload((Object)this, (Object)edge, AddedEdgesEvent.class);
        }
        return true;
    }

    private void copyTableData(CyIdentifiable graphObject) {
        String name = (String)this.parent.getRow(graphObject).get("name", String.class);
        CyRow sharedTableRow = this.parent.getRow(graphObject, "SHARED_ATTRS");
        CyRow defaultTableRow = this.parent.getRow(graphObject);
        CyRow targetRow = this.getRow(graphObject);
        String sharedName = (String)sharedTableRow.get("shared name", String.class);
        if (sharedName != null) {
            targetRow.set("name", (Object)sharedName);
        } else {
            targetRow.set("name", (Object)name);
        }
        targetRow.set("selected", (Object)((Boolean)defaultTableRow.get("selected", Boolean.class)));
        if (graphObject instanceof CyEdge) {
            String interaction = (String)sharedTableRow.get("shared interaction", String.class);
            targetRow.set("interaction", (Object)interaction);
        }
    }

    public boolean removeNodes(Collection<CyNode> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return false;
        }
        this.eventHelper.fireEvent((CyEvent)new AboutToRemoveNodesEvent((CyNetwork)this, nodes));
        CyTable nodeHiddenTable = this.getTable(CyNode.class, "HIDDEN");
        CyTable nodeDefaultTable = this.getTable(CyNode.class, "USER");
        CyTable edgeHiddenTable = this.getTable(CyEdge.class, "HIDDEN");
        CyTable edgeDefaultTable = this.getTable(CyEdge.class, "USER");
        ArrayList<Long> nodeSuids = new ArrayList<Long>();
        HashSet<Long> edgeSuids = new HashSet<Long>();
        for (CyNode node : nodes) {
            if (!this.containsNode(node)) continue;
            Long nodeSuid = node.getSUID();
            if (nodeDefaultTable.rowExists((Object)nodeSuid)) {
                nodeSuids.add(nodeSuid);
            }
            for (CyEdge edge : this.getAdjacentEdgeIterable(node, CyEdge.Type.ANY)) {
                Long edgeSuid = edge.getSUID();
                if (!edgeDefaultTable.rowExists((Object)edgeSuid)) continue;
                edgeSuids.add(edgeSuid);
            }
        }
        boolean ret = this.removeNodesInternal(nodes);
        if (nodeHiddenTable != null) {
            nodeHiddenTable.deleteRows(nodeSuids);
        }
        if (nodeDefaultTable != null) {
            nodeDefaultTable.deleteRows(nodeSuids);
        }
        if (edgeHiddenTable != null) {
            edgeHiddenTable.deleteRows(edgeSuids);
        }
        if (edgeDefaultTable != null) {
            edgeDefaultTable.deleteRows(edgeSuids);
        }
        if (ret) {
            this.parent.subnetworkNodesRemoved(nodes);
        }
        if (ret) {
            this.eventHelper.fireEvent((CyEvent)new RemovedNodesEvent((CyNetwork)this));
        }
        return ret;
    }

    public boolean removeEdges(Collection<CyEdge> edges) {
        if (edges == null || edges.isEmpty()) {
            return false;
        }
        this.eventHelper.fireEvent((CyEvent)new AboutToRemoveEdgesEvent((CyNetwork)this, edges));
        CyTable hiddenTable = this.getTable(CyEdge.class, "HIDDEN");
        CyTable defaultTable = this.getTable(CyEdge.class, "USER");
        ArrayList<Long> suids = new ArrayList<Long>();
        for (CyEdge edge : edges) {
            if (!this.containsEdge(edge)) continue;
            suids.add(edge.getSUID());
        }
        boolean ret = this.removeEdgesInternal(edges);
        if (hiddenTable != null) {
            hiddenTable.deleteRows(suids);
        }
        if (defaultTable != null) {
            defaultTable.deleteRows(suids);
        }
        if (ret) {
            this.parent.subnetworkEdgesRemoved(edges);
        }
        if (ret) {
            this.eventHelper.fireEvent((CyEvent)new RemovedEdgesEvent((CyNetwork)this));
        }
        return ret;
    }

    public SavePolicy getSavePolicy() {
        return this.savePolicy;
    }

    public void handleEvent(NetworkAddedEvent e) {
        if (e.getNetwork() == this) {
            this.registerSubnetworkTables();
            this.fireAddedNodesAndEdgesEvents = true;
        }
    }

    private void registerSubnetworkTables() {
        for (CyTable table : this.networkTableMgr.getTables((CyNetwork)this, CyNetwork.class).values()) {
            this.tableMgr.addTable(table);
        }
        for (CyTable table : this.networkTableMgr.getTables((CyNetwork)this, CyNode.class).values()) {
            this.tableMgr.addTable(table);
        }
        for (CyTable table : this.networkTableMgr.getTables((CyNetwork)this, CyEdge.class).values()) {
            this.tableMgr.addTable(table);
        }
        this.updateSharedNames(this.getDefaultNodeTable(), this.parent.getSharedNodeTable());
        this.updateSharedNames(this.getDefaultEdgeTable(), this.parent.getSharedEdgeTable());
        this.updateSharedInteractions(this.getDefaultEdgeTable(), this.parent.getSharedEdgeTable());
        this.updateSharedNames(this.getDefaultNetworkTable(), this.parent.getSharedNetworkTable());
    }

    private void updateSharedNames(CyTable src, CyTable tgt) {
        for (CyRow sr : src.getAllRows()) {
            CyRow tr = tgt.getRow(sr.get("SUID", Long.class));
            if (tr.get("shared name", String.class) != null) continue;
            tr.set("shared name", (Object)((String)sr.get("name", String.class)));
        }
    }

    private void updateSharedInteractions(CyTable src, CyTable tgt) {
        for (CyRow sr : src.getAllRows()) {
            CyRow tr = tgt.getRow(sr.get("SUID", Long.class));
            if (tr.get("shared interaction", String.class) != null) continue;
            tr.set("shared interaction", (Object)((String)sr.get("interaction", String.class)));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CySubNetworkImpl)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String toString() {
        String name;
        try {
            name = (String)this.getRow((CyIdentifiable)this).get("name", String.class);
        }
        catch (NullPointerException e) {
            name = "(unavailable)";
        }
        return name;
    }

    public void dispose() {
        this.networkTableMgr.removeAllTables((CyNetwork)this);
    }
}

