/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.transformer;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.cytoscape.filter.model.CompositeFilter;
import org.cytoscape.filter.model.NamedTransformer;
import org.cytoscape.filter.model.SubFilterTransformer;
import org.cytoscape.filter.model.Transformer;
import org.cytoscape.io.internal.util.FilterIO;
import org.cytoscape.io.write.CyTransformerWriter;
import org.cytoscape.work.util.ListMultipleSelection;
import org.cytoscape.work.util.ListSingleSelection;

public class CyTransformerWriterImpl
implements CyTransformerWriter {
    private JsonFactory factory = new JsonFactory();

    public CyTransformerWriterImpl() {
        this.factory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream stream, NamedTransformer<?, ?> ... namedTransformers) throws IOException {
        try (JsonGenerator generator = this.factory.createGenerator(stream);){
            generator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
            generator.writeStartArray();
            try {
                for (NamedTransformer<?, ?> namedTransformer : namedTransformers) {
                    this.write(generator, namedTransformer);
                }
            }
            finally {
                generator.writeEndArray();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(JsonGenerator generator, NamedTransformer<?, ?> namedTransformer) throws IOException {
        generator.writeStartObject();
        try {
            generator.writeStringField("name", namedTransformer.getName());
            generator.writeArrayFieldStart("transformers");
            try {
                for (Transformer transformer : namedTransformer.getTransformers()) {
                    this.write(generator, transformer);
                }
            }
            finally {
                generator.writeEndArray();
            }
        }
        finally {
            generator.writeEndObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(JsonGenerator generator, Transformer<?, ?> transformer) throws IOException {
        block14: {
            generator.writeStartObject();
            try {
                generator.writeStringField("id", transformer.getId());
                generator.writeObjectFieldStart("parameters");
                try {
                    Map<String, Object> parameters = FilterIO.getParameters(transformer);
                    for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                        String name = entry.getKey();
                        Object value = entry.getValue();
                        this.writeField(generator, name, value);
                    }
                }
                catch (IntrospectionException e) {
                    throw new IOException(e);
                }
                finally {
                    generator.writeEndObject();
                }
                if (!(transformer instanceof CompositeFilter) && !(transformer instanceof SubFilterTransformer)) break block14;
                CompositeFilter composite = transformer instanceof SubFilterTransformer ? ((SubFilterTransformer)transformer).getCompositeFilter() : (CompositeFilter)transformer;
                generator.writeArrayFieldStart("transformers");
                try {
                    for (int i = 0; i < composite.getLength(); ++i) {
                        this.write(generator, (Transformer<?, ?>)composite.get(i));
                    }
                }
                finally {
                    generator.writeEndArray();
                }
            }
            finally {
                generator.writeEndObject();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeField(JsonGenerator generator, String name, Object value) throws IOException {
        if (value instanceof Number) {
            if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
                generator.writeNumberField(name, ((Number)value).longValue());
            } else {
                generator.writeNumberField(name, ((Number)value).doubleValue());
            }
        } else if (value instanceof ListSingleSelection) {
            Object selected = ((ListSingleSelection)value).getSelectedValue();
            this.writeField(generator, name, selected);
        } else if (value instanceof ListMultipleSelection) {
            List values = ((ListMultipleSelection)value).getSelectedValues();
            this.writeField(generator, name, values);
        } else if (value instanceof List) {
            generator.writeArrayFieldStart(name);
            try {
                for (Object object : (List)value) {
                    this.writeValue(generator, object);
                }
            }
            finally {
                generator.writeEndArray();
            }
        } else if (value instanceof Boolean) {
            generator.writeBooleanField(name, ((Boolean)value).booleanValue());
        } else if (value == null) {
            generator.writeNullField(name);
        } else if (value.getClass().isArray()) {
            generator.writeArrayFieldStart(name);
            try {
                for (int i = 0; i < Array.getLength(value); ++i) {
                    this.writeValue(generator, Array.get(value, i));
                }
            }
            finally {
                generator.writeEndArray();
            }
        } else {
            generator.writeStringField(name, value.toString());
        }
    }

    private void writeValue(JsonGenerator generator, Object object) throws IOException {
        if (object instanceof Number) {
            if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte) {
                generator.writeNumber(((Number)object).longValue());
            } else {
                generator.writeNumber(((Number)object).doubleValue());
            }
        } else if (object instanceof Boolean) {
            generator.writeBoolean(((Boolean)object).booleanValue());
        } else if (object == null) {
            generator.writeNull();
        } else {
            generator.writeString(object.toString());
        }
    }
}

