/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.sif;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.List;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SifWriter
implements CyWriter {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String DEFAULT_INTERACTION = "-";
    private static final String ENCODING = "UTF-8";
    private final OutputStream outputStream;
    private final CyNetwork network;
    private final CharsetEncoder encoder;

    public SifWriter(OutputStream outputStream, CyNetwork network) {
        this.outputStream = outputStream;
        this.network = network;
        if (Charset.isSupported(ENCODING)) {
            this.encoder = Charset.forName(ENCODING).newEncoder();
        } else {
            logger.warn("UTF-8 is not supported by this system.  This can be a problem for non-English annotations.");
            this.encoder = Charset.defaultCharset().newEncoder();
        }
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        if (taskMonitor != null) {
            taskMonitor.setProgress(0.0);
            taskMonitor.setTitle("Exporting to SIF");
            taskMonitor.setStatusMessage("Exporting current network as SIF...");
        }
        System.out.println("Encoding = " + this.encoder.charset());
        OutputStreamWriter writer = new OutputStreamWriter(this.outputStream, this.encoder);
        String lineSep = System.getProperty("line.separator");
        List nodeList = this.network.getNodeList();
        int i = 0;
        for (CyNode node : nodeList) {
            if (taskMonitor != null) {
                double percent = (double)i++ / (double)nodeList.size();
                taskMonitor.setProgress(percent);
            }
            String sourceName = (String)this.network.getRow((CyIdentifiable)node).get("name", String.class);
            List edges = this.network.getAdjacentEdgeList(node, CyEdge.Type.ANY);
            if (sourceName == null || sourceName.length() == 0) {
                throw new IllegalStateException("This network contains null or empty node name.");
            }
            if (edges.size() == 0) {
                writer.write(sourceName + lineSep);
                continue;
            }
            for (CyEdge edge : edges) {
                if (node != edge.getSource()) continue;
                CyNode target = edge.getTarget();
                String targetName = (String)this.network.getRow((CyIdentifiable)target).get("name", String.class);
                if (targetName == null || targetName.length() == 0) {
                    throw new IllegalStateException("This network contains null or empty node name.");
                }
                String interactionName = (String)this.network.getRow((CyIdentifiable)edge).get("interaction", String.class);
                if (interactionName == null) {
                    interactionName = DEFAULT_INTERACTION;
                }
                writer.write(sourceName);
                writer.write("\t");
                writer.write(interactionName);
                writer.write("\t");
                writer.write(targetName);
                writer.write(lineSep);
            }
        }
        writer.close();
        this.outputStream.close();
    }

    public void cancel() {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.close();
        }
        catch (IOException e) {
            logger.error("Could not close Outputstream for SifWriter.", (Throwable)e);
        }
    }
}

