/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.session;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.internal.util.GroupUtil;
import org.cytoscape.io.internal.util.session.SessionUtil;
import org.cytoscape.io.internal.write.datatable.CyTablesXMLWriter;
import org.cytoscape.io.write.CyNetworkViewWriterFactory;
import org.cytoscape.io.write.CyPropertyWriterManager;
import org.cytoscape.io.write.CyTableWriterManager;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.io.write.VizmapWriterManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableMetadata;
import org.cytoscape.model.SavePolicy;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.property.CyProperty;
import org.cytoscape.property.bookmark.Bookmarks;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CySession;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionWriterImpl
extends AbstractTask
implements CyWriter {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String VIZMAP_FILE = "session_vizmap.xml";
    private static final String VIZMAP_TABLE_FILE = "session_vizmap_tables.xml";
    private static final String THUMBNAIL_FILE = "session_thumbnail.png";
    private static final int THUMBNAIL_WIDTH = 96;
    private static final int THUMBNAIL_HEIGHT = 96;
    private final String cysessionDocId;
    private final String sessionDir;
    private ZipOutputStream zos;
    private TaskMonitor taskMonitor;
    private final OutputStream outputStream;
    private final CySession session;
    private final CyPropertyWriterManager propertyWriterMgr;
    private final CyTableWriterManager tableWriterMgr;
    private final VizmapWriterManager vizmapWriterMgr;
    private final CyNetworkViewWriterFactory networkViewWriterFactory;
    private final CyFileFilter bookmarksFilter;
    private final CyFileFilter propertiesFilter;
    private final CyFileFilter tableFilter;
    private final CyFileFilter vizmapFilter;
    private final GroupUtil groupUtils;
    private Map<Long, String> tableFilenamesBySUID;
    private Map<String, VisualStyle> tableVisualStylesByName;
    private final CyServiceRegistrar serviceRegistrar;

    public SessionWriterImpl(OutputStream outputStream, CySession session, CyPropertyWriterManager propertyWriterMgr, CyTableWriterManager tableWriterMgr, VizmapWriterManager vizmapWriterMgr, CyNetworkViewWriterFactory networkViewWriterFactory, CyFileFilter bookmarksFilter, CyFileFilter propertiesFilter, CyFileFilter tableFilter, CyFileFilter vizmapFilter, GroupUtil groupUtils, CyServiceRegistrar serviceRegistrar) {
        this.outputStream = outputStream;
        this.session = session;
        this.propertyWriterMgr = propertyWriterMgr;
        this.tableWriterMgr = tableWriterMgr;
        this.vizmapWriterMgr = vizmapWriterMgr;
        this.networkViewWriterFactory = networkViewWriterFactory;
        this.bookmarksFilter = bookmarksFilter;
        this.propertiesFilter = propertiesFilter;
        this.tableFilter = tableFilter;
        this.vizmapFilter = vizmapFilter;
        this.groupUtils = groupUtils;
        this.serviceRegistrar = serviceRegistrar;
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd-HH_mm");
        String now = df.format(new Date());
        this.cysessionDocId = "CytoscapeSession-" + now;
        this.sessionDir = this.cysessionDocId + "/";
        this.tableVisualStylesByName = new HashMap<String, VisualStyle>();
        for (VisualStyle vs : session.getVisualStyles()) {
            this.tableVisualStylesByName.put(vs.getTitle(), vs);
        }
    }

    public void run(TaskMonitor tm) throws Exception {
        this.taskMonitor = tm;
        try {
            this.init(tm);
            this.write(tm);
        }
        finally {
            try {
                if (this.zos != null) {
                    this.zos.close();
                }
            }
            catch (Exception e) {
                logger.error("Error closing zip output stream", (Throwable)e);
            }
        }
        this.complete(tm);
    }

    private void init(TaskMonitor tm) throws Exception {
        tm.setProgress(0.0);
        tm.setTitle("Writing Session File");
        tm.setStatusMessage("Preparing...");
        this.zos = new ZipOutputStream(this.outputStream);
        this.prepareGroups();
    }

    private void write(TaskMonitor tm) throws Exception {
        this.zipVersion();
        tm.setProgress(0.1);
        if (this.cancelled) {
            return;
        }
        tm.setStatusMessage("Saving networks...");
        this.zipNetworks();
        tm.setProgress(0.3);
        if (this.cancelled) {
            return;
        }
        tm.setStatusMessage("Saving network views...");
        this.zipNetworkViews();
        tm.setProgress(0.4);
        if (this.cancelled) {
            return;
        }
        tm.setStatusMessage("Saving tables...");
        this.zipTables();
        tm.setProgress(0.5);
        if (this.cancelled) {
            return;
        }
        tm.setStatusMessage("Saving table properties...");
        this.zipTableProperties();
        tm.setProgress(0.6);
        if (this.cancelled) {
            return;
        }
        tm.setStatusMessage("Saving visual styles...");
        this.zipVizmap();
        tm.setProgress(0.7);
        if (this.cancelled) {
            return;
        }
        tm.setStatusMessage("Saving Cytoscape properties...");
        this.zipProperties();
        this.zipSessionThumbnail();
        tm.setProgress(0.8);
        if (this.cancelled) {
            return;
        }
        this.zipFileListMap();
        tm.setProgress(0.9);
    }

    private void complete(TaskMonitor tm) {
        if (this.cancelled) {
            return;
        }
        this.groupUtils.groupsSerialized(this.session.getNetworks(), this.session.getNetworkViews());
        tm.setStatusMessage("Done.");
        tm.setProgress(1.0);
    }

    private void zipVersion() throws Exception {
        this.zos.putNextEntry(new ZipEntry(this.sessionDir + "3.0.0.version"));
        this.zos.closeEntry();
    }

    private void zipVizmap() throws Exception {
        Set networkStyles = this.session.getVisualStyles();
        Set tableStyles = this.session.getTableStyles();
        this.zos.putNextEntry(new ZipEntry(this.sessionDir + VIZMAP_FILE));
        CyWriter vizmapWriter = this.vizmapWriterMgr.getWriter(networkStyles, tableStyles, this.vizmapFilter, (OutputStream)this.zos);
        vizmapWriter.run(this.taskMonitor);
        this.zos.closeEntry();
        vizmapWriter = null;
    }

    private void zipProperties() throws Exception {
        for (CyProperty cyProps : this.session.getProperties()) {
            if (this.cancelled) {
                return;
            }
            Object filename = null;
            CyFileFilter filter = null;
            Class type = cyProps.getPropertyType();
            if (Bookmarks.class.isAssignableFrom(type)) {
                filename = "session_bookmarks.xml";
                filter = this.bookmarksFilter;
            } else if (Properties.class.isAssignableFrom(type)) {
                filename = cyProps.getName() + ".props";
                filter = this.propertiesFilter;
            } else {
                logger.error("Cannot save CyProperty \"" + cyProps.getName() + "\": type \"" + type + "\" is not supported");
                continue;
            }
            this.zos.putNextEntry(new ZipEntry(this.sessionDir + "properties/" + (String)filename));
            CyWriter propertiesWriter = this.propertyWriterMgr.getWriter(cyProps.getProperties(), filter, (OutputStream)this.zos);
            propertiesWriter.run(this.taskMonitor);
            this.zos.closeEntry();
            propertiesWriter = null;
        }
    }

    private void zipNetworks() throws Exception {
        CyRootNetworkManager rootNetworkManager = (CyRootNetworkManager)this.serviceRegistrar.getService(CyRootNetworkManager.class);
        Set networks = this.session.getNetworks();
        HashSet<CyRootNetwork> rootNetworks = new HashSet<CyRootNetwork>();
        for (CyNetwork n : networks) {
            CyRootNetwork rn = rootNetworkManager.getRootNetwork(n);
            if (rn.getSavePolicy() != SavePolicy.SESSION_FILE) continue;
            rootNetworks.add(rn);
        }
        for (CyRootNetwork rn : rootNetworks) {
            if (this.cancelled) {
                return;
            }
            String xgmmlFile = SessionUtil.getXGMMLFilename((CyNetwork)rn);
            if (xgmmlFile.contains("_ERROR")) {
                throw new Exception("Simulating exception...");
            }
            this.zos.putNextEntry(new ZipEntry(this.sessionDir + "networks/" + xgmmlFile));
            CyWriter writer = this.networkViewWriterFactory.createWriter((OutputStream)this.zos, (CyNetwork)rn);
            writer.run(this.taskMonitor);
            this.zos.closeEntry();
            writer = null;
        }
    }

    private void zipNetworkViews() throws Exception {
        Set netViews = this.session.getNetworkViews();
        for (CyNetworkView view : netViews) {
            if (this.cancelled) {
                return;
            }
            String xgmmlFile = SessionUtil.getXGMMLFilename(view);
            this.zos.putNextEntry(new ZipEntry(this.sessionDir + "views/" + xgmmlFile));
            CyWriter writer = this.networkViewWriterFactory.createWriter((OutputStream)this.zos, view);
            writer.run(this.taskMonitor);
            this.zos.closeEntry();
            writer = null;
        }
    }

    private void zipFileListMap() throws IOException {
        Map appFileMap = this.session.getAppFileListMap();
        if (appFileMap != null && appFileMap.size() > 0) {
            byte[] buf = new byte[5000];
            Set appSet = appFileMap.keySet();
            for (String appName : appSet) {
                List theFileList = (List)appFileMap.get(appName);
                if (theFileList == null || theFileList.size() == 0) continue;
                for (File theFile : theFileList) {
                    if (this.cancelled) {
                        return;
                    }
                    if (theFile == null || !theFile.exists()) continue;
                    this.zos.putNextEntry(new ZipEntry(this.sessionDir + "apps/" + appName + "/" + theFile.getName()));
                    FileInputStream fileIS = new FileInputStream(theFile);
                    int numRead = 0;
                    while ((numRead = fileIS.read(buf)) > -1) {
                        this.zos.write(buf, 0, numRead);
                    }
                    fileIS.close();
                    this.zos.closeEntry();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipTables() throws Exception {
        this.tableFilenamesBySUID = new HashMap<Long, String>();
        Set tableData = this.session.getTables();
        for (CyTableMetadata metadata : tableData) {
            if (this.cancelled) {
                return;
            }
            CyTable table = metadata.getTable();
            if (table.getSavePolicy() != SavePolicy.SESSION_FILE) continue;
            String tableTitle = SessionUtil.escape(table.getTitle());
            CyNetwork network = metadata.getNetwork();
            String filename = network == null ? String.format("global/%d-%s.cytable", table.getSUID(), tableTitle) : SessionUtil.getNetworkTableFilename(network, metadata);
            this.tableFilenamesBySUID.put(table.getSUID(), filename);
            this.zos.putNextEntry(new ZipEntry(this.sessionDir + "tables/" + filename));
            try {
                CyWriter writer = this.tableWriterMgr.getWriter(table, this.tableFilter, (OutputStream)this.zos);
                writer.run(this.taskMonitor);
            }
            finally {
                this.zos.closeEntry();
            }
        }
    }

    private void zipTableProperties() throws Exception {
        this.zos.putNextEntry(new ZipEntry(this.sessionDir + "tables/cytables.xml"));
        try {
            CyTablesXMLWriter writer = new CyTablesXMLWriter(this.serviceRegistrar, this.session.getTables(), this.session.getTableViews(), this.tableFilenamesBySUID, this.zos);
            writer.run(this.taskMonitor);
        }
        finally {
            this.zos.closeEntry();
        }
    }

    private void zipSessionThumbnail() {
        CyNetworkView view = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetworkView();
        if (view == null) {
            CyNetworkView cyNetworkView = view = this.session.getNetworkViews().isEmpty() ? null : (CyNetworkView)this.session.getNetworkViews().iterator().next();
        }
        if (view != null) {
            Collection engines = ((RenderingEngineManager)this.serviceRegistrar.getService(RenderingEngineManager.class)).getRenderingEngines((View)view);
            Image img = null;
            for (RenderingEngine re : engines) {
                try {
                    img = re.createImage(96, 96);
                    break;
                }
                catch (Throwable t) {
                    logger.error("Cannot create session thumbnail", t);
                }
            }
            if (img != null) {
                try {
                    RenderedImage ri;
                    if (img instanceof RenderedImage) {
                        ri = (RenderedImage)((Object)img);
                    } else {
                        ri = new BufferedImage(96, 96, 2);
                        Graphics g = ((BufferedImage)ri).getGraphics();
                        g.drawImage(img, 0, 0, null);
                        g.dispose();
                    }
                    this.zos.putNextEntry(new ZipEntry(this.sessionDir + THUMBNAIL_FILE));
                    ImageIO.write(ri, "png", this.zos);
                    this.zos.closeEntry();
                }
                catch (Exception e) {
                    logger.error("Cannot save session thumbnail", (Throwable)e);
                }
            }
        }
    }

    private void prepareGroups() {
        this.groupUtils.prepareGroupsForSerialization(this.session.getNetworks());
    }
}

