/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.nnf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.TaskMonitor;

public class NnfWriter
implements CyWriter {
    private OutputStream outputStream;
    private final CyServiceRegistrar serviceRegistrar;

    public NnfWriter(OutputStream outputStream, CyServiceRegistrar serviceRegistrar) {
        this.outputStream = outputStream;
        this.serviceRegistrar = serviceRegistrar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setProgress(0.0);
        taskMonitor.setStatusMessage("Exporting Nested Networks...");
        OutputStreamWriter writer = new OutputStreamWriter(this.outputStream, Charset.forName("UTF-8").newEncoder());
        Set networks = ((CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class)).getNetworkSet();
        float networkCount = networks.size();
        try {
            float writtenCount = 0.0f;
            for (CyNetwork network : networks) {
                this.writeNetwork(writer, network);
                taskMonitor.setProgress((double)Math.round((writtenCount += 1.0f) / networkCount));
            }
        }
        catch (Exception e) {
            taskMonitor.setStatusMessage("Cannot export networks as NNF.");
        }
        finally {
            ((Writer)writer).close();
        }
        taskMonitor.setProgress(1.0);
    }

    private void writeNetwork(Writer writer, CyNetwork network) throws IOException {
        String title = (String)network.getRow((CyIdentifiable)network).get("name", String.class);
        HashSet<String> encounteredNodes = new HashSet<String>();
        List edges = network.getEdgeList();
        for (CyEdge edge : edges) {
            writer.write(this.escapeID(title) + " ");
            CyNode source = edge.getSource();
            String sourceID = (String)network.getRow((CyIdentifiable)source).get("name", String.class);
            encounteredNodes.add(sourceID);
            writer.write(this.escapeID(sourceID) + " ");
            String interactionName = (String)network.getRow((CyIdentifiable)edge).get("interaction", String.class);
            if (interactionName == null) {
                interactionName = "xx";
            }
            writer.write(this.escapeID(interactionName) + " ");
            CyNode target = edge.getTarget();
            String targetID = (String)network.getRow((CyIdentifiable)target).get("name", String.class);
            encounteredNodes.add(targetID);
            writer.write(this.escapeID(targetID) + "\n");
        }
        List nodes = network.getNodeList();
        for (CyNode node : nodes) {
            String nodeID = (String)network.getRow((CyIdentifiable)node).get("name", String.class);
            if (encounteredNodes.contains(nodeID)) continue;
            writer.write(this.escapeID(title) + " " + this.escapeID(nodeID) + "\n");
        }
    }

    private String escapeID(String ID) {
        StringBuilder builder = new StringBuilder(ID.length());
        for (int i = 0; i < ID.length(); ++i) {
            char ch = ID.charAt(i);
            if (ch == ' ' || ch == '\t' || ch == '\\') {
                builder.append('\\');
            }
            builder.append(ch);
        }
        return builder.toString();
    }

    public void cancel() {
    }
}

