/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.datatable.csv;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.cytoscape.equations.Equation;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.work.TaskMonitor;

public class CSVCyWriter
implements CyWriter {
    private static final int SCHEMA_VERSION = 1;
    private final OutputStream outputStream;
    private final CyTable table;
    private final boolean writeSchema;
    private boolean isCanceled;
    private final boolean handleEquations;
    private final boolean includePrimaryKeyColumn;
    private final boolean includeVirtualColumns;
    private final CyFileFilter fileFilter;
    private String encoding;

    public CSVCyWriter(OutputStream outputStream, CyTable table, CyFileFilter fileFilter, boolean writeSchema, boolean handleEquations, boolean includePrimaryKeyColumn, boolean includeVirtualColumns, String encoding) {
        this.outputStream = outputStream;
        this.table = table;
        this.writeSchema = writeSchema;
        this.handleEquations = handleEquations;
        this.includePrimaryKeyColumn = includePrimaryKeyColumn;
        this.includeVirtualColumns = includeVirtualColumns;
        this.encoding = encoding;
        this.fileFilter = fileFilter;
    }

    public void cancel() {
        this.isCanceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor tm) throws Exception {
        tm.setProgress(0.0);
        CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter(this.outputStream, this.encoding), ',', '\"', "\r\n");
        try {
            ArrayList<CyColumn> columns = new ArrayList<CyColumn>();
            for (CyColumn column : this.table.getColumns()) {
                if (column.isPrimaryKey() && !this.includePrimaryKeyColumn || column.getVirtualColumnInfo().isVirtual() && !this.includeVirtualColumns) continue;
                columns.add(column);
            }
            tm.setProgress(0.2);
            Collections.sort(columns, new Comparator<CyColumn>(){

                @Override
                public int compare(CyColumn o1, CyColumn o2) {
                    if (o1.isPrimaryKey()) {
                        return -1;
                    }
                    if (o2.isPrimaryKey()) {
                        return 1;
                    }
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            tm.setProgress(0.4);
            if (this.writeSchema) {
                this.writeVersion(writer);
            }
            this.writeHeader(writer, columns);
            if (this.writeSchema) {
                this.writeSchema(writer, columns);
            }
            tm.setProgress(0.6);
            this.writeValues(writer, columns);
        }
        finally {
            writer.flush();
        }
        tm.setProgress(1.0);
    }

    private void writeVersion(CSVWriter writer) {
        writer.writeNext(new String[]{"CyCSV-Version", String.valueOf(1)});
    }

    private void writeSchema(CSVWriter writer, List<CyColumn> columns) {
        String[] types = new String[columns.size()];
        String[] options = new String[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            CyColumn column = columns.get(i);
            Class type = column.getType();
            types[i] = List.class.isAssignableFrom(type) ? String.format("%s<%s>", List.class.getCanonicalName(), column.getListElementType().getCanonicalName()) : type.getCanonicalName();
            options[i] = column.isImmutable() ? "" : "mutable";
        }
        writer.writeNext(types);
        writer.writeNext(options);
        String[] values = new String[2];
        values[0] = this.table.getTitle();
        StringBuilder builder = new StringBuilder();
        if (this.table.isPublic()) {
            builder.append("public");
        }
        if (this.table.getMutability() == CyTable.Mutability.MUTABLE) {
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append("mutable");
        }
        values[1] = builder.toString();
        writer.writeNext(values);
    }

    private void writeValues(CSVWriter writer, Collection<CyColumn> columns) {
        for (CyRow row : this.table.getAllRows()) {
            if (this.isCanceled) {
                return;
            }
            String[] values = new String[columns.size()];
            int index = 0;
            for (CyColumn column : columns) {
                Object rawValue;
                if (this.handleEquations && (rawValue = row.getRaw(column.getName())) instanceof Equation) {
                    values[index++] = rawValue.toString();
                    continue;
                }
                Class type = column.getType();
                if (type.equals(List.class)) {
                    StringBuilder builder = new StringBuilder();
                    boolean first = true;
                    List list = row.getList(column.getName(), column.getListElementType());
                    if (list != null) {
                        for (Object value : list) {
                            if (!first) {
                                if (this.fileFilter.getExtensions().contains("csv")) {
                                    builder.append("|");
                                } else {
                                    builder.append("\r");
                                }
                            }
                            if (value != null) {
                                builder.append(value);
                            }
                            first = false;
                        }
                        values[index] = builder.toString();
                    }
                } else {
                    Object value = row.get(column.getName(), type);
                    values[index] = value != null ? value.toString() : null;
                }
                ++index;
            }
            writer.writeNext(values);
        }
    }

    private void writeHeader(CSVWriter writer, List<CyColumn> columns) {
        String[] values = new String[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            values[i] = columns.get(i).getName();
        }
        writer.writeNext(values);
    }
}

