/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.util.xgmml;

public enum ObjectType {
    LIST("list", "List"),
    STRING("string", "String"),
    REAL("real", "Double"),
    INTEGER("integer", "Integer"),
    LONG("integer", "Long"),
    BOOLEAN("boolean", "Boolean");

    private final String xgmmlValue;
    private final String cyValue;

    private ObjectType(String xgmmlValue, String cyValue) {
        this.xgmmlValue = xgmmlValue;
        this.cyValue = cyValue;
    }

    public String getXgmmlValue() {
        return this.xgmmlValue;
    }

    public String getCyValue() {
        return this.cyValue;
    }

    public static ObjectType fromXgmmlValue(String xgmmlValue) {
        for (ObjectType c : ObjectType.values()) {
            if (!c.xgmmlValue.equalsIgnoreCase(xgmmlValue)) continue;
            return c;
        }
        return null;
    }

    public static ObjectType fromCyValue(String cyValue) {
        for (ObjectType c : ObjectType.values()) {
            if (!c.cyValue.equalsIgnoreCase(cyValue)) continue;
            return c;
        }
        return null;
    }

    public String toString() {
        return this.xgmmlValue;
    }
}

