/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.util.vizmap;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.cytoscape.io.internal.util.vizmap.CalculatorConverter;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class CalculatorConverterFactory {
    public Set<CalculatorConverter> getConverters(String propsKey) {
        HashSet<CalculatorConverter> convs = new HashSet<CalculatorConverter>();
        if (CalculatorConverter.isConvertible(propsKey)) {
            Set<String> keys = CalculatorConverterFactory.updateLegacyPropsKey(propsKey);
            for (String k : keys) {
                CalculatorConverter c = new CalculatorConverter(k, propsKey);
                convs.add(c);
            }
        }
        return convs;
    }

    static Set<String> updateLegacyPropsKey(String propsKey) {
        HashSet<String> keys = new HashSet<String>();
        String[] tokens = propsKey.split("\\.");
        if (tokens.length < 3) {
            return Collections.singleton(propsKey);
        }
        String prefix = tokens[0] + "." + tokens[1] + ".";
        String vpId = tokens[2];
        if (vpId.matches("(?i)(default)?(node|edge)LineType(Calculator)?")) {
            keys.add(prefix + vpId.replace("LineType", "LineStyle"));
            keys.add(prefix + vpId.replace("LineType", "LineWidth"));
        } else if (vpId.matches("(?i)(default)?Edge(Source|Target)Arrow(Calculator)?")) {
            keys.add(prefix + vpId.replace("Arrow", "ArrowColor"));
            keys.add(prefix + vpId.replace("Arrow", "ArrowShape"));
        } else if (vpId.matches("(?i)(default)?EdgeColor(Calculator)?")) {
            String k1 = vpId.replaceAll("(?i)EdgeColor", BasicVisualLexicon.EDGE_UNSELECTED_PAINT.getIdString());
            String k2 = vpId.replaceAll("(?i)EdgeColor", BasicVisualLexicon.EDGE_STROKE_UNSELECTED_PAINT.getIdString());
            keys.add(prefix + k1);
            keys.add(prefix + k2);
        } else {
            keys.add(propsKey);
        }
        return keys;
    }
}

