/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.util.vizmap;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.cytoscape.io.internal.util.vizmap.model.AttributeType;
import org.cytoscape.io.internal.util.vizmap.model.ContinuousMapping;
import org.cytoscape.io.internal.util.vizmap.model.ContinuousMappingPoint;
import org.cytoscape.io.internal.util.vizmap.model.Dependency;
import org.cytoscape.io.internal.util.vizmap.model.DiscreteMapping;
import org.cytoscape.io.internal.util.vizmap.model.DiscreteMappingEntry;
import org.cytoscape.io.internal.util.vizmap.model.PassthroughMapping;
import org.cytoscape.io.internal.util.vizmap.model.VisualProperty;
import org.cytoscape.io.internal.util.vizmap.model.VisualStyle;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;

public class CalculatorConverter {
    public static final byte TYPE_BOOLEAN = 1;
    public static final byte TYPE_FLOATING_POINT = 2;
    public static final byte TYPE_INTEGER = 3;
    public static final byte TYPE_STRING = 4;
    public static final byte TYPE_UNDEFINED = -1;
    public static final byte TYPE_SIMPLE_LIST = -2;
    private String propsKey;
    private String legacyPropsKey;
    private String key;
    private String legacyKey;
    private String visualPropertyId;
    private Class<? extends CyIdentifiable> targetType;
    private static final Map<Class<? extends CyIdentifiable>, Map<String, CalculatorConverter>> converters = new HashMap<Class<? extends CyIdentifiable>, Map<String, CalculatorConverter>>();
    private static final Map<String, String> oldLineStyles;
    private static final Map<String, String> oldArrowColors;

    CalculatorConverter(String propsKey, String legacyPropsKey) {
        this.propsKey = propsKey;
        this.legacyPropsKey = legacyPropsKey = propsKey.equalsIgnoreCase(legacyPropsKey) ? null : legacyPropsKey;
        this.key = propsKey.split("\\.")[2];
        this.legacyKey = legacyPropsKey != null ? legacyPropsKey.split("\\.")[2] : null;
        this.visualPropertyId = CalculatorConverter.parseVisualPropertyId(this.key);
        this.targetType = CalculatorConverter.parseTargetDataType(this.key);
    }

    public void convert(VisualStyle vs, String propsValue, Properties props) {
        if (CalculatorConverter.isDependency(this.propsKey)) {
            this.setDependency(vs, propsValue);
        } else if (CalculatorConverter.isDefaultProperty(this.propsKey)) {
            this.setDefaultProperty(vs, propsValue);
        } else if (CalculatorConverter.isMappingFunction(this.propsKey)) {
            this.setMappingFunction(vs, propsValue, props);
        }
    }

    public String getVisualPropertyId() {
        return this.visualPropertyId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String updateLegacyValue(String value) {
        if (value == null) return null;
        if (this.legacyPropsKey == null) return value;
        if (this.key.matches("(?i)(default)?(node|edge)LineStyle(Calculator)?")) {
            String[] vv = value.split("_");
            if (vv.length != 2) return null;
            return oldLineStyles.get(vv[0]);
        }
        if (this.key.matches("(?i)(default)?(node|edge)LineWidth(Calculator)?")) {
            String[] vv = value.split("_");
            if (vv.length != 2) return null;
            return vv[1];
        }
        if (this.key.matches("(?i)(default)?Edge(Source|Target)ArrowColor(Calculator)?")) {
            String[] vv;
            if (value.equalsIgnoreCase("NONE") || (vv = value.split("_")).length != 2) return null;
            return oldArrowColors.get(vv[0]);
        }
        if (!this.key.matches("(?i)(default)?Edge(Source|Target)ArrowShape(Calculator)?")) return value;
        if (value.equalsIgnoreCase("NONE")) {
            return "NONE";
        }
        String[] vv = value.split("_");
        if (vv.length != 2) return null;
        return vv[1];
    }

    private Object getMappingFunction(Properties props, String mapperName, VisualProperty vp) {
        String baseKey = null;
        String functionType = null;
        while (functionType == null) {
            baseKey = (this.legacyKey != null ? this.legacyKey : this.key) + "." + mapperName + ".mapping.";
            functionType = props.getProperty(baseKey + "type");
            if (functionType != null) continue;
            if (baseKey.startsWith("nodeFillColorCalculator.")) {
                this.legacyKey = "nodeColorCalculator";
                continue;
            }
            if (baseKey.startsWith("edgeSourceArrowCalculator.") || baseKey.startsWith("edgeTargetArrowCalculator.")) {
                this.legacyKey = "edgeArrowCalculator";
                continue;
            }
            return null;
        }
        String attrName = props.getProperty(baseKey + "controller");
        if (attrName == null) {
            return null;
        }
        if ("ID".equalsIgnoreCase(attrName)) {
            attrName = "name";
        }
        if ("DiscreteMapping".equalsIgnoreCase(functionType)) {
            String controllerTypeProp = props.getProperty(baseKey + "controllerType");
            int controllerType = controllerTypeProp != null ? (int)Byte.parseByte(controllerTypeProp) : 4;
            AttributeType attrType = null;
            if (attrName.equals("has_nested_network")) {
                attrType = AttributeType.BOOLEAN;
            } else {
                switch (controllerType) {
                    case 1: {
                        attrType = AttributeType.BOOLEAN;
                        break;
                    }
                    case 2: {
                        attrType = AttributeType.FLOAT;
                        break;
                    }
                    case 3: {
                        attrType = AttributeType.INTEGER;
                        break;
                    }
                    default: {
                        attrType = AttributeType.STRING;
                    }
                }
            }
            DiscreteMapping dm = new DiscreteMapping();
            dm.setAttributeName(attrName);
            dm.setAttributeType(attrType);
            String entryKey = baseKey + "map.";
            for (String sk : props.stringPropertyNames()) {
                if (!sk.contains(entryKey)) continue;
                String attrValue = sk.replace(entryKey, "");
                String sv = props.getProperty(sk);
                String value = this.getValue(sv);
                if (attrName.equals("has_nested_network")) {
                    attrValue = attrValue.matches("(?i)yes|true") ? "true" : "false";
                }
                DiscreteMappingEntry entry = new DiscreteMappingEntry();
                entry.setAttributeValue(attrValue);
                entry.setValue(value);
                dm.getDiscreteMappingEntry().add(entry);
            }
            return dm;
        }
        if ("ContinuousMapping".equalsIgnoreCase(functionType)) {
            ContinuousMapping cm = new ContinuousMapping();
            cm.setAttributeName(attrName);
            cm.setAttributeType(AttributeType.FLOAT);
            int boundaryValues = 0;
            try {
                String s = props.getProperty(baseKey + "boundaryvalues");
                boundaryValues = Integer.parseInt(s);
            }
            catch (NumberFormatException s) {
                // empty catch block
            }
            for (int i = 0; i < boundaryValues; ++i) {
                try {
                    BigDecimal value = new BigDecimal(props.getProperty(baseKey + "bv" + i + ".domainvalue"));
                    String lesser = this.getValue(props.getProperty(baseKey + "bv" + i + ".lesser"));
                    String equal = this.getValue(props.getProperty(baseKey + "bv" + i + ".equal"));
                    String greater = this.getValue(props.getProperty(baseKey + "bv" + i + ".greater"));
                    ContinuousMappingPoint point = new ContinuousMappingPoint();
                    point.setAttrValue(value);
                    point.setLesserValue(lesser);
                    point.setEqualValue(equal);
                    point.setGreaterValue(greater);
                    cm.getContinuousMappingPoint().add(point);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return cm;
        }
        if ("PassThroughMapping".equalsIgnoreCase(functionType)) {
            PassthroughMapping pm = new PassthroughMapping();
            pm.setAttributeName(attrName);
            pm.setAttributeType(AttributeType.STRING);
            return pm;
        }
        return null;
    }

    private void setDefaultProperty(VisualStyle vs, String sValue) {
        VisualProperty vp = this.getVisualProperty(vs);
        String value = this.getValue(sValue);
        vp.setDefault(value);
    }

    private void setMappingFunction(VisualStyle vs, String sValue, Properties props) {
        VisualProperty vp = this.getVisualProperty(vs);
        Object mapping = this.getMappingFunction(props, sValue, vp);
        if (mapping instanceof PassthroughMapping) {
            vp.setPassthroughMapping((PassthroughMapping)mapping);
        } else if (mapping instanceof ContinuousMapping) {
            vp.setContinuousMapping((ContinuousMapping)mapping);
        } else if (mapping instanceof DiscreteMapping) {
            vp.setDiscreteMapping((DiscreteMapping)mapping);
        }
    }

    private void setDependency(VisualStyle vs, String sValue) {
        Dependency d = new Dependency();
        d.setName(this.visualPropertyId);
        d.setValue(new Boolean(sValue.trim()));
        if (this.targetType == CyNetwork.class) {
            vs.getNetwork().getDependency().add(d);
        } else if (this.targetType == CyNode.class) {
            vs.getNode().getDependency().add(d);
        } else if (this.targetType == CyEdge.class) {
            vs.getEdge().getDependency().add(d);
        }
    }

    private VisualProperty getVisualProperty(VisualStyle vs) {
        VisualProperty vp = null;
        List<VisualProperty> vpList = null;
        if (this.targetType == CyNetwork.class) {
            vpList = vs.getNetwork().getVisualProperty();
        } else if (this.targetType == CyNode.class) {
            vpList = vs.getNode().getVisualProperty();
        } else if (this.targetType == CyEdge.class) {
            vpList = vs.getEdge().getVisualProperty();
        }
        for (VisualProperty v : vpList) {
            if (!v.getName().equalsIgnoreCase(this.visualPropertyId)) continue;
            vp = v;
            break;
        }
        if (vp == null) {
            vp = new VisualProperty();
            vp.setName(this.visualPropertyId);
            vpList.add(vp);
        }
        return vp;
    }

    private String getValue(String sValue) {
        if (sValue != null) {
            sValue = this.updateLegacyValue(sValue);
        }
        return sValue;
    }

    public static String parseStyleName(String key) {
        String t3;
        String[] tokens;
        String styleName = null;
        if (key != null && (tokens = key.split("\\.")).length > 2 && tokens[0].matches("(node|edge|global)[a-zA-Z]+Calculator") && tokens.length == 3 && (t3 = tokens[2]).matches("nodeSizeLocked|arrowColorMatchesEdge|nodeLabelColorFromNodeColor|defaultNodeShowNestedNetwork|nodeCustomGraphicsSizeSync|((node|edge)LabelColor)|((node|edge)[a-zA-Z]+Calculator)|(default(Node|Edge|Background|SloppySelection)[a-zA-Z0-9]+)")) {
            styleName = tokens[1];
        }
        return styleName;
    }

    static boolean isConvertible(String propsKey) {
        return CalculatorConverter.isDefaultProperty(propsKey) || CalculatorConverter.isDependency(propsKey) || CalculatorConverter.isMappingFunction(propsKey);
    }

    static boolean isDefaultProperty(String key) {
        boolean b = false;
        if (key != null) {
            b |= key.matches("globalAppearanceCalculator\\.[^\\.]+\\.default[a-zA-Z]+Color");
            b |= key.matches("nodeAppearanceCalculator\\.[^\\.]+\\.default(Node|NODE)\\w+");
            b |= key.matches("edgeAppearanceCalculator\\.[^\\.]+\\.default(Edge|EDGE)[a-zA-Z_]+");
        }
        return b;
    }

    static boolean isMappingFunction(String key) {
        boolean b = false;
        if (key != null) {
            b |= key.matches("(?i)(node|edge)AppearanceCalculator\\.[^\\.]+\\.\\1((CustomGraphics(Position)?\\d+)|LabelColor|([a-zA-Z_]+Calculator))");
        }
        return b;
    }

    static boolean isDependency(String key) {
        boolean b = false;
        if (key != null) {
            b |= key.matches("nodeAppearanceCalculator\\.[^\\.]+\\.(nodeSizeLocked|nodeLabelColorFromNodeColor|nodeCustomGraphicsSizeSync)");
            b |= key.matches("edgeAppearanceCalculator\\.[^\\.]+\\.arrowColorMatchesEdge");
        }
        return b;
    }

    static Class<? extends CyIdentifiable> parseTargetDataType(String calcKey) {
        if ((calcKey = calcKey.toLowerCase()).contains("node")) {
            return CyNode.class;
        }
        if (calcKey.contains("edge")) {
            return CyEdge.class;
        }
        return CyNetwork.class;
    }

    static String parseVisualPropertyId(String calcKey) {
        if (calcKey != null) {
            return calcKey.replaceAll("(?i)default|calculator|uniform", "").toLowerCase().trim();
        }
        return calcKey;
    }

    public String toString() {
        return "CalculatorConverter [propsKey=" + this.propsKey + ", legacyPropsKey=" + this.legacyPropsKey + ", key=" + this.key + ", legacyKey=" + this.legacyKey + ", visualPropertyId=" + this.visualPropertyId + ", targetType=" + this.targetType + "]";
    }

    static {
        converters.put(CyNode.class, new HashMap());
        converters.put(CyEdge.class, new HashMap());
        converters.put(CyNetwork.class, new HashMap());
        oldLineStyles = new HashMap<String, String>();
        oldLineStyles.put("", "SOLID");
        oldLineStyles.put("LINE", "SOLID");
        oldLineStyles.put("DASHED", "EQUAL_DASH");
        oldArrowColors = new HashMap<String, String>();
        oldArrowColors.put("WHITE", "255,255,255");
        oldArrowColors.put("BLACK", "0,0,0");
    }
}

