/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupFactory;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class GroupUtil {
    public static final String EXTERNAL_EDGE_ATTRIBUTE = "__externalEdges.SUID";
    public static final String GROUP_COLLAPSED_ATTRIBUTE = "__groupCollapsed.SUID";
    public static final String GROUP_NODE_SHOWN_ATTRIBUTE = "__groupShown.SUID";
    public static final String GROUP_NETWORKS_ATTRIBUTE = "__groupNetworks.SUID";
    public static final String GROUP_ATTRIBUTE = "__isGroup";
    public static final String ISMETA_EDGE_ATTR = "__isMetaEdge";
    public static final String X_LOCATION_ATTR = "__xLocation";
    public static final String Y_LOCATION_ATTR = "__yLocation";
    public static final String GROUP_STATE_ATTRIBUTE = "__groupState";
    public static final String GROUP_ISLOCAL_ATTRIBUTE = "__groupIsLocal";
    public static final String GROUP_NODEX_ATTRIBUTE = "__metanodeHintX";
    public static final String GROUP_NODEY_ATTRIBUTE = "__metanodeHintY";
    public static final String X_OFFSET_ATTR = "__xOffset";
    public static final String Y_OFFSET_ATTR = "__yOffset";
    private final CyServiceRegistrar serviceRegistrar;
    private Map<CyNetwork, List<CyNode>> addedNodes;

    public GroupUtil(CyServiceRegistrar serviceRegistrar) {
        assert (serviceRegistrar != null);
        this.serviceRegistrar = serviceRegistrar;
    }

    public void prepareGroupsForSerialization(Collection<CyNetwork> networks) {
        if (networks == null) {
            return;
        }
        this.addedNodes = new HashMap<CyNetwork, List<CyNode>>();
        for (CyNetwork net : networks) {
            if (!(net instanceof CySubNetwork)) continue;
            CyGroupManager groupMgr = (CyGroupManager)this.serviceRegistrar.getService(CyGroupManager.class);
            Set groupSet = groupMgr.getGroupSet(net);
            for (CyGroup group : groupSet) {
                this.updateExternalEdgeAttribute(group);
                this.updateCollapsedGroupsAttribute(group);
                this.updateGroupAttribute(net, group);
            }
        }
    }

    public void groupsSerialized(Collection<CyNetwork> networks, Collection<CyNetworkView> views) {
        if (networks == null) {
            return;
        }
        HashMap<CyNetwork, CyNetworkView> viewMap = new HashMap<CyNetwork, CyNetworkView>();
        if (views != null) {
            for (CyNetworkView view : views) {
                viewMap.put((CyNetwork)view.getModel(), view);
            }
        }
        for (CyNetwork net : networks) {
            List<CyNode> nodeList;
            if (!(net instanceof CySubNetwork) || !this.addedNodes.containsKey(net) || (nodeList = this.addedNodes.get(net)) == null || nodeList.size() <= 0) continue;
            net.removeNodes(nodeList);
            if (!viewMap.containsKey(net)) continue;
            ((CyNetworkView)viewMap.get(net)).updateView();
        }
    }

    public List<CyNode> getExpandedGroups(CyNetwork network) {
        CyGroupManager groupMgr = (CyGroupManager)this.serviceRegistrar.getService(CyGroupManager.class);
        Set groupSet = groupMgr.getGroupSet(network);
        ArrayList<CyNode> groupNodes = new ArrayList<CyNode>();
        for (CyGroup group : groupSet) {
            if (group.isCollapsed(network) || !network.containsNode(group.getGroupNode())) continue;
            groupNodes.add(group.getGroupNode());
        }
        return groupNodes;
    }

    public List<CyEdge> getGroupNodeEdges(CyNetwork network) {
        CyRootNetwork rootNetwork = ((CySubNetwork)network).getRootNetwork();
        List<CyNode> groupNodes = this.getExpandedGroups(network);
        ArrayList<CyEdge> groupNodeEdges = new ArrayList<CyEdge>();
        for (CyNode groupNode : groupNodes) {
            groupNodeEdges.addAll(rootNetwork.getAdjacentEdgeList(groupNode, CyEdge.Type.ANY));
        }
        return groupNodeEdges;
    }

    public List<CyEdge> getExternalEdges(CyNetwork network) {
        CyGroupManager groupMgr = (CyGroupManager)this.serviceRegistrar.getService(CyGroupManager.class);
        Set groupSet = groupMgr.getGroupSet(network);
        ArrayList<CyEdge> externalEdges = new ArrayList<CyEdge>();
        for (CyGroup group : groupSet) {
            if (!group.isCollapsed(network)) continue;
            externalEdges.addAll(group.getExternalEdgeList());
        }
        return externalEdges;
    }

    public void createGroups(Set<CyNetwork> networks, Set<CyNetworkView> viewSet) {
        if (networks == null) {
            return;
        }
        for (CyNetwork net : networks) {
            if (!(net instanceof CySubNetwork)) continue;
            this.createGroups((CySubNetwork)net, viewSet, new HashSet<CyNode>());
        }
    }

    private void createGroups(CySubNetwork net, Set<CyNetworkView> viewSet, Set<CyNode> collapsedChildren) {
        CyRootNetwork rootNet = net.getRootNetwork();
        List nodes = net.getNodeList();
        CyGroupFactory groupFactory = (CyGroupFactory)this.serviceRegistrar.getService(CyGroupFactory.class);
        for (CyNode n : nodes) {
            boolean cy2group;
            boolean nodeShown;
            boolean collapsed;
            CyRow snRow;
            CyNetwork netPointer;
            block22: {
                List shownList;
                block23: {
                    Integer grState;
                    CyRow dnRow;
                    block21: {
                        netPointer = n.getNetworkPointer();
                        if (netPointer == null) continue;
                        dnRow = net.getRow((CyIdentifiable)n, "USER");
                        CyRow hnRow = net.getRow((CyIdentifiable)n, "HIDDEN");
                        snRow = netPointer.getRow((CyIdentifiable)netPointer, "HIDDEN");
                        if (!dnRow.isSet(GROUP_STATE_ATTRIBUTE) && !hnRow.isSet(GROUP_STATE_ATTRIBUTE) && !hnRow.isSet(GROUP_ATTRIBUTE)) continue;
                        this.createGroups((CySubNetwork)netPointer, null, collapsedChildren);
                        collapsed = false;
                        nodeShown = false;
                        cy2group = false;
                        if (!hnRow.isSet(GROUP_STATE_ATTRIBUTE)) break block21;
                        grState = (Integer)hnRow.get(GROUP_STATE_ATTRIBUTE, Integer.class);
                        cy2group = true;
                        if (grState != 2) break block22;
                        collapsed = true;
                        break block22;
                    }
                    if (!dnRow.isSet(GROUP_STATE_ATTRIBUTE)) break block23;
                    grState = (Integer)dnRow.get(GROUP_STATE_ATTRIBUTE, Integer.class);
                    cy2group = true;
                    if (grState != 2) break block22;
                    collapsed = true;
                    break block22;
                }
                List collapsedList = snRow.getList(GROUP_COLLAPSED_ATTRIBUTE, Long.class);
                if (collapsedList != null) {
                    Iterator<Object> iterator = collapsedList.iterator();
                    while (iterator.hasNext()) {
                        Long suid = (Long)iterator.next();
                        if (!suid.equals(net.getSUID())) continue;
                        collapsed = true;
                        break;
                    }
                }
                if ((shownList = snRow.getList(GROUP_NODE_SHOWN_ATTRIBUTE, Long.class)) != null) {
                    for (Long suid : shownList) {
                        if (!suid.equals(net.getSUID())) continue;
                        nodeShown = true;
                        break;
                    }
                }
            }
            if (!collapsed) {
                if (!nodeShown) {
                    net.removeNodes(Collections.singletonList(n));
                    rootNet.restoreNode(n);
                }
                for (CyEdge edge : netPointer.getEdgeList()) {
                    if (net.containsEdge(edge)) continue;
                    net.addEdge(edge);
                }
                if (cy2group) {
                    CyTable hnTable = rootNet.getTable(CyNode.class, "HIDDEN");
                    if (hnTable.getColumn(GROUP_STATE_ATTRIBUTE) == null) {
                        hnTable.createColumn(GROUP_STATE_ATTRIBUTE, Integer.class, false);
                    }
                    hnTable.getRow((Object)n.getSUID()).set(GROUP_STATE_ATTRIBUTE, (Object)1);
                }
            }
            CyGroup group = groupFactory.createGroup((CyNetwork)net, n, true);
            if (snRow.isSet(EXTERNAL_EDGE_ATTRIBUTE)) {
                List externalIDs = snRow.getList(EXTERNAL_EDGE_ATTRIBUTE, Long.class);
                ArrayList<CyEdge> externalEdges = new ArrayList<CyEdge>();
                for (Long suid : externalIDs) {
                    CyEdge newEdge = rootNet.getEdge(suid.longValue());
                    if (newEdge == null || this.isMeta(group, newEdge) && this.metaExists(group, newEdge)) continue;
                    externalEdges.add(newEdge);
                }
                if (cy2group && collapsed) {
                    this.updateMetaEdges((CyNetwork)net, n);
                }
                group.addEdges(externalEdges);
            }
            if (cy2group) {
                if (collapsed) {
                    this.updateChildOffsets(netPointer, (CyNetwork)net, n);
                }
                if (viewSet != null && collapsed) {
                    for (CyNetworkView view : viewSet) {
                        if (((CyNetwork)view.getModel()).equals(net)) {
                            this.updateGroupNodeLocation(view, n);
                        }
                        this.disableNestedNetworkIcon(view, n);
                    }
                }
            }
            if (!collapsed) continue;
            if (collapsedChildren.contains(n) && net.containsNode(n)) {
                net.removeNodes(Collections.singleton(n));
            }
            collapsedChildren.addAll(netPointer.getNodeList());
        }
        if (net.getDefaultNodeTable().getColumn(GROUP_STATE_ATTRIBUTE) != null) {
            net.getDefaultNodeTable().deleteColumn(GROUP_STATE_ATTRIBUTE);
        }
        if (net.getDefaultNodeTable().getColumn(GROUP_ISLOCAL_ATTRIBUTE) != null) {
            net.getDefaultNodeTable().deleteColumn(GROUP_ISLOCAL_ATTRIBUTE);
        }
    }

    public void updateGroupNodes(CyNetworkView view) {
        if (view == null) {
            return;
        }
        CyNetwork network = (CyNetwork)view.getModel();
        CyGroupManager groupMgr = (CyGroupManager)this.serviceRegistrar.getService(CyGroupManager.class);
        Set groupSet = groupMgr.getGroupSet(network);
        for (CyGroup group : groupSet) {
            if (!group.isCollapsed(network)) continue;
            this.updateGroupNodeLocation(view, group.getGroupNode());
        }
    }

    public Set<CyGroup> getGroups(Collection<CyNetwork> networks) {
        HashSet<CyGroup> groups = new HashSet<CyGroup>();
        CyGroupManager groupMgr = (CyGroupManager)this.serviceRegistrar.getService(CyGroupManager.class);
        for (CyNetwork net : networks) {
            groups.addAll(groupMgr.getGroupSet(net));
        }
        return groups;
    }

    public void destroyGroups(Set<CyGroup> groups) {
        CyGroupManager groupMgr = (CyGroupManager)this.serviceRegistrar.getService(CyGroupManager.class);
        for (CyGroup gr : groups) {
            groupMgr.destroyGroup(gr);
        }
    }

    private void updateExternalEdgeAttribute(CyGroup group) {
        CyNode groupNode = group.getGroupNode();
        Set externalEdges = group.getExternalEdgeList();
        ArrayList<Long> externalEdgeSUIDs = new ArrayList<Long>();
        for (CyEdge edge : externalEdges) {
            externalEdgeSUIDs.add(edge.getSUID());
        }
        CyNetwork netPointer = groupNode.getNetworkPointer();
        CyRow snRow = netPointer.getRow((CyIdentifiable)netPointer, "HIDDEN");
        CyTable groupNetTable = snRow.getTable();
        if (groupNetTable.getColumn(EXTERNAL_EDGE_ATTRIBUTE) == null) {
            groupNetTable.createListColumn(EXTERNAL_EDGE_ATTRIBUTE, Long.class, false);
        }
        snRow.set(EXTERNAL_EDGE_ATTRIBUTE, externalEdgeSUIDs);
    }

    private void updateCollapsedGroupsAttribute(CyGroup group) {
        CyColumn groupShownColumn;
        CySubNetwork np = (CySubNetwork)group.getGroupNode().getNetworkPointer();
        CyTable hiddenTable = np.getTable(CyNetwork.class, "HIDDEN");
        CyRow netRow = hiddenTable.getRow((Object)np.getSUID());
        CyColumn stateColumn = hiddenTable.getColumn(GROUP_COLLAPSED_ATTRIBUTE);
        if (stateColumn == null) {
            hiddenTable.createListColumn(GROUP_COLLAPSED_ATTRIBUTE, Long.class, true);
        }
        if ((groupShownColumn = hiddenTable.getColumn(GROUP_NODE_SHOWN_ATTRIBUTE)) == null) {
            hiddenTable.createListColumn(GROUP_NODE_SHOWN_ATTRIBUTE, Long.class, true);
        }
        ArrayList<Long> collapsedList = new ArrayList<Long>();
        ArrayList<Long> groupNodeShownList = new ArrayList<Long>();
        for (CyNetwork net : group.getNetworkSet()) {
            if (group.isCollapsed(net)) {
                collapsedList.add(net.getSUID());
                continue;
            }
            if (!net.containsNode(group.getGroupNode())) continue;
            groupNodeShownList.add(net.getSUID());
        }
        netRow.set(GROUP_COLLAPSED_ATTRIBUTE, collapsedList);
        netRow.set(GROUP_NODE_SHOWN_ATTRIBUTE, groupNodeShownList);
    }

    private void updateGroupAttribute(CyNetwork net, CyGroup group) {
        CyTable hiddenTable;
        CyNode node = group.getGroupNode();
        if (!net.containsNode(node)) {
            CySubNetwork subNet = (CySubNetwork)net;
            subNet.addNode(node);
            List<CyNode> nodeList = this.addedNodes.containsKey(net) ? this.addedNodes.get(net) : new ArrayList<CyNode>();
            nodeList.add(node);
            this.addedNodes.put(net, nodeList);
        }
        if ((hiddenTable = net.getTable(CyNode.class, "HIDDEN")).getColumn(GROUP_ATTRIBUTE) == null) {
            hiddenTable.createColumn(GROUP_ATTRIBUTE, Boolean.class, false);
        }
        hiddenTable.getRow((Object)node.getSUID()).set(GROUP_ATTRIBUTE, (Object)Boolean.TRUE);
    }

    private void updateChildOffsets(CyNetwork netPointer, CyNetwork net, CyNode groupNode) {
        CyTable hiddenSubTable = netPointer.getTable(CyNode.class, "HIDDEN");
        this.createListColumn(hiddenSubTable, X_LOCATION_ATTR, Double.class);
        this.createListColumn(hiddenSubTable, Y_LOCATION_ATTR, Double.class);
        this.createListColumn(hiddenSubTable, GROUP_NETWORKS_ATTRIBUTE, Long.class);
        for (CyNode child : netPointer.getNodeList()) {
            CyRow row = hiddenSubTable.getRow((Object)child.getSUID());
            List<Long> networks = new ArrayList();
            List<Double> xLocation = new ArrayList();
            List<Double> yLocation = new ArrayList();
            if (row.isSet(GROUP_NETWORKS_ATTRIBUTE)) {
                networks = row.getList(GROUP_NETWORKS_ATTRIBUTE, Long.class);
            }
            if (row.isSet(X_LOCATION_ATTR)) {
                xLocation = row.getList(X_LOCATION_ATTR, Double.class);
            }
            if (row.isSet(Y_LOCATION_ATTR)) {
                yLocation = row.getList(Y_LOCATION_ATTR, Double.class);
            }
            networks.add(net.getSUID());
            if (hiddenSubTable.getColumn(GROUP_NODEX_ATTRIBUTE) != null && row.isSet(GROUP_NODEX_ATTRIBUTE)) {
                xLocation.add((Double)row.get(GROUP_NODEX_ATTRIBUTE, Double.class));
            } else {
                xLocation.add(0.0);
            }
            if (hiddenSubTable.getColumn(GROUP_NODEY_ATTRIBUTE) != null && row.isSet(GROUP_NODEY_ATTRIBUTE)) {
                yLocation.add((Double)row.get(GROUP_NODEY_ATTRIBUTE, Double.class));
            } else {
                yLocation.add(0.0);
            }
            row.set(GROUP_NETWORKS_ATTRIBUTE, networks);
            row.set(X_LOCATION_ATTR, xLocation);
            row.set(Y_LOCATION_ATTR, yLocation);
        }
    }

    private void updateMetaEdges(CyNetwork net, CyNode groupNode) {
        CyRootNetwork rootNetwork = ((CySubNetwork)net).getRootNetwork();
        List edgeList = net.getAdjacentEdgeList(groupNode, CyEdge.Type.ANY);
        for (CyEdge edge : edgeList) {
            String interaction = (String)net.getRow((CyIdentifiable)edge).get("interaction", String.class);
            if (!interaction.startsWith("meta-")) continue;
            this.createColumn(rootNetwork.getTable(CyEdge.class, "HIDDEN"), ISMETA_EDGE_ATTR, Boolean.class);
            rootNetwork.getRow((CyIdentifiable)edge, "HIDDEN").set(ISMETA_EDGE_ATTR, (Object)Boolean.TRUE);
        }
    }

    private void updateGroupNodeLocation(CyNetworkView view, CyNode groupNode) {
        if (view == null) {
            return;
        }
        CyRootNetwork rootNetwork = ((CySubNetwork)view.getModel()).getRootNetwork();
        View nView = view.getNodeView(groupNode);
        double x = (Double)nView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
        double y = (Double)nView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
        CyRow hRow = rootNetwork.getRow((CyIdentifiable)groupNode, "HIDDEN");
        this.createColumn(hRow.getTable(), X_LOCATION_ATTR, Double.class);
        this.createColumn(hRow.getTable(), Y_LOCATION_ATTR, Double.class);
        hRow.set(X_LOCATION_ATTR, (Object)new Double(x));
        hRow.set(Y_LOCATION_ATTR, (Object)new Double(y));
    }

    public void disableNestedNetworkIcon(CyNetworkView view, CyNode n) {
        View nView = view.getNodeView(n);
        nView.setLockedValue(BasicVisualLexicon.NODE_NESTED_NETWORK_IMAGE_VISIBLE, (Object)Boolean.FALSE);
    }

    private void createColumn(CyTable table, String column, Class<?> type) {
        if (table.getColumn(column) == null) {
            table.createColumn(column, type, false);
        }
    }

    private void createListColumn(CyTable table, String column, Class<?> type) {
        if (table.getColumn(column) == null) {
            table.createListColumn(column, type, false);
        }
    }

    private boolean isMeta(CyGroup group, CyEdge edge) {
        CyRootNetwork rootNetwork = group.getRootNetwork();
        if (edge.getSource() != group.getGroupNode() && edge.getTarget() != group.getGroupNode()) {
            return false;
        }
        Boolean meta = (Boolean)rootNetwork.getRow((CyIdentifiable)edge, "HIDDEN").get(ISMETA_EDGE_ATTR, Boolean.class, (Object)Boolean.FALSE);
        return meta;
    }

    private boolean metaExists(CyGroup group, CyEdge edge) {
        CyNode target;
        CyNode source;
        CyRootNetwork rootNetwork = group.getRootNetwork();
        if (edge.getSource() == group.getGroupNode()) {
            source = group.getGroupNode();
            target = edge.getTarget();
        } else {
            source = edge.getSource();
            target = group.getGroupNode();
        }
        List list = rootNetwork.getConnectingEdgeList(source, target, CyEdge.Type.DIRECTED);
        for (CyEdge e : list) {
            if (e == edge || !this.isMeta(group, e)) continue;
            return true;
        }
        return false;
    }
}

