/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.xgmml.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cytoscape.io.internal.read.xgmml.MetadataEntries;
import org.cytoscape.io.internal.read.xgmml.MetadataParser;
import org.cytoscape.io.internal.read.xgmml.ObjectTypeMap;
import org.cytoscape.io.internal.read.xgmml.ParseState;
import org.cytoscape.io.internal.read.xgmml.handler.ReadDataManager;
import org.cytoscape.io.internal.util.SUIDUpdater;
import org.cytoscape.io.internal.util.xgmml.ObjectType;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.VirtualColumnInfo;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class AttributeValueUtil {
    static final String ATTR_NAME = "name";
    static final String ATTR_LABEL = "label";
    static final String ATTR_VALUE = "value";
    static final String LOCKED_VISUAL_PROPS = "lockedVisualProperties";
    static final Pattern XLINK_PATTERN = Pattern.compile(".*#(-?\\d+)");
    private Locator locator;
    private final ReadDataManager manager;
    private final ObjectTypeMap typeMap;
    protected static final Logger logger = LoggerFactory.getLogger(AttributeValueUtil.class);

    public AttributeValueUtil(ReadDataManager manager) {
        this.manager = manager;
        this.typeMap = new ObjectTypeMap();
    }

    public void setLocator(Locator locator) {
        this.locator = locator;
    }

    public void setMetaData(CyNetwork network) {
        MetadataParser mdp = new MetadataParser(network);
        if (this.manager.RDFType != null) {
            mdp.setMetadata(MetadataEntries.TYPE, this.manager.RDFType);
        }
        if (this.manager.RDFDate != null) {
            mdp.setMetadata(MetadataEntries.DATE, this.manager.RDFDate);
        }
        if (this.manager.RDFTitle != null) {
            mdp.setMetadata(MetadataEntries.TITLE, this.manager.RDFTitle);
        }
        if (this.manager.RDFDescription != null) {
            mdp.setMetadata(MetadataEntries.DESCRIPTION, this.manager.RDFDescription);
        }
        if (this.manager.RDFSource != null) {
            mdp.setMetadata(MetadataEntries.SOURCE, this.manager.RDFSource);
        }
        if (this.manager.RDFFormat != null) {
            mdp.setMetadata(MetadataEntries.FORMAT, this.manager.RDFFormat);
        }
        if (this.manager.RDFIdentifier != null) {
            mdp.setMetadata(MetadataEntries.IDENTIFIER, this.manager.RDFIdentifier);
        }
    }

    protected String getAttributeValue(Attributes atts, String key) {
        String name = atts.getValue(ATTR_NAME);
        if (name == null) {
            name = atts.getValue(ATTR_LABEL);
        }
        if (name != null && name.equals(key)) {
            return atts.getValue(ATTR_VALUE);
        }
        return null;
    }

    protected Object getTypedAttributeValue(ObjectType type, Attributes atts, String name) throws SAXParseException {
        String value = atts.getValue(ATTR_VALUE);
        try {
            return this.typeMap.getTypedValue(type, value, name);
        }
        catch (Exception e) {
            throw new SAXParseException("Unable to convert '" + value + "' to type " + type.toString(), this.locator);
        }
    }

    protected String getAttribute(Attributes atts, String key) {
        return atts.getValue(key);
    }

    protected String getAttributeNS(Attributes atts, String key, String ns) {
        if (atts.getValue(ns, key) != null) {
            return atts.getValue(ns, key);
        }
        return atts.getValue(key);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected ParseState handleAttribute(Attributes atts) throws SAXParseException {
        ParseState parseState = ParseState.NONE;
        String name = atts.getValue(ATTR_NAME);
        String type = atts.getValue("type");
        String cyType = atts.getValue("cy:type");
        if ("has_nested_network".equals(name)) {
            type = ObjectType.BOOLEAN.getXgmmlValue();
        }
        boolean isEquation = ObjectTypeMap.fromXGMMLBoolean(atts.getValue("cy:equation"));
        boolean isHidden = ObjectTypeMap.fromXGMMLBoolean(atts.getValue("cy:hidden"));
        CyIdentifiable curElement = this.manager.getCurrentElement();
        CyNetwork curNet = this.manager.getCurrentNetwork();
        if (curElement instanceof CyNode || curElement instanceof CyEdge) {
            boolean containsElement = curElement instanceof CyNode && curNet.containsNode((CyNode)curElement);
            if (!(containsElement |= curElement instanceof CyEdge && curNet.containsEdge((CyEdge)curElement))) {
                curNet = this.manager.getRootNetwork();
            }
        }
        CyRow row = null;
        row = isHidden ? curNet.getRow(curElement, "HIDDEN") : ("selected".equals(name) || curElement instanceof CyNetwork ? curNet.getRow(curElement, "LOCAL_ATTRS") : curNet.getRow(curElement, "USER"));
        CyTable table = row.getTable();
        CyColumn column = table.getColumn(name);
        if (column != null) {
            VirtualColumnInfo info = column.getVirtualColumnInfo();
            if (info.isVirtual()) {
                CyRow srcRow;
                CyTable srcTable = info.getSourceTable();
                CyColumn srcColumn = srcTable.getColumn(info.getSourceColumn());
                Class jkColType = table.getColumn(info.getTargetJoinKey()).getType();
                Object jkValue = row.get(info.getTargetJoinKey(), jkColType);
                Collection srcRowList = srcTable.getMatchingRows(info.getSourceJoinKey(), jkValue);
                if (srcRowList == null || srcRowList.isEmpty()) {
                    if (!info.getTargetJoinKey().equals("SUID")) {
                        logger.error("Unable to import virtual column \"" + name + "\": The source table \"" + srcTable.getTitle() + "\" does not have any matching rows for join key \"" + info.getSourceJoinKey() + "=" + jkValue + "\".");
                        return parseState;
                    }
                    srcRow = srcTable.getRow(jkValue);
                } else {
                    srcRow = (CyRow)srcRowList.iterator().next();
                }
                table = srcTable;
                column = srcColumn;
                row = srcRow;
            }
        } else {
            Class tableType = curElement instanceof CyNode ? CyNode.class : (curElement instanceof CyEdge ? CyEdge.class : CyNetwork.class);
            if (AttributeValueUtil.existsInLocalTable(name, tableType, this.manager.getRootNetwork())) {
                row = curNet.getRow(curElement, "LOCAL_ATTRS");
            }
        }
        Object value = null;
        ObjectType objType = this.typeMap.fromXgmml(cyType, type);
        if (isEquation) {
            String formula = atts.getValue(ATTR_VALUE);
            if (name != null && formula != null) {
                this.manager.addEquationString(row, name, formula);
            }
        } else {
            value = this.getTypedAttributeValue(objType, atts, name);
        }
        switch (objType) {
            case BOOLEAN: {
                if (name == null) return parseState;
                this.setAttribute(row, name, Boolean.class, (Boolean)value);
                return parseState;
            }
            case REAL: {
                if (name == null) return parseState;
                if (SUIDUpdater.isUpdatable(name)) {
                    this.setAttribute(row, name, Long.class, (Long)value);
                    return parseState;
                }
                this.setAttribute(row, name, Double.class, (Double)value);
                return parseState;
            }
            case INTEGER: {
                if (name == null) return parseState;
                if (SUIDUpdater.isUpdatable(name)) {
                    this.setAttribute(row, name, Long.class, (Long)value);
                    return parseState;
                }
                this.setAttribute(row, name, Integer.class, (Integer)value);
                return parseState;
            }
            case LONG: {
                if (name == null) return parseState;
                this.setAttribute(row, name, Long.class, (Long)value);
                return parseState;
            }
            case STRING: {
                if (name == null) return parseState;
                this.setAttribute(row, name, String.class, (String)value);
                return parseState;
            }
            case LIST: {
                this.manager.currentAttributeID = name;
                this.manager.setCurrentRow(row);
                if (column != null && List.class.isAssignableFrom(column.getType())) {
                    row.set(name, null);
                }
                if (column != null) return ParseState.LIST_ATT;
                String elementType = atts.getValue("cy:elementType");
                if (elementType == null) return ParseState.LIST_ATT;
                ObjectType elementObjType = this.typeMap.fromXgmml(elementType, null);
                Class<?> clazz = this.typeMap.getClass(elementObjType, name);
                table.createListColumn(name, clazz, false, new ArrayList());
                column = row.getTable().getColumn(name);
                this.manager.listAttrHolder = new ArrayList<Object>();
                return ParseState.LIST_ATT;
            }
        }
        return parseState;
    }

    private <T> void setAttribute(CyRow row, String name, Class<T> type, T value) {
        if (name != null) {
            CyTable table = row.getTable();
            CyColumn column = table.getColumn(name);
            if (column == null) {
                table.createColumn(name, type, false);
                column = table.getColumn(name);
            } else if (column.getVirtualColumnInfo().isVirtual()) {
                logger.warn("Cannot set value to virtual column \"" + name + "\".");
                return;
            }
            if (value != null) {
                Class colType = column.getType();
                if (colType == Integer.class) {
                    row.set(name, (Object)((Number)value).intValue());
                } else if (colType == Long.class) {
                    row.set(name, (Object)((Number)value).longValue());
                } else if (colType == Double.class) {
                    row.set(name, (Object)((Number)value).doubleValue());
                } else {
                    row.set(name, value);
                }
            }
        }
    }

    private static boolean existsInLocalTable(String columnName, Class<? extends CyIdentifiable> tableType, CyRootNetwork rootNetwork) {
        List<CyTable> tables = AttributeValueUtil.getLocalTables(tableType, rootNetwork);
        for (CyTable table : tables) {
            CyColumn column = table.getColumn(columnName);
            if (column == null) continue;
            return true;
        }
        return false;
    }

    private static List<CyTable> getLocalTables(Class<? extends CyIdentifiable> tableType, CyRootNetwork rootNetwork) {
        ArrayList<CyTable> tables = new ArrayList<CyTable>();
        CyTable rootTbl = rootNetwork.getTable(tableType, "LOCAL_ATTRS");
        if (rootTbl != null) {
            tables.add(rootTbl);
        }
        for (CyNetwork sub : rootNetwork.getSubNetworkList()) {
            CyTable netTbl = sub.getTable(tableType, "LOCAL_ATTRS");
            if (netTbl == null) continue;
            tables.add(netTbl);
        }
        return tables;
    }

    public static Long getIdFromXLink(String href) {
        Matcher matcher = XLINK_PATTERN.matcher(href);
        return matcher.matches() ? Long.valueOf(matcher.group(1)) : null;
    }
}

