/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.xgmml;

import java.awt.List;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.cytoscape.io.internal.util.SUIDUpdater;
import org.cytoscape.io.internal.util.xgmml.ObjectType;

public class ObjectTypeMap {
    private static Pattern TRUE_PATTERN = Pattern.compile("(?i)1|true|yes");

    public ObjectType fromXgmml(String cyType, String xgmmlType) {
        ObjectType type = null;
        if (cyType != null && !cyType.isEmpty()) {
            type = ObjectType.fromCyValue(cyType);
        }
        if (type == null) {
            type = ObjectType.fromXgmmlValue(xgmmlType);
        }
        return type != null ? type : ObjectType.STRING;
    }

    public Class<?> getClass(ObjectType objType, String name) {
        switch (objType) {
            case LIST: {
                return List.class;
            }
            case BOOLEAN: {
                return Boolean.class;
            }
            case REAL: {
                return SUIDUpdater.isUpdatable(name) ? Long.class : Double.class;
            }
            case INTEGER: {
                return SUIDUpdater.isUpdatable(name) ? Long.class : Integer.class;
            }
            case LONG: {
                return Long.class;
            }
        }
        return String.class;
    }

    public Object getTypedValue(ObjectType type, String value, String name) {
        Object typedValue = null;
        switch (type) {
            case BOOLEAN: {
                if (value == null) break;
                typedValue = ObjectTypeMap.fromXGMMLBoolean(value);
                break;
            }
            case REAL: {
                if (value == null) break;
                if (SUIDUpdater.isUpdatable(name)) {
                    typedValue = Double.valueOf(value).longValue();
                    break;
                }
                typedValue = Double.valueOf(value);
                break;
            }
            case INTEGER: {
                if (value == null) break;
                if (SUIDUpdater.isUpdatable(name)) {
                    typedValue = Long.valueOf(value);
                    break;
                }
                typedValue = Integer.valueOf(value);
                break;
            }
            case LONG: {
                if (value == null) break;
                typedValue = Long.valueOf(value);
                break;
            }
            case STRING: {
                if (value == null) break;
                String sAttr = value.replace("\\t", "\t");
                typedValue = sAttr.replace("\\n", "\n");
                break;
            }
            case LIST: {
                typedValue = new ArrayList();
            }
        }
        return typedValue;
    }

    public static boolean fromXGMMLBoolean(String s) {
        return s != null && TRUE_PATTERN.matcher(s).matches();
    }

    public static String toXGMMLBoolean(Boolean value) {
        return value != null && value != false ? "1" : "0";
    }
}

