/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.nnf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.internal.read.nnf.NNFParser;
import org.cytoscape.io.read.AbstractCyNetworkReader;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NNFNetworkReader
extends AbstractCyNetworkReader {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final char COMMENT_CHAR = '#';
    private NNFParser parser;
    private TaskMonitor parentTaskMonitor;
    private final CyServiceRegistrar serviceRegistrar;

    public NNFNetworkReader(InputStream is, CyServiceRegistrar serviceRegistrar) {
        super(is, (CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class), (CyNetworkFactory)serviceRegistrar.getService(CyNetworkFactory.class), (CyNetworkManager)serviceRegistrar.getService(CyNetworkManager.class), (CyRootNetworkManager)serviceRegistrar.getService(CyRootNetworkManager.class));
        this.serviceRegistrar = serviceRegistrar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor tm) throws IOException {
        CyRootNetwork rootNetwork = this.getRootNetwork();
        Map nMap = this.getNodeMap();
        this.parser = new NNFParser(rootNetwork, this.cyNetworkFactory, nMap, this.serviceRegistrar);
        try {
            this.readInput(tm);
        }
        finally {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (Exception e) {
                    logger.warn("Cannot close NNF input stream", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readInput(TaskMonitor tm) throws IOException {
        this.parentTaskMonitor = tm;
        tm.setProgress(0.0);
        BufferedReader in = new BufferedReader(new InputStreamReader(this.inputStream, Charset.forName("UTF-8").newDecoder()));
        in.mark(9999999);
        String overviewNetworkName = this.retriveOverviewNetworkName(in);
        if (overviewNetworkName == null) {
            throw new IOException("Can not find overview netwrok!");
        }
        in.reset();
        this.parser.setOverViewnetworkName(overviewNetworkName);
        try {
            String line;
            int lineNumber = 1;
            while ((line = in.readLine()) != null) {
                if ((line = this.processComment(line)).length() != 0 && !this.parser.parse(line)) {
                    throw new IOException("Malformed line in NNF file: " + lineNumber + " \"" + line + "\"");
                }
                ++lineNumber;
            }
        }
        finally {
            in.close();
        }
        if (this.parser.getNetworks().size() == 0) {
            throw new IOException("Input NNF file is empty!");
        }
        this.networks = new CyNetwork[this.parser.getNetworks().size()];
        Iterator<CyNetwork> it = this.parser.getNetworks().iterator();
        int i = 0;
        while (it.hasNext()) {
            this.networks[i++] = it.next();
        }
        tm.setProgress(1.0);
    }

    private String retriveOverviewNetworkName(BufferedReader in) throws IOException {
        String line;
        HashSet<String> networkSet = new HashSet<String>();
        HashSet<String> nodeSet = new HashSet<String>();
        int lineNumber = 1;
        while ((line = in.readLine()) != null) {
            if ((line = this.processComment(line)).length() != 0) {
                String[] parts = NNFParser.splitLine(line);
                int length = parts.length;
                if (length == 2) {
                    networkSet.add(parts[0]);
                    nodeSet.add(parts[1]);
                } else if (length == 4) {
                    networkSet.add(parts[0]);
                    nodeSet.add(parts[1]);
                    nodeSet.add(parts[3]);
                }
            }
            ++lineNumber;
        }
        String overviewName = null;
        int overviewNameCount = 0;
        for (String tmp : networkSet) {
            if (nodeSet.contains(tmp)) continue;
            overviewName = tmp;
            ++overviewNameCount;
        }
        if (overviewNameCount != 1) {
            overviewName = null;
        }
        return overviewName;
    }

    private String processComment(String line) {
        int hashPos = line.indexOf(35);
        if (hashPos != -1) {
            line = line.substring(0, hashPos);
        }
        return line.trim();
    }

    public CyNetworkView buildCyNetworkView(CyNetwork network) {
        CyNetworkView view = this.getNetworkViewFactory().createNetworkView(network);
        CyLayoutAlgorithmManager layoutMgr = (CyLayoutAlgorithmManager)this.serviceRegistrar.getService(CyLayoutAlgorithmManager.class);
        CyLayoutAlgorithm layout = layoutMgr.getDefaultLayout();
        String attribute = layoutMgr.getLayoutAttribute(layout, view);
        TaskIterator itr = layout.createTaskIterator(view, layout.getDefaultLayoutContext(), CyLayoutAlgorithm.ALL_NODE_VIEWS, attribute);
        Task nextTask = itr.next();
        try {
            nextTask.run(this.parentTaskMonitor);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not finish layout", e);
        }
        return view;
    }
}

