/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.webservice.psicquic.task;

import java.util.HashMap;
import java.util.Map;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.webservice.psicquic.PSICQUICRestClient;
import org.cytoscape.webservice.psicquic.RegistryManager;
import org.cytoscape.webservice.psicquic.mapper.CyNetworkBuilder;
import org.cytoscape.webservice.psicquic.task.ExpandFromSelectedSourcesTask;
import org.cytoscape.webservice.psicquic.task.SearchRecordsTask;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;

public class ProcessSearchResultTask
extends AbstractTask {
    private final PSICQUICRestClient client;
    private final String query;
    private final SearchRecordsTask searchTask;
    private final CyNetworkView netView;
    private final View<CyNode> nodeView;
    private volatile boolean canceled = false;
    private final RegistryManager registryManager;
    private final CyNetworkBuilder builder;
    private final CyServiceRegistrar serviceRegistrar;

    public ProcessSearchResultTask(String query, PSICQUICRestClient client, SearchRecordsTask searchTask, CyNetworkView parentNetworkView, View<CyNode> nodeView, RegistryManager registryManager, CyNetworkBuilder builder, CyServiceRegistrar serviceRegistrar) {
        this.client = client;
        this.query = query;
        this.netView = parentNetworkView;
        this.nodeView = nodeView;
        this.searchTask = searchTask;
        this.registryManager = registryManager;
        this.builder = builder;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setTitle("Expanding by PSICQUIC Services");
        taskMonitor.setStatusMessage("Loading interaction from remote service...");
        taskMonitor.setProgress(0.01);
        if (this.canceled) {
            return;
        }
        Map<String, String> result = this.processSearchResult();
        this.insertTasksAfterCurrentTask(new Task[]{new ExpandFromSelectedSourcesTask(this.query, this.client, result, this.netView, this.nodeView, this.builder, this.serviceRegistrar)});
        taskMonitor.setProgress(1.0);
    }

    public void cancel() {
        this.canceled = true;
        this.client.cancel();
    }

    private final Map<String, String> processSearchResult() {
        HashMap<String, String> sourceMap = new HashMap<String, String>();
        Map<String, Long> rs = this.searchTask.getResult();
        for (String sourceURL : rs.keySet()) {
            Long interactionCount = rs.get(sourceURL);
            if (interactionCount <= 0L) continue;
            sourceMap.put(this.registryManager.getSource2NameMap().get(sourceURL) + ": " + interactionCount, sourceURL);
        }
        return sourceMap;
    }
}

