/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.webservice.psicquic.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.webservice.psicquic.PSICQUICRestClient;
import org.cytoscape.webservice.psicquic.RegistryManager;
import org.cytoscape.webservice.psicquic.mapper.CyNetworkBuilder;
import org.cytoscape.webservice.psicquic.task.ProcessSearchResultTask;
import org.cytoscape.webservice.psicquic.task.SearchRecordsTask;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListSingleSelection;

public class BuildQueryTask
extends AbstractTask {
    @Tunable(description="Select Query Column:")
    public ListSingleSelection<String> columnList;
    private PSICQUICRestClient client;
    private final RegistryManager manager;
    private final CyTable table;
    private final View<CyNode> nodeView;
    private final CyNetworkBuilder builder;
    private final CyNetworkView netView;
    private final Map<String, CyColumn> colName2column;
    private final CyServiceRegistrar serviceRegistrar;

    @ProvidesTitle
    public String getTitle() {
        return "Extend Network by PSICQUIC Web Services";
    }

    BuildQueryTask(CyNetworkView netView, View<CyNode> nodeView, PSICQUICRestClient client, RegistryManager manager, CyNetworkBuilder builder, CyServiceRegistrar serviceRegistrar) {
        this.table = ((CyNetwork)netView.getModel()).getDefaultNodeTable();
        this.nodeView = nodeView;
        this.manager = manager;
        this.client = client;
        this.builder = builder;
        this.netView = netView;
        this.serviceRegistrar = serviceRegistrar;
        this.colName2column = new HashMap<String, CyColumn>();
        Collection columns = this.table.getColumns();
        CyRow row = this.table.getRow((Object)((CyNode)nodeView.getModel()).getSUID());
        String defaultSelection = null;
        boolean alreadySet = false;
        for (CyColumn col : columns) {
            Object val = row.get(col.getName(), col.getType());
            if (val == null || col.getType() != String.class) continue;
            String labelString = col.getName() + " (" + val.toString() + ")";
            this.colName2column.put(labelString, col);
            if (col.getName().equals("name") && !alreadySet) {
                defaultSelection = labelString;
                continue;
            }
            if (!col.getName().equals("identifier")) continue;
            defaultSelection = labelString;
        }
        this.columnList = new ListSingleSelection(new ArrayList<String>(this.colName2column.keySet()));
        if (defaultSelection != null) {
            this.columnList.setSelectedValue(defaultSelection);
        }
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        String selectedStr = (String)this.columnList.getSelectedValue();
        CyColumn selected = this.colName2column.get(selectedStr);
        Object value = this.table.getRow((Object)((CyNode)this.nodeView.getModel()).getSUID()).get(selected.getName(), selected.getType());
        if (value == null) {
            throw new NullPointerException("Selected column value is null: " + selected.getName());
        }
        String query = value.toString();
        SearchRecordsTask searchTask = new SearchRecordsTask(this.client, PSICQUICRestClient.SearchMode.INTERACTOR);
        Map<String, String> activeSource = this.manager.getActiveServices();
        searchTask.setQuery(query);
        searchTask.setTargets(activeSource.values());
        ProcessSearchResultTask expandTask = new ProcessSearchResultTask(query, this.client, searchTask, this.netView, this.nodeView, this.manager, this.builder, this.serviceRegistrar);
        this.insertTasksAfterCurrentTask(new Task[]{searchTask, expandTask});
    }
}

