/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.webservice.psicquic;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.cytoscape.webservice.psicquic.RegistryManager;

public class ServiceState {
    private final RegistryManager registryManager;
    private final SortedSet<String> services;
    private final Map<String, Integer> lastCounts;
    private final Map<String, String> uri2name;

    public ServiceState(RegistryManager registryManager) {
        this.registryManager = registryManager;
        this.services = new TreeSet<String>(registryManager.getActiveServices().keySet());
        this.services.addAll(registryManager.getInactiveServices().keySet());
        this.uri2name = new HashMap<String, String>();
        Set<String> active = registryManager.getActiveServices().keySet();
        for (String serviceName : active) {
            this.uri2name.put(registryManager.getActiveServices().get(serviceName), serviceName);
        }
        this.lastCounts = new HashMap<String, Integer>();
    }

    public Collection<String> getServiceNames() {
        return this.services;
    }

    public int getRecentResultCount(String serviceName) {
        Integer count = this.lastCounts.get(serviceName);
        if (count != null) {
            return count;
        }
        return 0;
    }

    public void setRecentResultCount(String serviceName, Integer count) {
        this.lastCounts.put(serviceName, count);
    }

    public String getName(String uriString) {
        return this.uri2name.get(uriString);
    }
}

