/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.webservice.psicquic;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RegistryManager {
    private static final Logger logger = LoggerFactory.getLogger(RegistryManager.class);
    private static final String REST_URL = "restUrl";
    private static final String TAG = "tag";
    private static final String COUNT = "count";
    private static final String IS_ACTIVE = "active";
    private static final String DEF_SERVICE_URL = "http://www.ebi.ac.uk/Tools/webservices/psicquic/registry/registry";
    private final String serviceURLString;
    private final Map<String, String> activeServiceMap;
    private final Map<String, String> inactiveServiceMap;
    private final Map<String, String> source2NameMap;
    private final SortedSet<String> allServiceNames;
    private final Map<String, Boolean> statusMap;
    private final Map<String, String> urlMap;
    private final Map<String, List<String>> tagMap;
    private final Map<String, Long> countMap;
    private boolean isInitialized;

    public RegistryManager() {
        this(DEF_SERVICE_URL);
    }

    public RegistryManager(String regLocaiton) {
        this.serviceURLString = regLocaiton == null || regLocaiton.trim().length() == 0 ? DEF_SERVICE_URL : regLocaiton;
        this.activeServiceMap = new HashMap<String, String>();
        this.inactiveServiceMap = new HashMap<String, String>();
        this.source2NameMap = new HashMap<String, String>();
        this.statusMap = new HashMap<String, Boolean>();
        this.urlMap = new HashMap<String, String>();
        this.tagMap = new HashMap<String, List<String>>();
        this.countMap = new HashMap<String, Long>();
        this.allServiceNames = new TreeSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized() {
        RegistryManager registryManager = this;
        synchronized (registryManager) {
            if (this.isInitialized) {
                return;
            }
            ExecutorService executor = Executors.newCachedThreadPool();
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    RegistryManager.this.invoke();
                    RegistryManager.this.allServiceNames.addAll(RegistryManager.this.activeServiceMap.keySet());
                    RegistryManager.this.allServiceNames.addAll(RegistryManager.this.inactiveServiceMap.keySet());
                }
            });
            try {
                executor.shutdown();
                executor.awaitTermination(60L, TimeUnit.SECONDS);
                this.isInitialized = true;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void refresh() {
        this.activeServiceMap.clear();
        this.inactiveServiceMap.clear();
        this.source2NameMap.clear();
        this.statusMap.clear();
        this.urlMap.clear();
        this.tagMap.clear();
        this.countMap.clear();
        this.invoke();
        this.allServiceNames.clear();
        this.allServiceNames.addAll(this.activeServiceMap.keySet());
        this.allServiceNames.addAll(this.inactiveServiceMap.keySet());
    }

    public Map<String, String> getActiveServices() {
        this.ensureInitialized();
        return this.activeServiceMap;
    }

    public Map<String, String> getInactiveServices() {
        this.ensureInitialized();
        return this.inactiveServiceMap;
    }

    public Map<String, List<String>> getTagMap() {
        this.ensureInitialized();
        return this.tagMap;
    }

    public Map<String, Long> getCountMap() {
        this.ensureInitialized();
        return this.countMap;
    }

    public SortedSet<String> getAllServiceNames() {
        this.ensureInitialized();
        return this.allServiceNames;
    }

    public Map<String, String> getSource2NameMap() {
        this.ensureInitialized();
        if (this.source2NameMap.size() == 0) {
            for (String name : this.activeServiceMap.keySet()) {
                this.source2NameMap.put(this.activeServiceMap.get(name), name);
            }
            for (String name : this.inactiveServiceMap.keySet()) {
                this.source2NameMap.put(this.inactiveServiceMap.get(name), name);
            }
        }
        return this.source2NameMap;
    }

    private void invoke() {
        String command = "?action=" + STATE.STATUS.name() + "&format=xml";
        try {
            this.callRegistry(command);
        }
        catch (IOException e) {
            logger.error("Could not initialize PSICQUIC registory manager.");
        }
        this.setMap();
        logger.info("Found " + this.activeServiceMap.size() + " active PSICQUIC services.");
    }

    private void callRegistry(String command) throws IOException {
        String next;
        URL url = new URL(this.serviceURLString + command);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestProperty("accept", "text/xml");
        connection.connect();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), Charset.forName("UTF-8").newDecoder()));
        StringBuilder builder = new StringBuilder();
        while ((next = reader.readLine()) != null) {
            builder.append(next);
        }
        reader.close();
        reader = null;
        try {
            this.parse(builder.toString());
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Could not parse result from registry.");
        }
        catch (XPathException e) {
            throw new IOException("Could not parse result from registry.");
        }
        catch (SAXException e) {
            throw new IOException("Could not parse result from registry.");
        }
    }

    private void parse(String result) throws ParserConfigurationException, IOException, XPathException, SAXException {
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docbuilder = dbfactory.newDocumentBuilder();
        Document doc = docbuilder.parse(new ByteArrayInputStream(result.getBytes("UTF-8")));
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xp = xpf.newXPath();
        NodeList list = (NodeList)xp.evaluate("//service", doc, XPathConstants.NODESET);
        String regName = null;
        for (int i = 0; i < list.getLength(); ++i) {
            regName = list.item(i).getFirstChild().getFirstChild().getNodeValue();
            logger.debug("Service Provider " + i + ": " + regName);
            this.walk(list.item(i), regName);
        }
    }

    private void walk(Node item, String serviceName) {
        String tag = null;
        for (Node n = item.getFirstChild(); n != null; n = n.getNextSibling()) {
            tag = item.getNodeName();
            if (tag.equals(REST_URL)) {
                this.urlMap.put(serviceName, item.getFirstChild().getNodeValue());
            } else if (tag.equals(IS_ACTIVE)) {
                this.statusMap.put(serviceName, Boolean.parseBoolean(item.getFirstChild().getNodeValue()));
            } else if (tag.equals(TAG)) {
                List<String> tagList = this.tagMap.get(serviceName);
                if (tagList == null) {
                    tagList = new ArrayList<String>();
                }
                tagList.add(item.getFirstChild().getNodeValue());
                this.tagMap.put(serviceName, tagList);
            } else if (tag.equals(COUNT)) {
                String entry = item.getFirstChild().getNodeValue();
                Long numberOfRecoreds = 0L;
                try {
                    numberOfRecoreds = Long.parseLong(entry);
                }
                catch (Exception ex) {
                    logger.warn("Could not get count", (Throwable)ex);
                }
                this.countMap.put(serviceName, numberOfRecoreds);
            }
            this.walk(n, serviceName);
        }
    }

    private void setMap() {
        for (String serviceName : this.statusMap.keySet()) {
            if (this.statusMap.get(serviceName).booleanValue()) {
                this.activeServiceMap.put(serviceName, this.urlMap.get(serviceName));
                continue;
            }
            this.inactiveServiceMap.put(serviceName, this.urlMap.get(serviceName));
        }
    }

    public boolean isActive(String serviceName) {
        this.ensureInitialized();
        if (serviceName == null) {
            throw new NullPointerException("Service Name is null.");
        }
        return !this.inactiveServiceMap.keySet().contains(serviceName);
    }

    public String getRestURL(String serviceName) {
        this.ensureInitialized();
        if (serviceName == null) {
            throw new NullPointerException("Service Name is null.");
        }
        if (!this.allServiceNames.contains(serviceName)) {
            throw new IllegalArgumentException("Could not find the service in the registry: " + serviceName);
        }
        String serviceURLString = this.activeServiceMap.get(serviceName);
        if (serviceURLString == null) {
            serviceURLString = this.inactiveServiceMap.get(serviceName);
        }
        if (serviceURLString == null) {
            throw new IllegalStateException("Could not find REST service URL for " + serviceName);
        }
        return serviceURLString;
    }

    public static enum STATE {
        ACTIVE,
        INACTIVE,
        STATUS;

    }
}

