/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.webservice.psicquic;

import java.util.Map;
import org.cytoscape.io.webservice.NetworkImportWebServiceClient;
import org.cytoscape.io.webservice.SearchWebServiceClient;
import org.cytoscape.io.webservice.swing.AbstractWebServiceGUIClient;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.webservice.psicquic.PSICQUICRestClient;
import org.cytoscape.webservice.psicquic.PSIMI25VisualStyleBuilder;
import org.cytoscape.webservice.psicquic.RegistryManager;
import org.cytoscape.webservice.psicquic.mapper.CyNetworkBuilder;
import org.cytoscape.webservice.psicquic.task.ImportNetworkFromPSICQUICTask;
import org.cytoscape.webservice.psicquic.task.SearchRecordsTask;
import org.cytoscape.webservice.psicquic.ui.PSICQUICSearchUI;
import org.cytoscape.webservice.psicquic.ui.PSIMITagManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PSICQUICWebServiceClient
extends AbstractWebServiceGUIClient
implements NetworkImportWebServiceClient,
SearchWebServiceClient {
    private static final Logger logger = LoggerFactory.getLogger(PSICQUICWebServiceClient.class);
    private PSICQUICRestClient client;
    private RegistryManager regManager;
    private ImportNetworkFromPSICQUICTask networkTask;
    private SearchRecordsTask searchTask;
    private final PSIMI25VisualStyleBuilder vsBuilder;
    private final PSIMITagManager tagManager;
    private final CyServiceRegistrar serviceRegistrar;

    public PSICQUICWebServiceClient(String uri, String displayName, String description, CyNetworkBuilder builder, PSIMI25VisualStyleBuilder vsBuilder, PSIMITagManager tagManager, CyServiceRegistrar serviceRegistrar) {
        super(uri, displayName, description);
        this.vsBuilder = vsBuilder;
        this.tagManager = tagManager;
        this.serviceRegistrar = serviceRegistrar;
        this.regManager = new RegistryManager();
        this.client = new PSICQUICRestClient(this.regManager, builder, serviceRegistrar);
    }

    public RegistryManager getRegManager() {
        return this.regManager;
    }

    public TaskIterator createTaskIterator(Object query) {
        if (this.regManager == null) {
            throw new NullPointerException("RegistryManager is null");
        }
        if (query == null) {
            throw new NullPointerException("Query object is null.");
        }
        this.searchTask = new SearchRecordsTask(this.client, PSICQUICRestClient.SearchMode.MIQL);
        Map<String, String> activeSource = this.regManager.getActiveServices();
        String query2 = query.toString();
        this.searchTask.setQuery(query2);
        this.searchTask.setTargets(activeSource.values());
        this.networkTask = new ImportNetworkFromPSICQUICTask(query2, this.client, this.searchTask, PSICQUICRestClient.SearchMode.MIQL, this.vsBuilder, this.serviceRegistrar);
        return new TaskIterator(new Task[]{this.searchTask, this.networkTask});
    }

    public PSICQUICSearchUI getQueryBuilderGUI() {
        return new PSICQUICSearchUI(this.regManager, this.client, this.vsBuilder, this.tagManager, this.serviceRegistrar);
    }

    public PSICQUICRestClient getRestClient() {
        return this.client;
    }

    public RegistryManager getRegistryManager() {
        return this.regManager;
    }
}

