/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.ui.downloadsites;

import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.cytoscape.app.internal.net.WebQuerier;
import org.cytoscape.app.internal.ui.downloadsites.DownloadSite;
import org.cytoscape.app.internal.ui.downloadsites.DownloadSitesManager;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class ManageDownloadSitesDialog
extends JDialog {
    private static final long serialVersionUID = -5333266960245441850L;
    private JButton newButton;
    private JButton closeButton;
    private JButton saveButton;
    private JButton removeButton;
    private JLabel siteNameLabel;
    private JTextField siteNameTextField;
    private JLabel siteUrlLabel;
    private JTextField siteUrlTextField;
    private JScrollPane sitesScrollPane;
    private JTable sitesTable;
    private DownloadSitesManager downloadSitesManager;
    private DownloadSitesManager.DownloadSitesChangedListener downloadSitesChangedListener;

    public ManageDownloadSitesDialog(Window parent, DownloadSitesManager downloadSitesManager) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.downloadSitesManager = downloadSitesManager;
        this.initComponents();
        this.downloadSitesChangedListener = new DownloadSitesManager.DownloadSitesChangedListener(){

            @Override
            public void downloadSitesChanged(DownloadSitesManager.DownloadSitesChangedEvent downloadSitesChangedEvent) {
                ManageDownloadSitesDialog.this.repopulateTable();
            }
        };
        if (downloadSitesManager.getDownloadSites().size() == 0) {
            for (DownloadSite downloadSite : WebQuerier.DEFAULT_DOWNLOAD_SITES) {
                downloadSitesManager.addDownloadSite(downloadSite);
            }
            downloadSitesManager.saveDownloadSites();
        }
        downloadSitesManager.addDownloadSitesChangedListener(this.downloadSitesChangedListener);
        this.repopulateTable();
        this.setupDescriptionListener();
        this.update();
        this.updateSaveButton();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setTitle("Manage Download Sites");
        this.sitesTable = new JTable();
        this.sitesScrollPane = new JScrollPane(this.sitesTable);
        this.newButton = new JButton("New");
        this.saveButton = new JButton("Save");
        this.removeButton = new JButton("Remove");
        this.siteNameLabel = new JLabel("Site Name:");
        this.siteNameTextField = new JTextField();
        this.siteUrlLabel = new JLabel("URL:");
        this.siteUrlTextField = new JTextField();
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ManageDownloadSitesDialog.this.updateSaveButton();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ManageDownloadSitesDialog.this.updateSaveButton();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ManageDownloadSitesDialog.this.updateSaveButton();
            }
        };
        this.siteNameTextField.getDocument().addDocumentListener(docListener);
        this.siteUrlTextField.getDocument().addDocumentListener(docListener);
        this.sitesTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "URL"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        });
        this.sitesTable.setSelectionMode(0);
        this.sitesTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.sitesTable.getColumnModel().getColumn(1).setPreferredWidth(285);
        this.newButton.addActionListener(this::newButtonActionPerformed);
        this.saveButton.addActionListener(this::saveButtonActionPerformed);
        this.removeButton.addActionListener(this::removeButtonActionPerformed);
        LookAndFeelUtil.equalizeSize((JComponent[])new JComponent[]{this.newButton, this.removeButton, this.saveButton});
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(e -> this.dispose());
        JPanel detailPanel = new JPanel();
        detailPanel.setBorder(LookAndFeelUtil.createPanelBorder());
        GroupLayout layout = new GroupLayout(detailPanel);
        detailPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.siteNameLabel).addComponent(this.siteUrlLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.siteNameTextField).addComponent(this.siteUrlTextField))).addGroup(layout.createSequentialGroup().addComponent(this.newButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(this.removeButton, -2, -1, -2).addComponent(this.saveButton, -2, -1, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.siteNameLabel).addComponent(this.siteNameTextField, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.siteUrlLabel).addComponent(this.siteUrlTextField, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.newButton, -2, -1, -2).addComponent(this.removeButton, -2, -1, -2).addComponent(this.saveButton, -2, -1, -2)));
        JPanel buttonPanel = LookAndFeelUtil.createOkCancelPanel(null, (JButton)this.closeButton);
        JPanel contents = new JPanel();
        GroupLayout layout2 = new GroupLayout(contents);
        contents.setLayout(layout2);
        layout2.setAutoCreateContainerGaps(true);
        layout2.setAutoCreateGaps(true);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sitesScrollPane).addComponent(detailPanel, -1, -1, Short.MAX_VALUE).addComponent(buttonPanel, -1, -1, Short.MAX_VALUE));
        layout2.setVerticalGroup(layout2.createSequentialGroup().addComponent(this.sitesScrollPane, -1, 120, Short.MAX_VALUE).addComponent(detailPanel, -2, -1, -2).addComponent(buttonPanel, -2, -1, -2));
        this.getContentPane().add(contents);
        this.pack();
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), null, (Action)this.closeButton.getAction());
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        this.sitesTable.getSelectionModel().clearSelection();
        this.siteNameTextField.requestFocusInWindow();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        DownloadSite downloadSite = this.getSelectedSite();
        if (downloadSite == null) {
            String enteredSiteName = this.getEnteredSiteName();
            String enteredSiteUrl = this.getEnteredUrl();
            if (enteredSiteName.trim().isEmpty() || enteredSiteUrl.trim().isEmpty()) {
                return;
            }
            downloadSite = new DownloadSite(enteredSiteName, enteredSiteUrl);
            this.downloadSitesManager.addDownloadSite(downloadSite);
            this.downloadSitesManager.saveDownloadSites();
            this.update();
        } else if (this.isLastCopyOfDefaultSite(downloadSite)) {
            JOptionPane.showMessageDialog(this, "That is a default site, cannot edit");
        } else {
            downloadSite.setSiteName(this.getEnteredSiteName());
            downloadSite.setSiteUrl(this.getEnteredUrl());
            this.downloadSitesManager.notifyDownloadSitesChanged();
            this.downloadSitesManager.saveDownloadSites();
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        DownloadSite downloadSite = this.getSelectedSite();
        if (downloadSite == null) {
            JOptionPane.showMessageDialog(this, "Select a site to remove it");
        } else if (this.isLastCopyOfDefaultSite(downloadSite)) {
            JOptionPane.showMessageDialog(this, "That is a default site, cannot remove");
        } else {
            final int selectionIndex = this.sitesTable.getSelectedRow();
            DownloadSite siteToRemove = null;
            for (DownloadSite availableSite : this.downloadSitesManager.getDownloadSites()) {
                if (!availableSite.getSiteName().equals(downloadSite.getSiteName()) || !availableSite.getSiteUrl().equals(downloadSite.getSiteUrl())) continue;
                siteToRemove = availableSite;
            }
            if (siteToRemove != null) {
                this.downloadSitesManager.removeDownloadSite(siteToRemove);
                this.downloadSitesManager.saveDownloadSites();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int rowCount = ManageDownloadSitesDialog.this.sitesTable.getRowCount();
                        if (rowCount == 0) {
                            return;
                        }
                        if (selectionIndex > 0) {
                            ManageDownloadSitesDialog.this.sitesTable.getSelectionModel().setSelectionInterval(selectionIndex - 1, selectionIndex - 1);
                        } else if (selectionIndex == 0) {
                            ManageDownloadSitesDialog.this.sitesTable.getSelectionModel().setSelectionInterval(0, 0);
                        }
                    }
                });
            }
        }
    }

    private boolean isLastCopyOfDefaultSite(DownloadSite downloadSite) {
        boolean isDefaultSite = false;
        int copiesOfSite = 0;
        for (DownloadSite defaultSite : WebQuerier.DEFAULT_DOWNLOAD_SITES) {
            if (!downloadSite.equals(defaultSite)) continue;
            isDefaultSite = true;
        }
        if (isDefaultSite) {
            for (DownloadSite registeredSite : this.downloadSitesManager.getDownloadSites()) {
                if (!registeredSite.equals(downloadSite)) continue;
                ++copiesOfSite;
            }
        }
        return isDefaultSite && copiesOfSite <= 1;
    }

    private void repopulateTable() {
        final DefaultTableModel tableModel = new DefaultTableModel(new Object[0][], new String[]{"Name", "URL"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        LinkedList<DownloadSite> downloadSites = new LinkedList<DownloadSite>(this.downloadSitesManager.getDownloadSites());
        Collections.sort(downloadSites, (o1, o2) -> o1.getSiteName().compareTo(o2.getSiteName()));
        for (DownloadSite downloadSite : downloadSites) {
            tableModel.addRow(new Object[]{downloadSite, downloadSite.getSiteUrl()});
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ManageDownloadSitesDialog.this.sitesTable.setModel(tableModel);
                ManageDownloadSitesDialog.this.sitesTable.getColumnModel().getColumn(0).setPreferredWidth(140);
                ManageDownloadSitesDialog.this.sitesTable.getColumnModel().getColumn(1).setPreferredWidth(285);
            }
        });
    }

    private void setupDescriptionListener() {
        this.sitesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ManageDownloadSitesDialog.this.update();
                }
            }
        });
    }

    private void update() {
        boolean isDefault;
        DownloadSite selectedSite = this.getSelectedSite();
        boolean isNew = selectedSite == null;
        boolean bl = isDefault = selectedSite != null && this.isLastCopyOfDefaultSite(selectedSite);
        if (selectedSite != null) {
            this.siteNameTextField.setText(selectedSite.getSiteName());
            this.siteUrlTextField.setText(selectedSite.getSiteUrl());
            this.saveButton.setText("Save");
        } else {
            this.siteNameTextField.setText("");
            this.siteUrlTextField.setText("");
            this.saveButton.setText("Add");
        }
        this.siteNameTextField.setEnabled(!isDefault);
        this.siteUrlTextField.setEnabled(!isDefault);
        this.newButton.setEnabled(!isNew);
        this.removeButton.setEnabled(!isNew && !isDefault);
        this.saveButton.setEnabled(false);
    }

    private void updateSaveButton() {
        boolean isDefault;
        DownloadSite selectedSite = this.getSelectedSite();
        boolean bl = isDefault = selectedSite != null && this.isLastCopyOfDefaultSite(selectedSite);
        if (isDefault) {
            this.saveButton.setEnabled(false);
        } else {
            this.saveButton.setEnabled(!this.getEnteredSiteName().trim().isEmpty() && !this.getEnteredUrl().trim().isEmpty());
        }
    }

    private String getEnteredUrl() {
        return this.siteUrlTextField.getText();
    }

    private String getEnteredSiteName() {
        return this.siteNameTextField.getText();
    }

    private DownloadSite getSelectedSite() {
        HashSet<DownloadSite> selectedSites = new HashSet<DownloadSite>();
        int[] selectedRows = this.sitesTable.getSelectedRows();
        for (int index = 0; index < selectedRows.length; ++index) {
            DownloadSite downloadSite = (DownloadSite)this.sitesTable.getModel().getValueAt(this.sitesTable.convertRowIndexToModel(selectedRows[index]), 0);
            selectedSites.add(downloadSite);
        }
        if (selectedSites.size() > 0) {
            return (DownloadSite)selectedSites.iterator().next();
        }
        return null;
    }
}

