/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.ui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class NetworkErrorPanel
extends JPanel {
    private final IconManager iconManager;
    private List<String> warningMessages = new ArrayList<String>();

    public NetworkErrorPanel(IconManager iconManager) {
        this.iconManager = iconManager;
        this.initComponents();
    }

    private void initComponents() {
        this.removeAll();
        JLabel warnIcon = new JLabel("\uf071");
        warnIcon.setFont(this.iconManager.getIconFont(14.0f));
        warnIcon.setForeground(LookAndFeelUtil.getWarnColor());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        GroupLayout.SequentialGroup verticalLabelGroup = layout.createSequentialGroup();
        GroupLayout.ParallelGroup horizonalLabelGroup = layout.createParallelGroup();
        for (String message : this.warningMessages) {
            JLabel label = new JLabel(message);
            verticalLabelGroup.addComponent(label);
            horizonalLabelGroup.addComponent(label);
        }
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(warnIcon).addGroup(horizonalLabelGroup));
        layout.setVerticalGroup(layout.createParallelGroup().addComponent(warnIcon).addGroup(verticalLabelGroup));
    }

    public void addMessage(String message) {
        this.warningMessages.add(message);
        this.initComponents();
    }

    public void clearMessages() {
        this.warningMessages.clear();
        this.initComponents();
    }
}

