/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.cytoscape.app.internal.event.AppsChangedEvent;
import org.cytoscape.app.internal.event.AppsChangedListener;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.net.ResultsFilterer;
import org.cytoscape.app.internal.net.WebApp;
import org.cytoscape.app.internal.net.WebQuerier;
import org.cytoscape.app.internal.task.InstallAppsFromFileTask;
import org.cytoscape.app.internal.task.InstallAppsFromWebAppTask;
import org.cytoscape.app.internal.task.ShowInstalledAppsTask;
import org.cytoscape.app.internal.ui.AppManagerDialog;
import org.cytoscape.app.internal.ui.downloadsites.DownloadSite;
import org.cytoscape.app.internal.ui.downloadsites.DownloadSitesManager;
import org.cytoscape.util.swing.FileChooserFilter;
import org.cytoscape.util.swing.FileUtil;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskManager;
import org.cytoscape.work.TaskMonitor;

public class InstallAppsPanel
extends JPanel {
    private JPanel descriptionPanel;
    private JScrollPane descriptionScrollPane;
    private JSplitPane descriptionSplitPane;
    private JTextPane descriptionTextPane;
    private JComboBox<DownloadSite> downloadSiteComboBox;
    private JButton refreshButton;
    private JLabel downloadSiteLabel;
    private JTextField filterTextField;
    private JButton installButton;
    private JButton installFromFileButton;
    private JButton manageSitesButton;
    private JScrollPane resultsScrollPane;
    private JTree resultsTree;
    private JLabel searchAppsLabel;
    private JScrollPane tagsScrollPane;
    private JSplitPane tagsSplitPane;
    private JTree tagsTree;
    private JButton viewOnAppStoreButton;
    private JFileChooser fileChooser;
    private AppManager appManager;
    private DownloadSitesManager downloadSitesManager;
    private FileUtil fileUtil;
    private TaskManager taskManager;
    private IconManager iconManager;
    private Container parent;
    private WebApp selectedApp;
    private WebQuerier.AppTag currentSelectedAppTag;
    private Set<WebApp> resultsTreeApps;

    public InstallAppsPanel(AppManager appManager, DownloadSitesManager downloadSitesManager, FileUtil fileUtil, IconManager iconManager, TaskManager taskManager, Container parent) {
        this.appManager = appManager;
        this.downloadSitesManager = downloadSitesManager;
        this.fileUtil = fileUtil;
        this.iconManager = iconManager;
        this.taskManager = taskManager;
        this.parent = parent;
        this.initComponents();
        this.tagsTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                InstallAppsPanel.this.updateResultsTree();
                InstallAppsPanel.this.updateDescriptionBox();
            }
        });
        this.resultsTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                InstallAppsPanel.this.updateDescriptionBox();
            }
        });
        this.setupTextFieldListener();
        this.setupDownloadSitesChangedListener();
        appManager.addAppListener(new AppsChangedListener(){

            @Override
            public void appsChanged(AppsChangedEvent event) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TreePath[] selectionPaths = InstallAppsPanel.this.resultsTree.getSelectionPaths();
                        InstallAppsPanel.this.updateDescriptionBox();
                        InstallAppsPanel.this.fillResultsTree(InstallAppsPanel.this.resultsTreeApps);
                        InstallAppsPanel.this.resultsTree.setSelectionPaths(selectionPaths);
                    }
                });
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                InstallAppsPanel.this.queryForApps(false);
            }
        });
    }

    private void setupDownloadSitesChangedListener() {
        this.downloadSitesManager.addDownloadSitesChangedListener(new DownloadSitesManager.DownloadSitesChangedListener(){

            @Override
            public void downloadSitesChanged(DownloadSitesManager.DownloadSitesChangedEvent downloadSitesChangedEvent) {
                List<DownloadSite> sites = InstallAppsPanel.this.downloadSitesManager.getDownloadSites();
                DefaultComboBoxModel<DownloadSite> model = new DefaultComboBoxModel<DownloadSite>(new Vector<DownloadSite>(sites));
                SwingUtilities.invokeLater(() -> InstallAppsPanel.this.downloadSiteComboBox.setModel(model));
            }
        });
    }

    private void queryAppsActionListener(boolean forceRefresh) {
        WebQuerier webQuerier = this.appManager.getWebQuerier();
        DownloadSite downloadSite = (DownloadSite)this.downloadSiteComboBox.getSelectedItem();
        if (downloadSite != null) {
            webQuerier.setCurrentSiteName(downloadSite.getSiteName());
            webQuerier.setCurrentAppStoreUrl(downloadSite.getSiteUrl());
            this.queryForApps(forceRefresh);
        }
    }

    private void queryForApps(final boolean forceRefresh) {
        final WebQuerier webQuerier = this.appManager.getWebQuerier();
        this.taskManager.execute(new TaskIterator(new Task[]{new AbstractTask(){

            public void run(TaskMonitor taskMonitor) throws Exception {
                taskMonitor.setTitle("Getting available apps");
                taskMonitor.setStatusMessage("Obtaining apps from: " + webQuerier.getCurrentAppStoreUrl());
                Set<WebApp> availableApps = webQuerier.getAllApps(forceRefresh);
                if (availableApps == null) {
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    InstallAppsPanel.this.buildTagsTree();
                    InstallAppsPanel.this.fillResultsTree(InstallAppsPanel.this.appManager.getWebQuerier().getAllApps());
                });
            }
        }}));
    }

    private void initComponents() {
        this.searchAppsLabel = new JLabel("Search:");
        this.installFromFileButton = new JButton("Install from File...");
        this.filterTextField = new JTextField();
        this.descriptionSplitPane = new JSplitPane();
        this.tagsSplitPane = new JSplitPane();
        this.tagsScrollPane = new JScrollPane();
        this.tagsTree = new JTree();
        this.resultsScrollPane = new JScrollPane();
        this.resultsTree = new JTree();
        this.descriptionPanel = new JPanel();
        this.descriptionScrollPane = new JScrollPane();
        this.descriptionTextPane = new JTextPane();
        this.viewOnAppStoreButton = new JButton("View on App Store");
        this.installButton = new JButton("Install");
        this.downloadSiteLabel = new JLabel("Download Site:");
        this.downloadSiteComboBox = new JComboBox();
        this.manageSitesButton = new JButton("Manage Sites...");
        this.refreshButton = new JButton("\uf021");
        this.refreshButton.setFont(this.iconManager.getIconFont(14.0f));
        this.refreshButton.setToolTipText("Refresh App List");
        Dimension pref = this.refreshButton.getPreferredSize();
        Dimension d = new Dimension(pref.height, pref.height);
        this.refreshButton.setPreferredSize(d);
        this.refreshButton.setMinimumSize(d);
        this.refreshButton.setMaximumSize(d);
        this.refreshButton.setSize(d);
        this.refreshButton.setHorizontalTextPosition(0);
        this.refreshButton.setVerticalTextPosition(1);
        this.searchAppsLabel.setVisible(!LookAndFeelUtil.isAquaLAF());
        this.filterTextField.putClientProperty("JTextField.variant", "search");
        this.filterTextField.setToolTipText("To search, start typing");
        this.installFromFileButton.addActionListener(evt -> this.installFromFileButtonActionPerformed(evt));
        this.descriptionSplitPane.setBorder(null);
        this.descriptionSplitPane.setDividerLocation(390);
        this.tagsSplitPane.setDividerLocation(175);
        this.tagsSplitPane.setBorder(null);
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("root");
        DefaultMutableTreeNode treeNode2 = new DefaultMutableTreeNode("all apps (0)");
        DefaultMutableTreeNode treeNode3 = new DefaultMutableTreeNode("collections (0)");
        DefaultMutableTreeNode treeNode4 = new DefaultMutableTreeNode("apps by tag");
        treeNode1.add(treeNode2);
        treeNode1.add(treeNode3);
        treeNode1.add(treeNode4);
        this.tagsTree.setModel(new DefaultTreeModel(treeNode1));
        this.tagsTree.setFocusable(false);
        this.tagsTree.setRootVisible(false);
        this.tagsTree.getSelectionModel().setSelectionMode(1);
        this.tagsScrollPane.setViewportView(this.tagsTree);
        this.tagsSplitPane.setLeftComponent(this.tagsScrollPane);
        treeNode1 = new DefaultMutableTreeNode("root");
        this.resultsTree.setModel(new DefaultTreeModel(treeNode1));
        this.resultsTree.setFocusable(false);
        this.resultsTree.setRootVisible(false);
        this.resultsTree.getSelectionModel().setSelectionMode(1);
        this.resultsScrollPane.setViewportView(this.resultsTree);
        this.tagsSplitPane.setRightComponent(this.resultsScrollPane);
        this.descriptionSplitPane.setLeftComponent(this.tagsSplitPane);
        this.descriptionTextPane.setContentType("text/html");
        this.descriptionTextPane.setEditable(false);
        this.descriptionTextPane.setText("");
        this.descriptionScrollPane.setViewportView(this.descriptionTextPane);
        GroupLayout descriptionPanelLayout = new GroupLayout(this.descriptionPanel);
        this.descriptionPanel.setLayout(descriptionPanelLayout);
        descriptionPanelLayout.setHorizontalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionScrollPane, -1, 162, Short.MAX_VALUE));
        descriptionPanelLayout.setVerticalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionScrollPane, -1, 354, Short.MAX_VALUE));
        this.descriptionSplitPane.setRightComponent(this.descriptionPanel);
        this.viewOnAppStoreButton.setEnabled(false);
        this.viewOnAppStoreButton.addActionListener(evt -> this.viewOnAppStoreButtonActionPerformed(evt));
        this.installButton.setEnabled(false);
        this.installButton.addActionListener(evt -> this.installButtonActionPerformed(evt));
        List<DownloadSite> sites = this.downloadSitesManager.getDownloadSites();
        this.downloadSiteComboBox.setModel(new DefaultComboBoxModel<DownloadSite>(new Vector<DownloadSite>(sites)));
        this.manageSitesButton.addActionListener(evt -> this.manageSitesButtonActionPerformed(evt));
        LookAndFeelUtil.equalizeSize((JComponent[])new JComponent[]{this.installFromFileButton, this.viewOnAppStoreButton, this.installButton});
        JSeparator sep = new JSeparator();
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.downloadSiteLabel).addComponent(this.downloadSiteComboBox, -1, -1, Short.MAX_VALUE).addComponent(this.refreshButton).addComponent(this.manageSitesButton)).addComponent(sep, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.searchAppsLabel).addComponent(this.filterTextField, -1, -1, Short.MAX_VALUE)).addComponent(this.descriptionSplitPane).addGroup(layout.createSequentialGroup().addComponent(this.installFromFileButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 80, Short.MAX_VALUE).addComponent(this.viewOnAppStoreButton).addComponent(this.installButton)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.downloadSiteLabel).addComponent(this.downloadSiteComboBox, -2, -1, -2).addComponent(this.refreshButton, -2, -1, -2).addComponent(this.manageSitesButton, -2, -1, -2)).addComponent(sep, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchAppsLabel).addComponent(this.filterTextField, -2, -1, -2)).addComponent(this.descriptionSplitPane, -1, 360, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.installFromFileButton).addComponent(this.viewOnAppStoreButton).addComponent(this.installButton)));
        this.downloadSiteComboBox.addActionListener(evt -> this.queryAppsActionListener(false));
        this.refreshButton.addActionListener(evt -> this.queryAppsActionListener(true));
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)this.descriptionTextPane.getDocument()).getStyleSheet().addRule(bodyRule);
        DefaultTreeCellRenderer tagsTreeCellRenderer = new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                if (selected && leaf) {
                    this.setIcon(this.getOpenIcon());
                }
                return this;
            }
        };
        tagsTreeCellRenderer.setLeafIcon(tagsTreeCellRenderer.getDefaultClosedIcon());
        this.tagsTree.setCellRenderer(tagsTreeCellRenderer);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.filterTextField != null) {
            this.filterTextField.requestFocusInWindow();
        }
    }

    private void installFromFileButtonActionPerformed(ActionEvent evt) {
        FileChooserFilter fileChooserFilter = new FileChooserFilter("Jar, Zip, and Karaf Kar Files (*.jar, *.zip, *.kar)", new String[]{"jar", "zip", "kar"});
        LinkedList<FileChooserFilter> fileChooserFilters = new LinkedList<FileChooserFilter>();
        fileChooserFilters.add(fileChooserFilter);
        File[] files = this.fileUtil.getFiles((Component)this.parent, "Choose file(s)", 0, "directory.last", "Install", true, fileChooserFilters);
        if (files != null) {
            TaskIterator ti = new TaskIterator(new Task[0]);
            ti.append((Task)new InstallAppsFromFileTask(Arrays.asList(files), this.appManager, true));
            ti.append((Task)new ShowInstalledAppsTask(this.parent));
            this.taskManager.setExecutionContext((Object)this.parent);
            this.taskManager.execute(ti);
        }
    }

    private String splitIntoLines(String text, int charsPerLine) {
        return null;
    }

    private void setupTextFieldListener() {
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){
            ResultsFilterer resultsFilterer = new ResultsFilterer();

            private void showFilteredApps() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        InstallAppsPanel.this.tagsTree.clearSelection();
                        InstallAppsPanel.this.fillResultsTree(resultsFilterer.findMatches(InstallAppsPanel.this.filterTextField.getText(), InstallAppsPanel.this.appManager.getWebQuerier().getAllApps()));
                    }
                });
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                if (InstallAppsPanel.this.filterTextField.getText().length() != 0) {
                    this.showFilteredApps();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                this.showFilteredApps();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
            }
        });
    }

    private void installButtonActionPerformed(ActionEvent evt) {
        WebQuerier webQuerier = this.appManager.getWebQuerier();
        this.taskManager.setExecutionContext((Object)this.parent);
        this.taskManager.execute(new TaskIterator(new Task[]{new InstallAppsFromWebAppTask(Collections.singletonList(this.selectedApp), this.appManager, true)}));
    }

    private void buildTagsTree() {
        WebQuerier webQuerier = this.appManager.getWebQuerier();
        Set<WebApp> availableApps = webQuerier.getAllApps();
        Set<WebQuerier.AppTag> availableTags = webQuerier.getAllTags();
        if (availableApps == null || availableTags == null) {
            return;
        }
        LinkedList<WebQuerier.AppTag> sortedTags = new LinkedList<WebQuerier.AppTag>(availableTags);
        Collections.sort(sortedTags, new Comparator<WebQuerier.AppTag>(){

            @Override
            public int compare(WebQuerier.AppTag tag, WebQuerier.AppTag other) {
                return other.getCount() - tag.getCount();
            }
        });
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        DefaultMutableTreeNode allAppsTreeNode = new DefaultMutableTreeNode("all apps (" + availableApps.size() + ")");
        root.add(allAppsTreeNode);
        DefaultMutableTreeNode collectionsTreeNode = new DefaultMutableTreeNode("collections (0)");
        DefaultMutableTreeNode appsByTagTreeNode = new DefaultMutableTreeNode("apps by tag");
        for (WebQuerier.AppTag appTag : sortedTags) {
            if (appTag.getName().equals("collections")) {
                collectionsTreeNode.setUserObject(appTag);
                continue;
            }
            appsByTagTreeNode.add(new DefaultMutableTreeNode(appTag));
        }
        root.add(collectionsTreeNode);
        root.add(appsByTagTreeNode);
        this.tagsTree.setModel(new DefaultTreeModel(root));
        this.currentSelectedAppTag = null;
    }

    private void updateResultsTree() {
        this.buildTagsTree();
        TreePath selectionPath = this.tagsTree.getSelectionPath();
        this.currentSelectedAppTag = null;
        if (selectionPath != null) {
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
            if (selectedNode.getLevel() == 1 && String.valueOf(selectedNode.getUserObject()).startsWith("all apps")) {
                this.fillResultsTree(this.appManager.getWebQuerier().getAllApps());
            } else if (selectedNode.getUserObject() instanceof WebQuerier.AppTag) {
                WebQuerier.AppTag selectedTag = (WebQuerier.AppTag)selectedNode.getUserObject();
                this.fillResultsTree(this.appManager.getWebQuerier().getAppsByTag(selectedTag.getName()));
                this.currentSelectedAppTag = selectedTag;
            } else {
                this.resultsTree.setModel(new DefaultTreeModel(null));
            }
        } else {
            this.fillResultsTree(this.appManager.getWebQuerier().getAllApps());
        }
    }

    private void fillResultsTree(Set<WebApp> webApps) {
        if (webApps == null) {
            this.resultsTree.setModel(new DefaultTreeModel(null));
            this.resultsTreeApps = new HashSet<WebApp>();
            return;
        }
        this.appManager.getWebQuerier().checkWebAppInstallStatus(webApps, this.appManager);
        LinkedList<WebApp> sortedApps = new LinkedList<WebApp>(webApps);
        Collections.sort(sortedApps, new Comparator<WebApp>(){

            @Override
            public int compare(WebApp webApp, WebApp other) {
                return webApp.getName().compareToIgnoreCase(other.getName());
            }
        });
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        for (WebApp webApp : sortedApps) {
            if (webApp.getCorrespondingApp() != null && webApp.getCorrespondingApp().getStatus() == App.AppStatus.INSTALLED) {
                webApp.setAppListDisplayName(webApp.getFullName() + " (Installed)");
            } else {
                webApp.setAppListDisplayName(webApp.getFullName());
            }
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(webApp);
            root.add(treeNode);
        }
        this.resultsTree.setModel(new DefaultTreeModel(root));
        this.resultsTreeApps = new HashSet<WebApp>(webApps);
    }

    private void updateDescriptionBox() {
        TreePath selectedPath = this.resultsTree.getSelectionPath();
        if (selectedPath != null) {
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.resultsTree.getSelectionPath().getLastPathComponent();
            WebApp selectedApp = (WebApp)selectedNode.getUserObject();
            boolean appAlreadyInstalled = selectedApp.getCorrespondingApp() != null && selectedApp.getCorrespondingApp().getStatus() == App.AppStatus.INSTALLED;
            Object text = "";
            text = (String)text + "<html> <body hspace=\"4\" vspace=\"2\">";
            text = (String)text + "<b>" + selectedApp.getFullName() + "</b>";
            String latestReleaseVersion = selectedApp.getReleases().get(selectedApp.getReleases().size() - 1).getReleaseVersion();
            text = (String)text + "<br />" + latestReleaseVersion;
            if (appAlreadyInstalled && !selectedApp.getCorrespondingApp().getVersion().equalsIgnoreCase(latestReleaseVersion)) {
                text = (String)text + " (installed: " + selectedApp.getCorrespondingApp().getVersion() + ")";
            }
            text = (String)text + "<p>";
            text = (String)text + "<img border=\"0\" ";
            text = (String)text + "src=\"" + this.appManager.getWebQuerier().getDefaultAppStoreUrl() + selectedApp.getIconUrl() + "\" alt=\"" + selectedApp.getFullName() + "\"/>";
            text = (String)text + "</p>";
            text = (String)text + "<p>";
            text = (String)text + (String.valueOf(selectedApp.getDescription()).equalsIgnoreCase("null") ? "App description not found." : selectedApp.getDescription());
            text = (String)text + "</p>";
            text = (String)text + "</body> </html>";
            this.descriptionTextPane.setText((String)text);
            this.selectedApp = selectedApp;
            if (appAlreadyInstalled) {
                this.installButton.setEnabled(false);
            } else {
                this.installButton.setEnabled(true);
            }
            this.viewOnAppStoreButton.setEnabled(true);
        } else {
            this.descriptionTextPane.setText("");
            this.selectedApp = null;
            this.installButton.setEnabled(false);
            this.viewOnAppStoreButton.setEnabled(false);
        }
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
    }

    private void viewOnAppStoreButtonActionPerformed(ActionEvent evt) {
        if (this.selectedApp == null) {
            return;
        }
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(new URL(this.selectedApp.getPageUrl()).toURI());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    private void manageSitesButtonActionPerformed(ActionEvent evt) {
        if (this.parent instanceof AppManagerDialog) {
            ((AppManagerDialog)this.parent).showManageDownloadSitesDialog();
        }
    }
}

