/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.task;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.task.AbstractAppTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class UninstallTask
extends AbstractAppTask
implements ObservableTask {
    @Tunable(description="Name of app to uninstall", longDescription="The name of the app to uninstall", exampleStringValue="stringApp", context="nogui", required=true)
    public String app = null;
    String error = null;
    App appObject = null;

    public UninstallTask(AppManager appManager) {
        super(appManager);
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        if (this.app == null) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "App name not provided");
            return;
        }
        taskMonitor.setTitle("Uninstalling app " + this.app);
        this.appObject = this.getApp(this.app);
        if (this.appObject == null) {
            this.error = "Can't find app '" + this.app + "'";
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, this.error);
            return;
        }
        this.appManager.uninstallApp(this.appObject);
        this.updateApps();
        String msg = "App '" + this.app + "' uninstalled";
        taskMonitor.showMessage(TaskMonitor.Level.INFO, msg);
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, JSONResult.class);
    }

    public <R> R getResults(Class<? extends R> type) {
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.error != null) {
                    return "{\"error\": \"" + this.error + "\"}";
                }
                return "{\"appName\": \"" + this.app + "\"}";
            };
            return (R)res;
        }
        if (type.equals(String.class)) {
            if (this.error != null) {
                return (R)this.error;
            }
            String msg = "App '" + this.app + "' uninstalled";
            return (R)msg;
        }
        return null;
    }
}

