/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.net.DownloadStatus;
import org.cytoscape.app.internal.net.WebApp;
import org.cytoscape.app.internal.net.WebQuerier;
import org.cytoscape.app.internal.task.InstallAppsTask;
import org.cytoscape.app.internal.task.ResolveAppConflictTask;
import org.cytoscape.application.CyVersion;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;

public class ResolveAppDependenciesTask
extends AbstractTask {
    private TaskMonitor taskMonitor;
    private DownloadStatus status;
    private Queue<App> appQueue;
    private Stack<String> dependencyStack;
    private List<App> appsToInstall;
    private Map<App, App> appsToReplace;
    private final AppManager appManager;
    private final boolean promptToReplace;

    public ResolveAppDependenciesTask(Collection<App> apps, AppManager appManager, boolean promptToReplace) {
        this.appQueue = new LinkedList<App>(apps);
        this.dependencyStack = new Stack();
        this.appsToInstall = new ArrayList<App>();
        this.appsToReplace = new HashMap<App, App>();
        this.appManager = appManager;
        this.promptToReplace = promptToReplace;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        this.status = new DownloadStatus(taskMonitor);
        while (!this.appQueue.isEmpty()) {
            App app = this.appQueue.poll();
            this.resolveAppDependencies(app);
        }
        if (this.promptToReplace && !this.appsToReplace.isEmpty()) {
            this.insertTasksAfterCurrentTask(new Task[]{new ResolveAppConflictTask(this.appsToInstall, this.appsToReplace, this.appManager)});
        } else {
            this.insertTasksAfterCurrentTask(new Task[]{new InstallAppsTask(this.appsToInstall, this.appsToReplace, this.appManager)});
        }
    }

    private void resolveAppDependencies(App appToInstall) throws Exception {
        CyVersion version = this.appManager.getCyVersion();
        if (!appToInstall.isCompatible(version)) {
            throw new Exception("Unable to install " + appToInstall.getAppName() + ".\nIt is incompatible with this version of Cytoscape (" + version.getVersion() + ").");
        }
        this.taskMonitor.setStatusMessage("Resolving dependencies for " + appToInstall.getAppName() + "...");
        for (App installedApp : this.appManager.getInstalledApps()) {
            if (!installedApp.getAppName().equals(appToInstall.getAppName())) continue;
            this.appsToReplace.put(appToInstall, installedApp);
            break;
        }
        this.dependencyStack.push(appToInstall.getAppName());
        if (appToInstall.getDependencies() != null) {
            for (App.Dependency dep : appToInstall.getDependencies()) {
                if (this.dependencyStack.contains(dep.getName())) {
                    throw new Exception("Invalid circular dependency: " + dep.getName());
                }
                if (this.findAppForDep(dep, this.appsToInstall) != null || this.findAppForDep(dep, this.appManager.getInstalledApps()) != null) continue;
                App dependencyApp = this.findAppForDep(dep, this.appQueue);
                if (dependencyApp != null) {
                    this.appQueue.remove(dependencyApp);
                } else {
                    Set<WebApp> webApps = this.appManager.getWebQuerier().getAllApps();
                    if (webApps == null) {
                        throw new Exception("Cannot access the App Store to resolve dependencies. Please check your internet connection.");
                    }
                    WebApp webApp = this.findWebAppForDep(dep, webApps);
                    if (webApp == null) {
                        throw new Exception("Cannot find dependency: " + (String)this.dependencyStack.firstElement() + " requires " + dep.getName() + ", which is not available in the App Store");
                    }
                    List<WebApp.Release> releases = webApp.getReleases();
                    WebApp.Release latestRelease = releases.get(releases.size() - 1);
                    if (WebQuerier.compareVersions(dep.getVersion(), latestRelease.getReleaseVersion()) >= 0) {
                        this.taskMonitor.setStatusMessage("Downloading dependency for " + (String)this.dependencyStack.firstElement() + ": " + webApp.getFullName());
                        File appFile = this.appManager.getWebQuerier().downloadApp(webApp, null, new File(this.appManager.getDownloadedAppsPath()), this.status);
                        dependencyApp = this.appManager.getAppParser().parseApp(appFile);
                    } else {
                        throw new Exception("Cannot find dependency: " + (String)this.dependencyStack.firstElement() + " requires " + dep.getName() + " " + dep.getVersion() + " or later, latest release in App Store is " + latestRelease.getReleaseVersion());
                    }
                }
                this.resolveAppDependencies(dependencyApp);
            }
        }
        this.dependencyStack.pop();
        this.appsToInstall.add(appToInstall);
    }

    private App findAppForDep(App.Dependency dep, Collection<App> apps) {
        for (App app : apps) {
            if (!app.getAppName().equalsIgnoreCase(dep.getName()) || WebQuerier.compareVersions(dep.getVersion(), app.getVersion()) < 0) continue;
            return app;
        }
        return null;
    }

    private WebApp findWebAppForDep(App.Dependency dep, Collection<WebApp> webApps) {
        for (WebApp webApp : webApps) {
            if (!webApp.getName().equalsIgnoreCase(dep.getName())) continue;
            return webApp;
        }
        return null;
    }
}

