/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.task;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.task.AbstractAppTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;
import org.json.JSONObject;

public class ListAppsTask
extends AbstractAppTask
implements ObservableTask {
    App.AppStatus status;

    public ListAppsTask(AppManager appManager, App.AppStatus status) {
        super(appManager);
        this.status = status;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setTitle("Listing " + this.status.toString() + " apps");
        this.updateApps();
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(List.class, String.class, JSONResult.class);
    }

    public static String jsonQuote(String input) {
        if (input == null) {
            return null;
        }
        return JSONObject.quote((String)input);
    }

    public <R> R getResults(Class<? extends R> type) {
        List<App> statusAppList = this.getApps(this.status);
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                StringBuilder stringBuilder = new StringBuilder("[");
                int count = statusAppList.size();
                int index = 0;
                for (App app : statusAppList) {
                    stringBuilder.append("{\"appName\": " + ListAppsTask.jsonQuote(app.getAppName()) + ",");
                    stringBuilder.append("\"version\": " + ListAppsTask.jsonQuote(app.getVersion()) + ",");
                    stringBuilder.append("\"description\": " + ListAppsTask.jsonQuote(app.getDescription()) + ",");
                    stringBuilder.append("\"status\": " + ListAppsTask.jsonQuote(app.getReadableStatus()) + "}");
                    if (++index >= count) continue;
                    stringBuilder.append(",");
                }
                stringBuilder.append("]");
                return stringBuilder.toString();
            };
            return (R)res;
        }
        if (type.equals(String.class)) {
            ArrayList<CallSite> appList = new ArrayList<CallSite>(statusAppList.size());
            for (App app : statusAppList) {
                appList.add((CallSite)((Object)("name: " + app.getAppName() + ", version: " + app.getVersion() + ", status: " + app.getReadableStatus())));
            }
            Collections.sort(appList);
            Object list = "";
            for (String string : appList) {
                list = (String)list + string + "\n";
            }
            return (R)list;
        }
        if (type.equals(List.class)) {
            ArrayList<String> list = new ArrayList<String>();
            for (App app : statusAppList) {
                list.add(app.getAppName());
            }
            return (R)list;
        }
        return null;
    }
}

