/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.net.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.net.WebApp;
import org.cytoscape.app.internal.net.server.CyHttpRequest;
import org.cytoscape.app.internal.net.server.CyHttpResponder;
import org.cytoscape.app.internal.net.server.CyHttpResponse;
import org.cytoscape.app.internal.net.server.CyHttpResponseFactory;
import org.cytoscape.app.internal.net.server.CyHttpResponseFactoryImpl;
import org.cytoscape.app.internal.task.InstallAppsFromWebAppTask;
import org.cytoscape.application.CyVersion;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskManager;
import org.cytoscape.work.TaskObserver;
import org.json.JSONObject;

public class AppGetResponder {
    private static final CyHttpResponseFactory responseFactory = new CyHttpResponseFactoryImpl();
    private AppManager appManager;
    private CyVersion cyVersion;

    public AppGetResponder(AppManager appManager, CyVersion cyVersion) {
        this.appManager = appManager;
        this.cyVersion = cyVersion;
    }

    public class InstallResponder
    extends JsonResponder
    implements TaskObserver {
        final Pattern pattern = Pattern.compile("^/install/(.+)/(.+)$");
        final Semaphore semaphore = new Semaphore(0);
        String installStatus = "app-not-found";
        String installError = "";

        @Override
        public Pattern getURIPattern() {
            return this.pattern;
        }

        @Override
        protected Map<String, String> jsonRespond(CyHttpRequest request, Matcher matchedURI) {
            HashMap<String, String> responseData = new HashMap<String, String>();
            String appName = matchedURI.group(1);
            String version = matchedURI.group(2);
            if (appName != null && appName.length() != 0 && version != null && version.length() != 0) {
                boolean appFoundInStore = false;
                WebApp appToDownload = null;
                for (WebApp webApp : AppGetResponder.this.appManager.getWebQuerier().getAllApps()) {
                    if (!webApp.getName().equals(appName)) continue;
                    appFoundInStore = true;
                    appToDownload = webApp;
                    break;
                }
                responseData.put("name", appName);
                if (appFoundInStore) {
                    WebApp webApp = appToDownload;
                    TaskManager taskManager = AppGetResponder.this.appManager.getSwingAppAdapter().getTaskManager();
                    taskManager.execute(new TaskIterator(new Task[]{new InstallAppsFromWebAppTask(Collections.singletonList(webApp), AppGetResponder.this.appManager, true)}), (TaskObserver)this);
                    this.semaphore.acquireUninterruptibly();
                } else {
                    this.installStatus = "install failed: this app is incompatible with your version of Cytoscape";
                    this.installError = "The app " + appName + " is not found in the app store database at " + AppGetResponder.this.appManager.getWebQuerier().getDefaultAppStoreUrl();
                }
                responseData.put("install_status", this.installStatus);
                responseData.put("install_error", this.installError);
            }
            return responseData;
        }

        public void taskFinished(ObservableTask task) {
        }

        public void allFinished(FinishStatus finishStatus) {
            if (finishStatus.getType() == FinishStatus.Type.SUCCEEDED) {
                this.installStatus = "success";
            } else if (finishStatus.getType() == FinishStatus.Type.CANCELLED) {
                this.installStatus = "install-failed";
                this.installError = "Install cancelled by user.";
            } else {
                this.installStatus = "install-failed";
                this.installError = finishStatus.getException().getMessage();
            }
            this.semaphore.release();
        }
    }

    public class StatusResponder
    extends JsonResponder {
        final Pattern pattern = Pattern.compile("^/status/(.*)$");

        @Override
        public Pattern getURIPattern() {
            return this.pattern;
        }

        @Override
        protected Map<String, String> jsonRespond(CyHttpRequest request, Matcher matchedURI) {
            HashMap<String, String> responseData = new HashMap<String, String>();
            String appName = matchedURI.group(1);
            if (appName != null && appName.length() != 0) {
                String status = "not-found";
                String version = "not-found";
                for (App app : AppGetResponder.this.appManager.getApps()) {
                    if (!app.getAppName().equalsIgnoreCase(appName)) continue;
                    if (app.getStatus() != null) {
                        status = app.getStatus().toString().toLowerCase();
                    }
                    if (app.getVersion() == null) continue;
                    version = app.getVersion();
                }
                responseData.put("request_name", appName);
                responseData.put("status", status);
                responseData.put("version", version);
            }
            return responseData;
        }
    }

    private static abstract class JsonResponder
    implements CyHttpResponder {
        private JsonResponder() {
        }

        protected abstract Map<String, String> jsonRespond(CyHttpRequest var1, Matcher var2);

        @Override
        public CyHttpResponse respond(CyHttpRequest request, Matcher matchedURI) {
            Map<String, String> responseData = this.jsonRespond(request, matchedURI);
            JSONObject jsonObject = new JSONObject(responseData);
            return responseFactory.createHttpResponse(jsonObject.toString(), "application/json");
        }
    }
}

