/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.manager;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.cytoscape.app.event.AppsFinishedStartingEvent;
import org.cytoscape.app.internal.event.AppsChangedEvent;
import org.cytoscape.app.internal.event.AppsChangedListener;
import org.cytoscape.app.internal.exception.AppDisableException;
import org.cytoscape.app.internal.exception.AppInstallException;
import org.cytoscape.app.internal.exception.AppLoadingException;
import org.cytoscape.app.internal.exception.AppParsingException;
import org.cytoscape.app.internal.exception.AppStartupException;
import org.cytoscape.app.internal.exception.AppUninstallException;
import org.cytoscape.app.internal.exception.AppUnloadingException;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.manager.AppParser;
import org.cytoscape.app.internal.manager.SimpleApp;
import org.cytoscape.app.internal.net.WebQuerier;
import org.cytoscape.app.internal.ui.AppManagerDialog;
import org.cytoscape.app.internal.util.DebugHelper;
import org.cytoscape.app.swing.CySwingAppAdapter;
import org.cytoscape.application.CyApplicationConfiguration;
import org.cytoscape.application.CyVersion;
import org.cytoscape.application.events.CyStartEvent;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.service.startlevel.StartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppManager
implements FrameworkListener {
    private static final Logger sysLogger = LoggerFactory.getLogger(AppManager.class);
    private static final Logger userLogger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String[] APP_EXTENSIONS = new String[]{"jar"};
    private static final String INSTALLED_APPS_DIRECTORY_NAME = "installed";
    private static final String UNINSTALLED_APPS_DIRECTORY_NAME = "uninstalled";
    private static final String DISABLED_APPS_DIRECTORY_NAME = "disabled";
    private static final String DOWNLOADED_APPS_DIRECTORY_NAME = "download-temp";
    private static final String TEMPORARY_LOADED_APPS_DIRECTORY_NAME = ".temp-installed";
    private static final String INSTALL_RESTART_DIRECTORY_NAME = "install-on-restart";
    private static final String BUNDLED_APPS_DIRECTORY_NAME = "apps";
    private static final String APPS_DIRECTORY_NAME = "3" + File.separator + "apps";
    private static final int APP_START_LEVEL = 200;
    private Set<App> apps;
    private List<AppsChangedListener> appListeners;
    private AppParser appParser;
    private WebQuerier webQuerier;
    private CyEventHelper eventHelper;
    private CyVersion version;
    private CyApplicationConfiguration applicationConfiguration;
    private CySwingAppAdapter swingAppAdapter;
    private BundleContext bundleContext;
    private FileAlterationMonitor fileAlterationMonitor;
    private StartLevel startLevel;
    private boolean isInitialized;
    private AppManagerDialog appManagerDialog = null;
    private final Object lock = new Object();

    public AppManager(CySwingAppAdapter swingAppAdapter, CyApplicationConfiguration applicationConfiguration, CyVersion version, CyEventHelper eventHelper, WebQuerier webQuerier, StartLevel startLevel, BundleContext bundleContext) {
        this.swingAppAdapter = swingAppAdapter;
        this.applicationConfiguration = applicationConfiguration;
        this.version = version;
        this.eventHelper = eventHelper;
        this.webQuerier = webQuerier;
        webQuerier.setAppManager(this);
        this.startLevel = startLevel;
        this.bundleContext = bundleContext;
        this.appParser = new AppParser();
        this.appListeners = new CopyOnWriteArrayList<AppsChangedListener>();
        this.apps = new CopyOnWriteArraySet<App>();
        this.purgeTemporaryDirectories();
        this.initializeAppsDirectories();
        this.attemptInitialization();
    }

    public void setAppManagerDialog(AppManagerDialog dialog) {
        this.appManagerDialog = dialog;
    }

    public AppManagerDialog getAppManagerDialog() {
        return this.appManagerDialog;
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 8) {
            this.attemptInitialization();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attemptInitialization() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isInitialized && this.startLevel.getStartLevel() >= 200) {
                ExecutorService service = Executors.newSingleThreadExecutor();
                service.submit(() -> {
                    this.initializeApps();
                    this.isInitialized = true;
                });
            }
        }
    }

    void initializeApps() {
        Set<App> installOnRestartApps = this.obtainAppsFromDirectory(new File(this.getInstallOnRestartAppsPath()), false);
        for (App app : installOnRestartApps) {
            try {
                app.moveAppFile(this, new File(this.getInstalledAppsPath()));
                userLogger.debug("Moved app '" + app.getAppName() + "' that was marked for install on restart to the 'installed' directory.");
            }
            catch (IOException iOException) {
                userLogger.error("Cannot move app '" + app.getAppName() + "' that was marked for install on restart to the 'installed' directory:", (Throwable)iOException);
            }
        }
        try {
            FileUtils.deleteDirectory((File)new File(this.getInstallOnRestartAppsPath()));
        }
        catch (IOException e) {
            userLogger.warn("Could not delete the directory of apps to install on restart:", (Throwable)e);
        }
        this.setupAlterationMonitor();
        Set<App> disabledApps = this.obtainAppsFromDirectory(new File(this.getDisabledAppsPath()), false);
        for (App app : disabledApps) {
            try {
                boolean appRegistered = false;
                for (App app2 : this.apps) {
                    if (!app2.heuristicEquals(app)) continue;
                    userLogger.warn("Disabled app '" + app.getAppName() + "' in file '" + app.getAppFile().getAbsolutePath() + "' is equal to an already registered app '" + app2.getAppName() + "' in file '" + (app2.getAppFile() == null ? "N/A" : app2.getAppFile().getAbsolutePath()) + "'");
                    appRegistered = true;
                }
                if (!appRegistered) {
                    this.apps.add(app);
                    app.setStatus(App.AppStatus.DISABLED);
                    continue;
                }
                userLogger.debug("Trying to delete the disabled copy of app '" + app.getAppName() + "' in file '" + app.getAppFile().getAbsolutePath() + "' because another copy exists.");
                FileUtils.deleteQuietly((File)app.getAppFile());
                app.setAppFile(null);
            }
            catch (Throwable e) {
                userLogger.error("Error validating status of the disabled app '" + app.getAppName() + "'.", e);
            }
        }
        Set<App> set = this.obtainAppsFromDirectory(new File(this.getUninstalledAppsPath()), false);
        for (App app : set) {
            try {
                boolean appRegistered = false;
                for (App regApp : this.apps) {
                    if (!regApp.heuristicEquals(app)) continue;
                    userLogger.warn("Uninstalled app '" + app.getAppName() + "' in file '" + app.getAppFile().getAbsolutePath() + "' is equal to an already registered app '" + regApp.getAppName() + "' in file '" + (regApp.getAppFile() == null ? "N/A" : regApp.getAppFile().getAbsolutePath()) + "'");
                    appRegistered = true;
                }
                if (!appRegistered) {
                    this.apps.add(app);
                    app.setStatus(App.AppStatus.UNINSTALLED);
                    continue;
                }
                userLogger.debug("Trying to delete the uninstalled copy of app '" + app.getAppName() + "' in file '" + app.getAppFile().getAbsolutePath() + "' because another copy exists.");
                FileUtils.deleteQuietly((File)app.getAppFile());
                app.setAppFile(null);
            }
            catch (Throwable e) {
                userLogger.error("Error validating status of the uninstalled app '" + app.getAppName() + "'.", e);
            }
        }
        Set<App> set2 = this.obtainAppsFromDirectory(this.getBundledAppsPath(), true);
        set2.addAll(this.obtainAppsFromDirectory(new File(this.getInstalledAppsPath()), false));
        HashMap<String, App> appsToStart = new HashMap<String, App>();
        for (App app : set2) {
            boolean appRegistered = false;
            for (App regApp : this.apps) {
                if (!regApp.heuristicEquals(app)) continue;
                userLogger.warn("Installed app '" + app.getAppName() + "' in file '" + app.getAppFile().getAbsolutePath() + "' is equal to an already registered app '" + regApp.getAppName() + "' in file '" + (regApp.getAppFile() == null ? "N/A" : regApp.getAppFile().getAbsolutePath()) + "'");
                appRegistered = true;
            }
            if (!appRegistered) {
                this.apps.add(app);
                String appName = app.getAppName().toLowerCase();
                App currentVersion = (App)appsToStart.get(appName);
                if (app.isCompatible(this.version)) {
                    if (currentVersion == null) {
                        appsToStart.put(appName, app);
                        continue;
                    }
                    if (this.compareApps(currentVersion, app) > 0) {
                        userLogger.warn("Installed app '" + app.getAppName() + "' version  " + app.getVersion() + " will override an older version (" + currentVersion.getVersion() + ") that was registered previously.");
                        appsToStart.put(appName, app);
                        continue;
                    }
                    userLogger.warn("Installed app '" + app.getAppName() + "' version " + app.getVersion() + " will not be started, because a newer version (" + currentVersion.getVersion() + ") was already registered.");
                    continue;
                }
                userLogger.error("Installed app '" + app.getAppName() + "' is not compatible with the running version of Cytoscape (" + this.version.getVersion() + ").");
                continue;
            }
            userLogger.debug("Trying to delete the installed copy of app '" + app.getAppName() + "' in file '" + app.getAppFile().getAbsolutePath() + "' because another copy exists.");
            FileUtils.deleteQuietly((File)app.getAppFile());
            app.setAppFile(null);
        }
        HashSet<App> coreAppsToStart = new HashSet<App>();
        App app = (App)appsToStart.get("core apps");
        if (app != null && app.getDependencies() != null) {
            for (App.Dependency dep : app.getDependencies()) {
                String appName = dep.getName().toLowerCase();
                App app3 = (App)appsToStart.get(appName);
                if (app3 == null) continue;
                coreAppsToStart.add(app3);
            }
            coreAppsToStart.add(app);
        }
        if (!this.startApps(coreAppsToStart)) {
            userLogger.warn("One or more core apps failed to load or start");
        }
        this.eventHelper.fireEvent((CyEvent)new CyStartEvent((Object)this));
        HashSet<App> otherAppsToStart = new HashSet<App>(appsToStart.values());
        otherAppsToStart.removeAll(coreAppsToStart);
        if (!this.startApps(otherAppsToStart)) {
            userLogger.warn("One or more apps failed to load or start");
        }
        this.eventHelper.fireEvent((CyEvent)new AppsFinishedStartingEvent((Object)this));
    }

    private int compareApps(App app1, App app2) {
        int result = WebQuerier.compareVersions(app1.getVersion(), app2.getVersion());
        if (result == 0) {
            result = Boolean.valueOf(app2.isBundledApp()).compareTo(app1.isBundledApp());
        }
        return result;
    }

    private boolean startApps(Collection<App> apps) {
        boolean success = true;
        Iterator<App> i = apps.iterator();
        while (i.hasNext()) {
            App app = i.next();
            try {
                app.load(this);
                userLogger.debug("Loaded app " + app.getAppName());
            }
            catch (AppLoadingException e) {
                i.remove();
                success = false;
                app.setStatus(App.AppStatus.FAILED_TO_LOAD);
                userLogger.error("Failed to load app " + app.getAppName(), (Throwable)e);
            }
        }
        for (App app : apps) {
            try {
                app.start(this);
                app.setStatus(App.AppStatus.INSTALLED);
                userLogger.debug("Started app " + app.getAppName());
            }
            catch (AppStartupException e) {
                success = false;
                app.setStatus(App.AppStatus.FAILED_TO_START);
                userLogger.error("Failed to start app " + app.getAppName(), (Throwable)e);
            }
        }
        return success;
    }

    private void setupAlterationMonitor() {
        this.fileAlterationMonitor = new FileAlterationMonitor(2000L);
        File installedAppsPath = new File(this.getInstalledAppsPath());
        FileAlterationObserver installAlterationObserver = new FileAlterationObserver(installedAppsPath, (FileFilter)new AppFileFilter(installedAppsPath), IOCase.SYSTEM);
        final AppManager appManager = this;
        installAlterationObserver.addListener((FileAlterationListener)new FileAlterationListenerAdaptor(){

            public void onFileCreate(File file) {
                App parsedApp = null;
                try {
                    parsedApp = AppManager.this.appParser.parseApp(file);
                }
                catch (AppParsingException e) {
                    userLogger.error("Could not parse app from newly discovered file '" + file.getAbsolutePath() + "' :", (Throwable)e);
                    return;
                }
                boolean startApp = parsedApp.isCompatible(AppManager.this.version);
                if (!startApp) {
                    userLogger.error("Newly discovered app '" + parsedApp.getAppName() + "' is not compatible with the running version of Cytoscape (" + AppManager.this.version + ").");
                }
                App registeredApp = null;
                for (App app : AppManager.this.apps) {
                    if (parsedApp.heuristicEquals(app)) {
                        registeredApp = app;
                        userLogger.warn("Newly discovered app '" + parsedApp.getAppName() + "' in file '" + parsedApp.getAppFile().getAbsolutePath() + "' is equal to an already registered app '" + registeredApp.getAppName() + "' in file '" + (registeredApp.getAppFile() == null ? "N/A" : registeredApp.getAppFile().getAbsolutePath()) + "'");
                        File oldFile = registeredApp.getAppFile();
                        if (oldFile != null && oldFile.exists() && !registeredApp.getAppFile().equals(parsedApp.getAppFile())) {
                            userLogger.debug("Trying to delete the installed copy of app '" + registeredApp.getAppName() + "' in file '" + registeredApp.getAppFile().getAbsolutePath() + "' because another copy exists.");
                            FileUtils.deleteQuietly((File)oldFile);
                        }
                        registeredApp.setAppFile(file);
                        registeredApp.setStatus(App.AppStatus.INACTIVE);
                        continue;
                    }
                    if (!parsedApp.isCompatible(AppManager.this.version) || !parsedApp.getAppName().equals(app.getAppName())) continue;
                    try {
                        if (app.isDetached() || !app.isCompatible(AppManager.this.version)) continue;
                        if (AppManager.this.compareApps(parsedApp, app) > 0) {
                            startApp = false;
                            userLogger.warn("Not starting newly discovered app '" + parsedApp.getAppName() + "' because a newer version is already loaded.");
                            continue;
                        }
                        app.unload(AppManager.this);
                        app.setStatus(App.AppStatus.INACTIVE);
                        userLogger.warn("Unloading app '" + app.getAppName() + "' because the newly discovered app '" + parsedApp.getAppName() + "' is a newer version.");
                    }
                    catch (AppUnloadingException e) {
                        userLogger.warn("Failed to unload app " + app.getAppName(), (Throwable)e);
                    }
                }
                App app = null;
                if (registeredApp == null) {
                    app = parsedApp;
                    AppManager.this.apps.add(app);
                } else {
                    app = registeredApp;
                }
                try {
                    if (startApp) {
                        app.load(appManager);
                        app.start(appManager);
                        app.setStatus(App.AppStatus.INSTALLED);
                        userLogger.debug("Started newly discovered app '" + app.getAppName() + "'.");
                    }
                }
                catch (AppLoadingException e) {
                    app.setStatus(App.AppStatus.FAILED_TO_LOAD);
                    userLogger.error("Failed to load app " + app.getAppName(), (Throwable)e);
                }
                catch (AppStartupException e) {
                    app.setStatus(App.AppStatus.FAILED_TO_START);
                    userLogger.error("Failed to start app " + app.getAppName(), (Throwable)e);
                }
                AppManager.this.fireAppsChangedEvent();
            }

            public void onFileChange(File file) {
                this.onFileDelete(file);
                this.onFileCreate(file);
                AppManager.this.fireAppsChangedEvent();
            }

            public void onFileDelete(File file) {
                DebugHelper.print(this + " installObserverDelete", file.getAbsolutePath() + " deleted.");
                App registeredApp = null;
                for (App app : AppManager.this.apps) {
                    if (!file.equals(app.getAppFile())) continue;
                    app.setAppFile(null);
                    registeredApp = app;
                    break;
                }
                if (registeredApp == null) {
                    return;
                }
                try {
                    registeredApp.unload(appManager);
                    registeredApp.setStatus(App.AppStatus.FILE_MOVED);
                    userLogger.debug("Unloaded app '" + registeredApp.getAppName() + "', because its file is no longer available.");
                }
                catch (AppUnloadingException e) {
                    userLogger.warn("Failed to unload app " + registeredApp.getAppName(), (Throwable)e);
                }
                if (file.exists()) {
                    App parsedApp = null;
                    try {
                        parsedApp = AppManager.this.appParser.parseApp(file);
                    }
                    catch (AppParsingException e) {
                        return;
                    }
                    if (parsedApp.isCompatible(AppManager.this.version) && registeredApp.getAppName().equalsIgnoreCase(parsedApp.getAppName())) {
                        return;
                    }
                }
                App appToStart = null;
                for (App app : AppManager.this.apps) {
                    if (app.isDetached() || !app.isCompatible(AppManager.this.version) || !app.getAppName().equalsIgnoreCase(registeredApp.getAppName()) || appToStart != null && AppManager.this.compareApps(appToStart, app) <= 0) continue;
                    appToStart = app;
                }
                if (appToStart != null) {
                    try {
                        appToStart.load(appManager);
                        appToStart.start(appManager);
                        appToStart.setStatus(App.AppStatus.INSTALLED);
                        userLogger.debug("Started app " + appToStart.getAppName() + " because a different version has been unloaded.");
                    }
                    catch (AppLoadingException e) {
                        appToStart.setStatus(App.AppStatus.FAILED_TO_LOAD);
                        userLogger.error("Failed to load app " + appToStart.getAppName(), (Throwable)e);
                    }
                    catch (AppStartupException e) {
                        appToStart.setStatus(App.AppStatus.FAILED_TO_START);
                        userLogger.error("Failed to start app " + appToStart.getAppName(), (Throwable)e);
                    }
                }
                AppManager.this.fireAppsChangedEvent();
            }
        });
        FileAlterationObserver disableAlterationObserver = new FileAlterationObserver(this.getDisabledAppsPath(), (FileFilter)new AppFileFilter(new File(this.getDisabledAppsPath())), IOCase.SYSTEM);
        disableAlterationObserver.addListener((FileAlterationListener)new FileAlterationListenerAdaptor(){

            public void onFileCreate(File file) {
                App parsedApp = null;
                try {
                    parsedApp = AppManager.this.appParser.parseApp(file);
                }
                catch (AppParsingException e) {
                    return;
                }
                DebugHelper.print(this + " disableObserver Create", parsedApp.getAppName() + " parsed");
                App registeredApp = null;
                for (App app : AppManager.this.apps) {
                    if (!parsedApp.heuristicEquals(app)) continue;
                    registeredApp = app;
                    File oldFile = registeredApp.getAppFile();
                    if (oldFile != null && oldFile.exists() && !registeredApp.getAppFile().equals(parsedApp.getAppFile())) {
                        DebugHelper.print(this + " disableObserverCreate", registeredApp.getAppName() + " moved from " + registeredApp.getAppFile().getAbsolutePath() + " to " + parsedApp.getAppFile().getAbsolutePath() + ". deleting: " + oldFile);
                        FileUtils.deleteQuietly((File)oldFile);
                    }
                    registeredApp.setAppFile(file);
                }
                App app = null;
                if (registeredApp == null) {
                    app = parsedApp;
                    AppManager.this.apps.add(app);
                } else {
                    app = registeredApp;
                }
                app.setStatus(App.AppStatus.DISABLED);
                AppManager.this.fireAppsChangedEvent();
            }

            public void onFileChange(File file) {
                this.onFileDelete(file);
                this.onFileCreate(file);
                AppManager.this.fireAppsChangedEvent();
            }

            public void onFileDelete(File file) {
                DebugHelper.print(this + " disableObserverDelete", file.getAbsolutePath() + " deleted.");
                for (App app : AppManager.this.apps) {
                    if (!file.equals(app.getAppFile())) continue;
                    app.setAppFile(null);
                    app.setStatus(App.AppStatus.FILE_MOVED);
                    break;
                }
                AppManager.this.fireAppsChangedEvent();
            }
        });
        FileAlterationObserver uninstallAlterationObserver = new FileAlterationObserver(this.getUninstalledAppsPath(), (FileFilter)new AppFileFilter(new File(this.getUninstalledAppsPath())), IOCase.SYSTEM);
        uninstallAlterationObserver.addListener((FileAlterationListener)new FileAlterationListenerAdaptor(){

            public void onFileCreate(File file) {
                App parsedApp = null;
                try {
                    parsedApp = AppManager.this.appParser.parseApp(file);
                }
                catch (AppParsingException e) {
                    return;
                }
                DebugHelper.print(this + " uninstallObserverCreate", parsedApp.getAppName() + " parsed");
                App registeredApp = null;
                for (App app : AppManager.this.apps) {
                    if (!parsedApp.heuristicEquals(app)) continue;
                    registeredApp = app;
                    File oldFile = registeredApp.getAppFile();
                    if (oldFile != null && oldFile.exists() && !registeredApp.getAppFile().equals(parsedApp.getAppFile())) {
                        DebugHelper.print(this + " uninstallObserverCreate", registeredApp.getAppName() + " moved from " + registeredApp.getAppFile().getAbsolutePath() + " to " + parsedApp.getAppFile().getAbsolutePath() + ". deleting: " + oldFile);
                        FileUtils.deleteQuietly((File)oldFile);
                    }
                    registeredApp.setAppFile(file);
                }
                App app = null;
                if (registeredApp == null) {
                    app = parsedApp;
                    AppManager.this.apps.add(app);
                } else {
                    app = registeredApp;
                }
                app.setStatus(App.AppStatus.UNINSTALLED);
                AppManager.this.fireAppsChangedEvent();
            }

            public void onFileChange(File file) {
                this.onFileDelete(file);
                this.onFileCreate(file);
                AppManager.this.fireAppsChangedEvent();
            }

            public void onFileDelete(File file) {
                DebugHelper.print(this + " uninstallObserverDelete", file.getAbsolutePath() + " deleted.");
                for (App app : AppManager.this.apps) {
                    if (!file.equals(app.getAppFile())) continue;
                    app.setAppFile(null);
                    app.setStatus(App.AppStatus.FILE_MOVED);
                    break;
                }
                AppManager.this.fireAppsChangedEvent();
            }
        });
        try {
            installAlterationObserver.initialize();
            this.fileAlterationMonitor.addObserver(installAlterationObserver);
            disableAlterationObserver.initialize();
            this.fileAlterationMonitor.addObserver(disableAlterationObserver);
            uninstallAlterationObserver.initialize();
            this.fileAlterationMonitor.addObserver(uninstallAlterationObserver);
            this.fileAlterationMonitor.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkForFileChanges() {
        for (FileAlterationObserver observer : this.fileAlterationMonitor.getObservers()) {
            observer.checkAndNotify();
        }
    }

    public CySwingAppAdapter getSwingAppAdapter() {
        return this.swingAppAdapter;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public AppParser getAppParser() {
        return this.appParser;
    }

    public WebQuerier getWebQuerier() {
        return this.webQuerier;
    }

    public void addApp(App app) {
        this.apps.add(app);
    }

    public void removeApp(App app) {
        this.apps.remove(app);
    }

    public void installApp(App app) throws AppInstallException {
        if (app.isBundledApp()) {
            return;
        }
        boolean installOnRestart = false;
        if (app instanceof SimpleApp) {
            for (App regApp : this.apps) {
                if (!app.getAppName().equalsIgnoreCase(regApp.getAppName()) || app.isDetached()) continue;
                installOnRestart = true;
            }
        }
        if (installOnRestart) {
            try {
                app.moveAppFile(this, new File(this.getInstallOnRestartAppsPath()));
            }
            catch (IOException e) {
                throw new AppInstallException("Unable to move app file", e);
            }
            this.checkForFileChanges();
            this.apps.add(app);
            app.setStatus(App.AppStatus.TO_BE_INSTALLED);
            this.fireAppsChangedEvent();
        } else {
            try {
                app.moveAppFile(this, new File(this.getInstalledAppsPath()));
            }
            catch (IOException e) {
                throw new AppInstallException("Unable to move app file", e);
            }
            this.checkForFileChanges();
        }
    }

    public void uninstallApp(App app) throws AppUninstallException {
        if (app.isBundledApp()) {
            return;
        }
        try {
            app.moveAppFile(this, new File(this.getUninstalledAppsPath()));
        }
        catch (IOException e) {
            throw new AppUninstallException("Unable to move app file", e);
        }
        this.checkForFileChanges();
    }

    public void disableApp(App app) throws AppDisableException {
        if (app.isBundledApp()) {
            return;
        }
        try {
            app.moveAppFile(this, new File(this.getDisabledAppsPath()));
        }
        catch (IOException e) {
            throw new AppDisableException("Unable to move app file", e);
        }
        this.checkForFileChanges();
    }

    public void fireAppsChangedEvent() {
        AppsChangedEvent appEvent = new AppsChangedEvent(this);
        for (AppsChangedListener appListener : this.appListeners) {
            appListener.appsChanged(appEvent);
        }
    }

    public Set<App> getApps() {
        return this.apps;
    }

    public Set<App> getInstalledApps() {
        HashSet<App> installedApps = new HashSet<App>();
        for (App app : this.apps) {
            if (app.getStatus() == App.AppStatus.INACTIVE || app.isDetached()) continue;
            installedApps.add(app);
        }
        return installedApps;
    }

    public CyVersion getCyVersion() {
        return this.version;
    }

    private File getBaseAppPath() {
        File baseAppPath = null;
        try {
            baseAppPath = new File(this.applicationConfiguration.getConfigurationDirectoryLocation().getCanonicalPath() + File.separator + APPS_DIRECTORY_NAME);
        }
        catch (IOException e) {
            throw new RuntimeException("Unabled to obtain canonical path for Cytoscape local storage directory", e);
        }
        return baseAppPath;
    }

    private File getBundledAppsPath() {
        File path = null;
        try {
            path = new File(this.applicationConfiguration.getInstallationDirectoryLocation().getCanonicalPath() + File.separator + BUNDLED_APPS_DIRECTORY_NAME);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to obtain canonical path for Cytoscape installation directory", e);
        }
        return path;
    }

    public String getInstalledAppsPath() {
        File path = new File(this.getBaseAppPath() + File.separator + INSTALLED_APPS_DIRECTORY_NAME);
        try {
            if (!path.exists()) {
                path.mkdirs();
            }
            return path.getCanonicalPath();
        }
        catch (IOException e) {
            sysLogger.warn("Failed to obtain path to installed apps directory");
            return path.getAbsolutePath();
        }
    }

    public String getDisabledAppsPath() {
        File path = new File(this.getBaseAppPath() + File.separator + DISABLED_APPS_DIRECTORY_NAME);
        try {
            if (!path.exists()) {
                path.mkdirs();
            }
            return path.getCanonicalPath();
        }
        catch (IOException e) {
            sysLogger.warn("Failed to obtain path to disabled apps directory");
            return path.getAbsolutePath();
        }
    }

    public String getTemporaryInstallPath() {
        File path = new File(this.getBaseAppPath() + File.separator + TEMPORARY_LOADED_APPS_DIRECTORY_NAME);
        try {
            if (!path.exists()) {
                path.mkdirs();
            }
            return path.getCanonicalPath();
        }
        catch (IOException e) {
            sysLogger.warn("Failed to obtain canonical path to the temporary installed apps directory");
            return path.getAbsolutePath();
        }
    }

    public String getUninstalledAppsPath() {
        File path = new File(this.getBaseAppPath() + File.separator + UNINSTALLED_APPS_DIRECTORY_NAME);
        try {
            if (!path.exists()) {
                path.mkdirs();
            }
            return path.getCanonicalPath();
        }
        catch (IOException e) {
            sysLogger.warn("Failed to obtain path to uninstalled apps directory");
            return path.getAbsolutePath();
        }
    }

    public String getDownloadedAppsPath() {
        File path = new File(this.getBaseAppPath() + File.separator + DOWNLOADED_APPS_DIRECTORY_NAME);
        try {
            if (!path.exists()) {
                path.mkdirs();
            }
            return path.getCanonicalPath();
        }
        catch (IOException e) {
            sysLogger.warn("Failed to obtain path to downloaded apps directory");
            return path.getAbsolutePath();
        }
    }

    public String getInstallOnRestartAppsPath() {
        File path = new File(this.getBaseAppPath() + File.separator + INSTALL_RESTART_DIRECTORY_NAME);
        try {
            if (!path.exists()) {
                path.mkdirs();
            }
            return path.getCanonicalPath();
        }
        catch (IOException e) {
            sysLogger.warn("Failed to obtain path to directory containing apps to install on restart");
            return path.getAbsolutePath();
        }
    }

    public void purgeTemporaryDirectories() {
        File downloaded = new File(this.getDownloadedAppsPath());
        File uninstalled = new File(this.getUninstalledAppsPath());
        File temporaryInstall = new File(this.getTemporaryInstallPath());
        try {
            FileUtils.deleteDirectory((File)downloaded);
            FileUtils.deleteDirectory((File)uninstalled);
            FileUtils.deleteDirectory((File)temporaryInstall);
        }
        catch (IOException e) {
            sysLogger.warn("Unable to completely remove temporary directories for downloaded, loaded, and uninstalled apps.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<App> obtainAppsFromDirectory(File directory, boolean isBundled) {
        Collection files = FileUtils.listFiles((File)directory, (String[])APP_EXTENSIONS, (boolean)false);
        HashSet<App> parsedApps = new HashSet<App>();
        for (File file : files) {
            App app = null;
            try {
                app = this.appParser.parseApp(file);
                app.setBundledApp(isBundled);
            }
            catch (AppParsingException e) {
                app = null;
            }
            finally {
                if (app == null) continue;
                parsedApps.add(app);
                DebugHelper.print("App parsed: " + app);
            }
        }
        return parsedApps;
    }

    private void initializeAppsDirectories() {
        File installRestartDirectory;
        File downloadedDirectory;
        File uninstalledDirectory;
        File temporaryInstallDirectory;
        File disabledDirectory;
        File installedDirectory;
        boolean created = true;
        File appDirectory = this.getBaseAppPath();
        if (!appDirectory.exists()) {
            created = created && appDirectory.mkdirs();
            sysLogger.debug("Creating " + appDirectory + ". Success? " + created);
        }
        if (!(installedDirectory = new File(this.getInstalledAppsPath())).exists()) {
            created = created && installedDirectory.mkdirs();
            sysLogger.debug("Creating " + installedDirectory + ". Success? " + created);
        }
        if (!(disabledDirectory = new File(this.getDisabledAppsPath())).exists()) {
            created = created && disabledDirectory.mkdirs();
            sysLogger.debug("Creating " + disabledDirectory + ". Success? " + created);
        }
        if (!(temporaryInstallDirectory = new File(this.getTemporaryInstallPath())).exists()) {
            created = created && temporaryInstallDirectory.mkdirs();
            sysLogger.debug("Creating " + temporaryInstallDirectory + ". Success? " + created);
        }
        if (!(uninstalledDirectory = new File(this.getUninstalledAppsPath())).exists()) {
            created = created && uninstalledDirectory.mkdirs();
            sysLogger.debug("Creating " + uninstalledDirectory + ". Success? " + created);
        }
        if (!(downloadedDirectory = new File(this.getDownloadedAppsPath())).exists()) {
            boolean bl = created = created && downloadedDirectory.mkdirs();
        }
        if (!(installRestartDirectory = new File(this.getInstallOnRestartAppsPath())).exists()) {
            created = created && installRestartDirectory.mkdirs();
            sysLogger.debug("Creating " + installRestartDirectory + ". Success? " + created);
        }
        if (!created) {
            sysLogger.error("Failed to create local app storage directories.");
        }
    }

    public void addAppListener(AppsChangedListener appListener) {
        if (this.appListeners.contains(appListener)) {
            return;
        }
        this.appListeners.add(appListener);
    }

    public void removeAppListener(AppsChangedListener appListener) {
        this.appListeners.remove(appListener);
    }

    private class AppFileFilter
    implements FileFilter {
        private File parentDirectory;

        public AppFileFilter(File parentDirectory) {
            this.parentDirectory = parentDirectory;
        }

        @Override
        public boolean accept(File pathName) {
            if (!pathName.getParentFile().equals(this.parentDirectory)) {
                return false;
            }
            if (pathName.isDirectory()) {
                return false;
            }
            for (String extension : APP_EXTENSIONS) {
                if (!pathName.toString().endsWith(extension)) continue;
                return true;
            }
            return false;
        }
    }
}

