/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.manager;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.cytoscape.app.internal.exception.AppLoadingException;
import org.cytoscape.app.internal.exception.AppStartupException;
import org.cytoscape.app.internal.exception.AppStoppingException;
import org.cytoscape.app.internal.exception.AppUnloadingException;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.net.WebQuerier;
import org.cytoscape.application.CyVersion;

public abstract class App {
    private String appName = "";
    private String version = "";
    private String authors = "";
    private String description = null;
    private File appFile = null;
    private String entryClassName;
    private String compatibleVersions;
    private URL appStoreUrl;
    private boolean appValidated = false;
    private boolean officialNameObtained = false;
    private boolean bundledApp;
    private List<Dependency> dependencies = null;
    private AppStatus status = AppStatus.INACTIVE;

    public boolean isHidden() {
        return this.bundledApp || this.status == AppStatus.INACTIVE || this.status == AppStatus.UNINSTALLED || this.status == AppStatus.FILE_MOVED;
    }

    public boolean isDetached() {
        return this.status == AppStatus.UNINSTALLED || this.status == AppStatus.FILE_MOVED || this.status == AppStatus.DISABLED || this.status == AppStatus.TO_BE_INSTALLED;
    }

    public abstract void load(AppManager var1) throws AppLoadingException;

    public abstract void start(AppManager var1) throws AppStartupException;

    public abstract void stop(AppManager var1) throws AppStoppingException;

    public abstract void unload(AppManager var1) throws AppUnloadingException;

    public abstract boolean isCompatible(CyVersion var1);

    protected String suggestFileName(Collection<String> directoryPaths, String desiredFileName) {
        File file;
        int postfixNumber = 1;
        boolean nameCollision = false;
        for (String directoryPath : directoryPaths) {
            file = new File(directoryPath + File.separator + desiredFileName);
            nameCollision = nameCollision || file.exists() && !file.isDirectory();
        }
        String fileBaseName = desiredFileName;
        String fileFullExtension = "";
        int lastPeriodIndex = desiredFileName.lastIndexOf(".");
        if (lastPeriodIndex != -1) {
            fileBaseName = desiredFileName.substring(0, lastPeriodIndex);
            fileFullExtension = desiredFileName.substring(lastPeriodIndex, desiredFileName.length());
        }
        Object newFileName = desiredFileName;
        while (nameCollision) {
            ++postfixNumber;
            nameCollision = false;
            for (String directoryPath : directoryPaths) {
                newFileName = fileBaseName + "-" + postfixNumber + fileFullExtension;
                file = new File(directoryPath + File.separator + (String)newFileName);
                nameCollision = nameCollision || file.exists() && !file.isDirectory();
            }
        }
        return newFileName;
    }

    public boolean heuristicEquals(App other) {
        return this.bundledApp == other.bundledApp && this.appName.equalsIgnoreCase(other.appName) && WebQuerier.compareVersions(this.version, other.version) == 0;
    }

    public String getReadableStatus() {
        return this.getStatus().toString();
    }

    public String getAppName() {
        return this.appName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getAuthors() {
        return this.authors;
    }

    public String getDescription() {
        return this.description;
    }

    public File getAppFile() {
        return this.appFile;
    }

    public String getEntryClassName() {
        return this.entryClassName;
    }

    public String getCompatibleVersions() {
        return this.compatibleVersions;
    }

    public URL getAppStoreUrl() {
        return this.appStoreUrl;
    }

    public boolean isAppValidated() {
        return this.appValidated;
    }

    public boolean isOfficialNameObtained() {
        return this.officialNameObtained;
    }

    public boolean isBundledApp() {
        return this.bundledApp;
    }

    public AppStatus getStatus() {
        return this.status;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setAuthors(String authors) {
        this.authors = authors;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAppFile(File appFile) {
        this.appFile = appFile;
    }

    public void setEntryClassName(String entryClassName) {
        this.entryClassName = entryClassName;
    }

    public void setCompatibleVersions(String compatibleVersions) {
        this.compatibleVersions = compatibleVersions;
    }

    public void setAppStoreUrl(URL appStoreURL) {
        this.appStoreUrl = appStoreURL;
    }

    public void setAppValidated(boolean appValidated) {
        this.appValidated = appValidated;
    }

    public void setOfficialNameObtained(boolean officialNameObtained) {
        this.officialNameObtained = officialNameObtained;
    }

    public void setBundledApp(boolean bundledApp) {
        this.bundledApp = bundledApp;
    }

    public void setStatus(AppStatus status) {
        this.status = status;
    }

    public void setDependencies(List<Dependency> deps) {
        this.dependencies = deps;
    }

    public static boolean delete(File f) {
        if (!f.exists()) {
            System.err.println("Cannot delete, file does not exist: " + f.getPath());
            return false;
        }
        f.setReadable(true);
        f.setWritable(true);
        if (!f.canWrite()) {
            System.err.println("Cannot delete, file is read-only: " + f.getPath());
            return false;
        }
        File parent = f.getParentFile();
        parent.setReadable(true);
        parent.setWritable(true);
        if (!parent.canWrite()) {
            System.err.println("Cannot delete, parent folder read-only: " + parent.getPath());
            return false;
        }
        try {
            new SecurityManager().checkDelete(f.getPath());
        }
        catch (Exception ex) {
            System.err.println("Cannot delete file, " + ex.getMessage());
            return false;
        }
        boolean ret = f.delete();
        if (!ret) {
            System.err.println("Delete failed: " + f.getPath());
        }
        return ret;
    }

    public void moveAppFile(AppManager appManager, File targetDirectory) throws IOException {
        File parentPath = this.getAppFile().getParentFile();
        File installDirectoryPath = new File(appManager.getInstalledAppsPath());
        File disabledDirectoryPath = new File(appManager.getDisabledAppsPath());
        File uninstallDirectoryPath = new File(appManager.getUninstalledAppsPath());
        LinkedList<String> uniqueNameDirectories = new LinkedList<String>();
        if (!parentPath.equals(installDirectoryPath)) {
            uniqueNameDirectories.add(installDirectoryPath.getCanonicalPath());
        }
        if (!parentPath.equals(disabledDirectoryPath)) {
            uniqueNameDirectories.add(disabledDirectoryPath.getCanonicalPath());
        }
        if (!parentPath.equals(uninstallDirectoryPath)) {
            uniqueNameDirectories.add(uninstallDirectoryPath.getCanonicalPath());
        }
        if (!(parentPath.equals(targetDirectory) || installDirectoryPath.equals(targetDirectory) || disabledDirectoryPath.equals(targetDirectory) || uninstallDirectoryPath.equals(targetDirectory))) {
            uniqueNameDirectories.add(targetDirectory.getCanonicalPath());
        }
        LinkedList<File> moveDirectories = new LinkedList<File>();
        moveDirectories.add(installDirectoryPath);
        moveDirectories.add(disabledDirectoryPath);
        moveDirectories.add(uninstallDirectoryPath);
        String targetFilePath = targetDirectory.getCanonicalPath() + File.separator + this.suggestFileName(uniqueNameDirectories, this.getAppFile().getName());
        File tempFile = new File(targetFilePath + ".tmp");
        File targetFile = new File(targetFilePath);
        if (!targetDirectory.equals(parentPath)) {
            if (moveDirectories.contains(parentPath)) {
                FileUtils.moveFile((File)this.getAppFile(), (File)tempFile);
            } else {
                FileUtils.copyFile((File)this.getAppFile(), (File)tempFile);
            }
            tempFile.renameTo(targetFile);
        }
    }

    public String toString() {
        String cls = this.getClass().getSimpleName();
        return String.format("%s [appName=%s, version=%s, status=%s, appFile=%s]", new Object[]{cls, this.appName, this.version, this.status, this.appFile});
    }

    public static enum AppStatus {
        INACTIVE("Inactive"),
        INSTALLED("Installed"),
        DISABLED("Disabled"),
        UNINSTALLED("Uninstalled"),
        TO_BE_INSTALLED("Install on Restart"),
        FILE_MOVED("File Moved (Uninstalled)"),
        FAILED_TO_LOAD("Failed to Load"),
        FAILED_TO_START("Failed to Start");

        String readableStatus;

        private AppStatus(String readableStatus) {
            this.readableStatus = readableStatus;
        }

        public String toString() {
            return this.readableStatus;
        }
    }

    public static class Dependency {
        final String name;
        final String version;

        public Dependency(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return this.name + " " + this.version;
        }
    }
}

