/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.util;

import org.cytoscape.work.util.AbstractBounded;

public final class BoundedDouble
extends AbstractBounded<Double> {
    public BoundedDouble(Double lower, Double initValue, Double upper, boolean lowerStrict, boolean upperStrict) {
        super(lower, initValue, upper, lowerStrict, upperStrict);
    }

    @Override
    public void setValue(String s) {
        this.setValue(Double.valueOf(s));
    }

    @Override
    public Double clamp(Double value) {
        if (value <= (Double)this.getLowerBound()) {
            if (!this.isLowerBoundStrict()) {
                return (Double)this.getLowerBound();
            }
            return Math.nextAfter(value, Double.NEGATIVE_INFINITY);
        }
        if (value >= (Double)this.getUpperBound()) {
            if (!this.isUpperBoundStrict()) {
                return (Double)this.getUpperBound();
            }
            return Math.nextAfter(value, Double.POSITIVE_INFINITY);
        }
        return value;
    }
}

