/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.cytoscape.work.AbstractTunableHandler;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableGravityOrderer;
import org.cytoscape.work.TunableHandler;
import org.cytoscape.work.TunableHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTunableInterceptor<T extends TunableHandler> {
    private boolean throwException = false;
    protected final Map<Object, List<T>> handlerMap = new WeakHashMap<Object, List<T>>();
    protected final Map<Object, Method> titleProviderMap = new WeakHashMap<Object, Method>();
    protected final List<TunableHandlerFactory<T>> tunableHandlerFactories = new ArrayList<TunableHandlerFactory<T>>();
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    void setThrowExceptions(boolean throwException) {
        this.throwException = throwException;
    }

    private List<T> loadTunables(Object obj, double initialOffset) {
        List<T> handlerList = this.handlerMap.get(obj);
        if (handlerList == null) {
            Tunable tunable;
            handlerList = new ArrayList<T>();
            this.handlerMap.put(obj, handlerList);
            for (Field field : obj.getClass().getFields()) {
                if (field.isAnnotationPresent(Tunable.class)) {
                    try {
                        tunable = field.getAnnotation(Tunable.class);
                        T handler = this.getHandler(field, obj, tunable);
                        if (handler instanceof AbstractTunableHandler) {
                            ((AbstractTunableHandler)handler).setOffset(initialOffset);
                        }
                        if (handler != null) {
                            handlerList.add(handler);
                            continue;
                        }
                        this.logOrThrowException("No handler for type: " + field.getType().getName(), null);
                    }
                    catch (Throwable ex) {
                        this.logOrThrowException("tunable field intercept failed for " + field.toString(), ex);
                    }
                    continue;
                }
                if (!field.isAnnotationPresent(ContainsTunables.class)) continue;
                try {
                    Object tunableContainer = field.get(obj);
                    ContainsTunables containsT = field.getAnnotation(ContainsTunables.class);
                    double offset = containsT.offset();
                    if (offset == 999.0) {
                        offset = 0.0;
                    }
                    if (tunableContainer instanceof Task) {
                        List<T> subTaskHandlers = this.loadTunables(tunableContainer, initialOffset + offset);
                        handlerList.addAll(subTaskHandlers);
                        this.handlerMap.put(tunableContainer, new ArrayList());
                        continue;
                    }
                    if (this.handlerMap.containsKey(tunableContainer)) continue;
                    handlerList.addAll(this.loadTunables(tunableContainer, initialOffset));
                }
                catch (Throwable ex) {
                    this.logOrThrowException("ContainsTunables field intercept failed for " + field.toString(), ex);
                }
            }
            for (AccessibleObject accessibleObject : obj.getClass().getMethods()) {
                if (accessibleObject.isAnnotationPresent(Tunable.class)) {
                    try {
                        tunable = ((Method)accessibleObject).getAnnotation(Tunable.class);
                        String rootName = this.validateAndExtractRootName((Method)accessibleObject);
                        Method setter = this.findCompatibleSetter(obj, rootName, ((Method)accessibleObject).getReturnType());
                        T handler = this.getHandler((Method)accessibleObject, setter, obj, tunable);
                        if (handler instanceof AbstractTunableHandler) {
                            ((AbstractTunableHandler)handler).setOffset(initialOffset);
                        }
                        if (handler == null) {
                            this.logOrThrowException("Failed to create a handler for " + setter.getName() + "().", null);
                            continue;
                        }
                        handlerList.add(handler);
                    }
                    catch (Throwable t) {
                        this.logOrThrowException("tunable method intercept failed for " + ((Method)accessibleObject).toString(), t);
                    }
                    continue;
                }
                if (!accessibleObject.isAnnotationPresent(ProvidesTitle.class)) continue;
                if (!String.class.isAssignableFrom(((Method)accessibleObject).getReturnType())) {
                    throw new IllegalArgumentException(((Method)accessibleObject).getName() + " annotated with @ProvidesTitle must return String.");
                }
                if (((Method)accessibleObject).getParameterTypes().length != 0) {
                    throw new IllegalArgumentException(((Method)accessibleObject).getName() + " annotated with @ProvidesTitle must take 0 arguments.");
                }
                if (this.titleProviderMap.containsKey(obj) && initialOffset == 0.0) {
                    throw new IllegalArgumentException("Classes must have at most one @ProvidesTitle annotated method but " + ((Method)accessibleObject).getDeclaringClass().getName() + " has more than one.");
                }
                this.titleProviderMap.put(obj, (Method)accessibleObject);
            }
            Collections.sort(handlerList, new TunableGravityOrderer());
        }
        return handlerList;
    }

    private boolean isValidGetter(Method getterCandidate) {
        try {
            Type returnType = getterCandidate.getGenericReturnType();
            if (returnType == Void.class) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return getterCandidate.getParameterTypes().length == 0;
    }

    private Method findCompatibleSetter(Object obj, String rootName, Class<?> getterReturnType) {
        Method ret;
        try {
            ret = obj.getClass().getMethod("set" + rootName, getterReturnType);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't find a setter compatible with the get" + rootName + "() getter.", e);
        }
        return ret;
    }

    public final List<T> getHandlers(Object o) {
        if (o == null) {
            return Collections.emptyList();
        }
        return this.loadTunables(o, 0.0);
    }

    public boolean hasTunables(Object o) {
        for (Field field : o.getClass().getFields()) {
            if (field.isAnnotationPresent(Tunable.class)) {
                return true;
            }
            if (!field.isAnnotationPresent(ContainsTunables.class)) continue;
            try {
                Object tunableContainer = field.get(o);
                return this.hasTunables(tunableContainer);
            }
            catch (Throwable ex) {
                logger.debug("ContainsTunables field intercept failed for " + field.toString(), ex);
                return false;
            }
        }
        for (AccessibleObject accessibleObject : o.getClass().getMethods()) {
            if (!accessibleObject.isAnnotationPresent(Tunable.class)) continue;
            return true;
        }
        return false;
    }

    private T getHandler(Field field, Object instance, Tunable tunable) {
        for (TunableHandlerFactory<T> thf : this.tunableHandlerFactories) {
            T th = thf.createTunableHandler(field, instance, tunable);
            if (th == null) continue;
            return th;
        }
        return null;
    }

    private T getHandler(Method getter, Method setter, Object instance, Tunable tunable) {
        for (TunableHandlerFactory<T> thf : this.tunableHandlerFactories) {
            T th = thf.createTunableHandler(getter, setter, instance, tunable);
            if (th == null) continue;
            return th;
        }
        return null;
    }

    public void addTunableHandlerFactory(TunableHandlerFactory<T> thf, Map properties) {
        if (thf != null) {
            this.tunableHandlerFactories.add(thf);
        }
    }

    public void removeTunableHandlerFactory(TunableHandlerFactory<T> thf, Map properties) {
        this.tunableHandlerFactories.remove(thf);
    }

    private final void logOrThrowException(String msg, Throwable ex) {
        if (this.throwException) {
            throw new IllegalArgumentException(msg, ex);
        }
        logger.debug(msg, ex);
    }

    private final String validateAndExtractRootName(Method method) {
        if (!method.getName().startsWith("get")) {
            throw new IllegalArgumentException("the name of the method has to start with \"get\" but was " + method.getName() + "().");
        }
        if (!this.isValidGetter(method)) {
            throw new IllegalArgumentException("Invalid getter method specified \"" + method.getName() + "\", maybe this method takes arguments or returns void?");
        }
        return method.getName().substring(3);
    }
}

