/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.presentation.property.values;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cytoscape.view.presentation.property.values.Justification;
import org.cytoscape.view.presentation.property.values.Position;

public final class ObjectPosition {
    private static final Pattern p = Pattern.compile("^([NSEWC]{1,2}+),([NSEWC]{1,2}+),([clr]{1}+),(-?\\d+(.\\d+)?),(-?\\d+(.\\d+)?)$");
    public static ObjectPosition DEFAULT_POSITION = new ObjectPosition();
    private Position objectAnchor;
    private Position targetAnchor;
    private Justification justify;
    private double xOffset;
    private double yOffset;

    public ObjectPosition() {
        this(Position.CENTER, Position.CENTER, Justification.JUSTIFY_CENTER, 0.0, 0.0);
    }

    public ObjectPosition(ObjectPosition p) {
        this.targetAnchor = p.getTargetAnchor();
        this.objectAnchor = p.getAnchor();
        this.xOffset = p.getOffsetX();
        this.yOffset = p.getOffsetY();
        this.justify = p.getJustify();
    }

    public ObjectPosition(Position targ, Position lab, Justification just, double x, double y) {
        this.targetAnchor = targ;
        this.objectAnchor = lab;
        this.justify = just;
        this.xOffset = x;
        this.yOffset = y;
    }

    public Position getAnchor() {
        return this.objectAnchor;
    }

    public Position getTargetAnchor() {
        return this.targetAnchor;
    }

    public Justification getJustify() {
        return this.justify;
    }

    public double getOffsetX() {
        return this.xOffset;
    }

    public double getOffsetY() {
        return this.yOffset;
    }

    public void setAnchor(Position p) {
        this.objectAnchor = p;
    }

    public void setTargetAnchor(Position p) {
        this.targetAnchor = p;
    }

    public void setJustify(Justification j) {
        this.justify = j;
    }

    public void setOffsetX(double d) {
        this.xOffset = d;
    }

    public void setOffsetY(double d) {
        this.yOffset = d;
    }

    public boolean equals(Object lp) {
        if (lp == null || !(lp instanceof ObjectPosition)) {
            return false;
        }
        ObjectPosition p = (ObjectPosition)lp;
        if (Math.abs(p.getOffsetX() - this.xOffset) > 1.0E-7) {
            return false;
        }
        if (Math.abs(p.getOffsetY() - this.yOffset) > 1.0E-7) {
            return false;
        }
        if (p.getAnchor() != this.objectAnchor) {
            return false;
        }
        if (p.getTargetAnchor() != this.targetAnchor) {
            return false;
        }
        return p.getJustify() == this.justify;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("target: ").append(this.targetAnchor.getName());
        sb.append("  object: ").append(this.objectAnchor.getName());
        sb.append("  justify: ").append(this.justify.getName());
        sb.append("  X offset: ").append(Double.toString(this.xOffset));
        sb.append("  Y offset: ").append(Double.toString(this.yOffset));
        return sb.toString();
    }

    private String shortString() {
        DecimalFormat df = new DecimalFormat("#0.00;-#0.00", new DecimalFormatSymbols(Locale.US));
        StringBuilder sb = new StringBuilder();
        sb.append(this.targetAnchor.getShortName());
        sb.append(",");
        sb.append(this.objectAnchor.getShortName());
        sb.append(",");
        sb.append(this.justify.getShortName());
        sb.append(",");
        sb.append(df.format(this.xOffset));
        sb.append(",");
        sb.append(df.format(this.yOffset));
        return sb.toString();
    }

    public String toSerializableString() {
        return this.shortString();
    }

    public static ObjectPosition parse(String serializableString) {
        Matcher m = p.matcher(serializableString);
        if (m.matches()) {
            ObjectPosition lp = new ObjectPosition();
            lp.setTargetAnchor(Position.parse(m.group(1)));
            lp.setAnchor(Position.parse(m.group(2)));
            lp.setJustify(Justification.parse(m.group(3)));
            lp.setOffsetX(Double.valueOf(m.group(4)));
            lp.setOffsetY(Double.valueOf(m.group(6)));
            return lp;
        }
        return DEFAULT_POSITION;
    }
}

