/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.presentation.property.table;

import java.awt.Font;
import java.awt.Paint;
import javax.swing.UIManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.AbstractVisualProperty;
import org.cytoscape.view.model.ContinuousRange;
import org.cytoscape.view.model.NullDataType;
import org.cytoscape.view.model.Range;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.Visualizable;
import org.cytoscape.view.presentation.property.AbstractVisualLexicon;
import org.cytoscape.view.presentation.property.BooleanVisualProperty;
import org.cytoscape.view.presentation.property.DefaultVisualizableVisualProperty;
import org.cytoscape.view.presentation.property.DoubleVisualProperty;
import org.cytoscape.view.presentation.property.FontVisualProperty;
import org.cytoscape.view.presentation.property.IntegerVisualProperty;
import org.cytoscape.view.presentation.property.PaintVisualProperty;
import org.cytoscape.view.presentation.property.StringVisualProperty;
import org.cytoscape.view.presentation.property.table.CellFormat;
import org.cytoscape.view.presentation.property.table.CellFormatVisualProperty;
import org.cytoscape.view.presentation.property.table.TableMode;
import org.cytoscape.view.presentation.property.table.TableModeVisualProperty;

public class BasicTableVisualLexicon
extends AbstractVisualLexicon {
    private static final Font DEF_FONT = new Font("SansSerif", 0, (int)LookAndFeelUtil.getSmallFontSize());
    private static final int DEF_FONT_SIZE = (int)LookAndFeelUtil.getSmallFontSize();
    private static final Range<Integer> ROW_HEIGHT_RANGE = new ContinuousRange<Integer>(Integer.class, 1, 800, true, true);
    private static final Range<Integer> NONE_ZERO_POSITIVE_INT_RANGE = new ContinuousRange<Integer>(Integer.class, 1, Integer.MAX_VALUE, true, true);
    public static final VisualProperty<Visualizable> TABLE = new DefaultVisualizableVisualProperty("Table", "Table Visual Property", CyTable.class);
    public static final VisualProperty<Visualizable> ROW = new DefaultVisualizableVisualProperty("Row", "Row Visual Property", CyRow.class);
    public static final VisualProperty<Visualizable> COLUMN = new DefaultVisualizableVisualProperty("Column", "Column Visual Property", CyColumn.class);
    public static final VisualProperty<Visualizable> CELL = new DefaultVisualizableVisualProperty("Cell", "Cell Visual Property", CyColumn.class);
    public static final VisualProperty<TableMode> TABLE_VIEW_MODE = new TableModeVisualProperty(TableModeVisualProperty.AUTO, "TABLE_VIEW_MODE", "View Mode", CyTable.class);
    public static final VisualProperty<Boolean> TABLE_ALTERNATE_ROW_COLORS = new BooleanVisualProperty(false, "TABLE_ALTERNATE_ROW_COLORS", "Alternate Row Colors", CyTable.class);
    public static final VisualProperty<Boolean> TABLE_GRID_VISIBLE = new BooleanVisualProperty(false, "TABLE_GRID_VISIBLE", "Table Grid Visible", CyTable.class);
    public static final VisualProperty<Integer> TABLE_ROW_HEIGHT = new RowHeightVisualProperty(ROW_HEIGHT_RANGE, "TABLE_ROW_HEIGHT", "Table Row Height", CyTable.class);
    public static final VisualProperty<Integer> ROW_HEIGHT = new RowHeightVisualProperty(ROW_HEIGHT_RANGE, "ROW_HEIGHT", "Row Height", CyRow.class);
    public static final VisualProperty<Boolean> ROW_SELECTED = new BooleanVisualProperty(false, "ROW_SELECTED", "Row Selected", CyRow.class);
    public static final VisualProperty<Boolean> COLUMN_EDITABLE = new BooleanVisualProperty(true, "COLUMN_EDITABLE", "Column Editable", CyColumn.class);
    public static final VisualProperty<Boolean> COLUMN_VISIBLE = new BooleanVisualProperty(true, "COLUMN_VISIBLE", "Column Visible", CyColumn.class);
    public static final VisualProperty<Boolean> COLUMN_SELECTED = new BooleanVisualProperty(false, "COLUMN_SELECTED", "Column Selected", CyColumn.class);
    public static final VisualProperty<Double> COLUMN_GRAVITY = new DoubleVisualProperty(1.0, NONE_ZERO_POSITIVE_DOUBLE_RANGE, "COLUMN_GRAVITY", "Column Gravity", CyColumn.class);
    public static final VisualProperty<Integer> COLUMN_WIDTH = new IntegerVisualProperty(1, NONE_ZERO_POSITIVE_INT_RANGE, "COLUMN_WIDTH", "Column Width", CyColumn.class);
    public static final VisualProperty<CellFormat> COLUMN_FORMAT = new CellFormatVisualProperty(new CellFormat(""), "COLUMN_FORMAT", "Cell Number Format", CyColumn.class);
    public static final VisualProperty<Boolean> COLUMN_TEXT_WRAPPED = new BooleanVisualProperty(false, "COLUMN_TEXT_WRAPPED", "Cell Text Wrapped", CyColumn.class);
    public static final VisualProperty<Paint> CELL_BACKGROUND_PAINT = new PaintVisualProperty(UIManager.getColor("Table.background"), PAINT_RANGE, "CELL_BACKGROUND_PAINT", "Cell Background Paint", (Class<? extends CyIdentifiable>)CyColumn.class);
    public static final VisualProperty<Font> CELL_FONT_FACE = new FontVisualProperty(DEF_FONT, "CELL_FONT_FACE", "Cell Font Face", CyColumn.class);
    public static final VisualProperty<Integer> CELL_FONT_SIZE = new IntegerVisualProperty(DEF_FONT_SIZE, (Range<Integer>)new ContinuousRange<Integer>(Integer.class, 1, Integer.MAX_VALUE, true, true), "CELL_FONT_SIZE", "Cell Font Size", (Class<? extends CyIdentifiable>)CyColumn.class);
    public static final VisualProperty<Paint> CELL_TEXT_COLOR = new PaintVisualProperty(UIManager.getColor("Table.foreground"), PAINT_RANGE, "CELL_TEXT_COLOR", "Cell Text Paint", (Class<? extends CyIdentifiable>)CyColumn.class);
    public static final VisualProperty<String> CELL_TOOLTIP = new StringVisualProperty("", ARBITRARY_STRING_RANGE, "CELL_TOOLTIP", "Cell Tooltip", CyColumn.class);

    public BasicTableVisualLexicon(VisualProperty<NullDataType> root) {
        super(root);
    }

    @Override
    protected Class<?>[] getTypes() {
        return new Class[]{CyTable.class, CyRow.class, CyColumn.class};
    }

    @Override
    protected void addVisualProperties(VisualProperty<NullDataType> root) {
        this.addVisualProperty(TABLE, root);
        this.addVisualProperty(ROW, TABLE);
        this.addVisualProperty(COLUMN, TABLE);
        this.addVisualProperty(CELL, TABLE);
        this.addVisualProperty(TABLE_VIEW_MODE, TABLE);
        this.addVisualProperty(TABLE_ALTERNATE_ROW_COLORS, TABLE);
        this.addVisualProperty(TABLE_GRID_VISIBLE, TABLE);
        this.addVisualProperty(TABLE_ROW_HEIGHT, TABLE);
        this.addVisualProperty(ROW_HEIGHT, ROW);
        this.addVisualProperty(ROW_SELECTED, ROW);
        this.addVisualProperty(COLUMN_EDITABLE, COLUMN);
        this.addVisualProperty(COLUMN_VISIBLE, COLUMN);
        this.addVisualProperty(COLUMN_SELECTED, COLUMN);
        this.addVisualProperty(COLUMN_GRAVITY, COLUMN);
        this.addVisualProperty(COLUMN_WIDTH, COLUMN);
        this.addVisualProperty(COLUMN_FORMAT, COLUMN);
        this.addVisualProperty(COLUMN_TEXT_WRAPPED, COLUMN);
        this.addVisualProperty(CELL_BACKGROUND_PAINT, CELL);
        this.addVisualProperty(CELL_FONT_FACE, CELL);
        this.addVisualProperty(CELL_FONT_SIZE, CELL);
        this.addVisualProperty(CELL_TEXT_COLOR, CELL);
        this.addVisualProperty(CELL_TOOLTIP, CELL);
    }

    private static final class RowHeightVisualProperty
    extends AbstractVisualProperty<Integer> {
        public RowHeightVisualProperty(Range<Integer> range, String id, String displayName, Class<? extends CyIdentifiable> targetObjectDataType) {
            super(0, range, id, displayName, targetObjectDataType);
        }

        @Override
        public Integer getDefault() {
            return UIManager.getInt("Table.rowHeight");
        }

        @Override
        public String toSerializableString(Integer value) {
            try {
                return value.toString();
            }
            catch (ClassCastException ex) {
                System.err.println("ClassCast: " + value);
                ex.printStackTrace();
                return "";
            }
        }

        @Override
        public Integer parseSerializableString(String text) {
            return Double.valueOf(text).intValue();
        }
    }
}

