/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.presentation.property;

import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.view.model.AbstractVisualProperty;
import org.cytoscape.view.model.ContinuousRange;
import org.cytoscape.view.model.Range;
import org.cytoscape.view.presentation.property.values.ObjectPosition;

public final class ObjectPositionVisualProperty
extends AbstractVisualProperty<ObjectPosition> {
    private static final Range<ObjectPosition> OBJECT_POSITION_RANGE;
    private static final ObjectPosition MIN_OBJECT;

    public ObjectPositionVisualProperty(ObjectPosition defaultValue, String id, String displayName, Class<? extends CyIdentifiable> targetObjectDataType) {
        super(defaultValue, OBJECT_POSITION_RANGE, id, displayName, targetObjectDataType);
    }

    @Override
    public String toSerializableString(ObjectPosition value) {
        return value.toSerializableString();
    }

    @Override
    public ObjectPosition parseSerializableString(String objectPositionString) {
        return ObjectPosition.parse(objectPositionString);
    }

    static {
        MIN_OBJECT = ObjectPosition.DEFAULT_POSITION;
        OBJECT_POSITION_RANGE = new ContinuousRange<ObjectPosition>(ObjectPosition.class, MIN_OBJECT, MIN_OBJECT, true, true);
    }
}

