/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.presentation.property;

import java.awt.Color;
import java.awt.Paint;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cytoscape.view.model.ContinuousRange;
import org.cytoscape.view.model.DiscreteRange;
import org.cytoscape.view.model.NullDataType;
import org.cytoscape.view.model.Range;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualLexiconNode;
import org.cytoscape.view.model.VisualProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVisualLexicon
implements VisualLexicon {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final Map<Class<?>, Map<String, VisualProperty<?>>> identifierLookup;
    private final Map<VisualProperty<?>, VisualLexiconNode> visualPropertyMap = new HashMap();
    protected final VisualProperty<NullDataType> rootVisualProperty;
    protected static final Color MIN_COLOR = new Color(0, 0, 0);
    protected static final Color MAX_COLOR = new Color(255, 255, 255);
    protected static final Range<Paint> PAINT_RANGE = new ContinuousRange<Color>(Paint.class, MIN_COLOR, MAX_COLOR, true, true);
    protected static final Set<String> STRING_SET = new HashSet<String>();
    protected static final Range<String> ARBITRARY_STRING_RANGE = new DiscreteRange<String>(String.class, STRING_SET){

        @Override
        public boolean inRange(String value) {
            return true;
        }
    };
    protected static final Range<Double> ARBITRARY_DOUBLE_RANGE = new ContinuousRange<Double>(Double.class, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, true, true);
    protected static final Range<Double> NONE_ZERO_POSITIVE_DOUBLE_RANGE = new ContinuousRange<Double>(Double.class, 0.0, Double.POSITIVE_INFINITY, false, true);
    protected static final Range<Double> ANGLE_DOUBLE_RANGE = new ContinuousRange<Double>(Double.class, -360.0, 360.0, false, true);

    public AbstractVisualLexicon(VisualProperty<NullDataType> rootVisualProperty) {
        this.rootVisualProperty = rootVisualProperty;
        VisualLexiconNode rootNode = new VisualLexiconNode(rootVisualProperty, null);
        this.visualPropertyMap.put(rootVisualProperty, rootNode);
        this.identifierLookup = new HashMap();
        for (Class<?> cls : this.getTypes()) {
            this.identifierLookup.put(cls, new HashMap());
        }
        this.addVisualProperties(rootVisualProperty);
    }

    protected abstract Class<?>[] getTypes();

    protected abstract void addVisualProperties(VisualProperty<NullDataType> var1);

    @Override
    public final Set<VisualProperty<?>> getAllVisualProperties() {
        return new HashSet(this.visualPropertyMap.keySet());
    }

    @Override
    public final Collection<VisualProperty<?>> getAllDescendants(VisualProperty<?> prop) {
        if (prop == null) {
            throw new NullPointerException("Target visual property cannot be null.");
        }
        if (!this.visualPropertyMap.containsKey(prop)) {
            throw new IllegalArgumentException("No such Visual Property in the Lexicon: " + prop.getDisplayName());
        }
        return this.getChildNodes(prop);
    }

    @Override
    public final VisualProperty<NullDataType> getRootVisualProperty() {
        return this.rootVisualProperty;
    }

    private Set<VisualProperty<?>> getChildNodes(VisualProperty<?> prop) {
        VisualLexiconNode node = this.visualPropertyMap.get(prop);
        HashSet children = new HashSet();
        if (node.getChildren().size() == 0) {
            return children;
        }
        Collection<VisualLexiconNode> currentChildren = node.getChildren();
        for (VisualLexiconNode nd : currentChildren) {
            children.add(nd.getVisualProperty());
        }
        for (VisualLexiconNode nd : currentChildren) {
            children.addAll(this.getChildNodes(nd.getVisualProperty()));
        }
        return children;
    }

    protected final void addVisualProperty(VisualProperty<?> vp, VisualProperty<?> parent) {
        if (this.visualPropertyMap.containsKey(vp)) {
            throw new IllegalStateException("The key " + vp.getIdString() + " already exists in the lexicon.");
        }
        if (parent == null) {
            throw new NullPointerException("Parent cannot be null.");
        }
        VisualLexiconNode parentNode = this.visualPropertyMap.get(parent);
        if (parentNode == null) {
            throw new IllegalArgumentException("Parent does not exist in the lexicon: " + parent.getDisplayName());
        }
        VisualLexiconNode newNode = new VisualLexiconNode(vp, parentNode);
        this.visualPropertyMap.put(vp, newNode);
        this.addIdentifierMapping(vp.getTargetDataType(), vp.getIdString(), vp);
    }

    @Override
    public final VisualLexiconNode getVisualLexiconNode(VisualProperty<?> vp) {
        return this.visualPropertyMap.get(vp);
    }

    @Override
    public final VisualProperty<?> lookup(Class<?> type, String id) {
        if (id == null || type == null) {
            return null;
        }
        Map<String, VisualProperty<?>> map = this.identifierLookup.get(type);
        if (map == null) {
            return null;
        }
        return map.get(id.toLowerCase());
    }

    @Override
    public boolean isSupported(VisualProperty<?> vp) {
        return this.visualPropertyMap.containsKey(vp);
    }

    @Override
    public <T> Set<T> getSupportedValueRange(VisualProperty<T> vp) {
        Range<T> range = vp.getRange();
        if (range.isDiscrete()) {
            return ((DiscreteRange)range).values();
        }
        return Collections.emptySet();
    }

    protected final void addIdentifierMapping(Class<?> type, String id, VisualProperty<?> vp) {
        if (type == null) {
            logger.warn("attempting to add VisualLexicon identifier lookup mapping with null type");
            return;
        }
        if (id == null) {
            logger.warn("attempting to add VisualLexicon identifier lookup mapping with null id");
            return;
        }
        if (vp == null) {
            logger.warn("attempting to add VisualLexicon identifier lookup mapping with null visual property");
            return;
        }
        Map<String, VisualProperty<?>> map = this.identifierLookup.get(type);
        if (map == null) {
            logger.warn("attempting to add VisualLexicon identifier lookup mapping with unrecognized type: " + type.getClass().getName() + "(expect: " + this.identifierLookup.keySet().toString() + ")");
            return;
        }
        map.put(id.toLowerCase(), vp);
    }
}

