/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.model;

import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.view.model.Range;
import org.cytoscape.view.model.VisualProperty;

public abstract class AbstractVisualProperty<T>
implements VisualProperty<T> {
    private final T defaultValue;
    private final Range<T> range;
    private final String id;
    private final String name;
    protected boolean shouldIgnoreDefault;
    private final Class<? extends CyIdentifiable> targetObjectDataType;

    public AbstractVisualProperty(T defaultValue, Range<T> range, String id, String displayName, Class<? extends CyIdentifiable> targetObjectDataType) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue should not be null.");
        }
        if (id == null) {
            throw new NullPointerException("id should not be null.");
        }
        if (displayName == null) {
            throw new NullPointerException("displayName should not be null.");
        }
        this.range = range;
        this.defaultValue = defaultValue;
        this.id = id;
        this.name = displayName;
        this.shouldIgnoreDefault = false;
        this.targetObjectDataType = targetObjectDataType;
    }

    @Override
    public Range<T> getRange() {
        return this.range;
    }

    @Override
    public T getDefault() {
        return this.defaultValue;
    }

    @Override
    public String getIdString() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public boolean shouldIgnoreDefault() {
        return this.shouldIgnoreDefault;
    }

    @Override
    public Class<? extends CyIdentifiable> getTargetDataType() {
        return this.targetObjectDataType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + this.id + ", defaultValue=" + this.defaultValue + "]";
    }
}

