/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.layout;

import org.cytoscape.model.CyRow;
import org.cytoscape.view.layout.LayoutEdge;
import org.cytoscape.view.layout.WeightTypes;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListSingleSelection;

public final class EdgeWeighter {
    public WeightTypes type = WeightTypes.GUESS;
    @Tunable(description="The minimum edge weight to consider:", groups={"Edge Weight Settings"}, context="both", longDescription="The minimum edge weight to consider, numeric values, default is 0", exampleStringValue="0")
    public double minWeightCutoff = 0.0;
    @Tunable(description="The maximum edge weight to consider:", groups={"Edge Weight Settings"}, context="both", longDescription="The maximum edge weight to consider, default to the Double.MAX value", exampleStringValue="1000")
    public double maxWeightCutoff = Double.MAX_VALUE;
    @Tunable(description="The default edge weight to consider:", groups={"Edge Weight Settings"}, context="both", longDescription="The default edge weight to consider, default is 0.5 ", exampleStringValue="0.5")
    public double defaultEdgeWeight = 0.5;
    private String weightAttribute = "";
    private static final double LOWER_BOUND = (double)0.1f;
    private static final double UPPER_BOUND = (double)0.9f;
    private double lowerBounds = 0.1f;
    private double upperBounds = 0.9f;
    private double maxWeight = -1000000.0;
    private double minWeight = 1000000.0;
    private double maxLogWeight = -1000000.0;
    private double minLogWeight = 1000000.0;
    private double logWeightCeiling = 1028.0;
    private boolean logOverflow = false;
    private double normalFactor = Double.MAX_VALUE;

    @Tunable(description="How to interpret weight values:", groups={"Edge Weight Settings"}, gravity=2.0, context="both", longDescription="How to interpret weight values; must be one of ```Heuristic```, ```-Log(value)```, ```1 - normalized value``` and ```normalized value```. Defaults to ```Heuristic```", exampleStringValue="Heuristic")
    public ListSingleSelection<WeightTypes> getType() {
        ListSingleSelection<WeightTypes> t = new ListSingleSelection<WeightTypes>(WeightTypes.GUESS, WeightTypes.LOG, WeightTypes.DISTANCE, WeightTypes.WEIGHT);
        t.setSelectedValue(this.type);
        return t;
    }

    public void setType(ListSingleSelection<WeightTypes> t) {
        this.type = t.getSelectedValue();
    }

    public void setWeightAttribute(String weightAttribute) {
        this.weightAttribute = weightAttribute;
    }

    public void reset() {
        this.maxWeight = -1000000.0;
        this.minWeight = 1000000.0;
        this.maxLogWeight = -1000000.0;
        this.minLogWeight = 1000000.0;
        this.normalFactor = Double.MAX_VALUE;
        this.logOverflow = false;
    }

    public void setWeightType(WeightTypes type) {
        this.type = type;
    }

    public void setNormalizedBounds(double lowerBound, double upperBound) {
        this.lowerBounds = lowerBound;
        this.upperBounds = upperBound;
    }

    public void setWeight(LayoutEdge layoutEdge) {
        CyRow row = layoutEdge.getRow();
        double eValue = this.defaultEdgeWeight;
        if (this.weightAttribute != null && row.isSet(this.weightAttribute)) {
            Double val;
            Class<?> type = row.getTable().getColumn(this.weightAttribute).getType();
            if (type == Integer.class) {
                Integer val2 = row.get(this.weightAttribute, Integer.class);
                eValue = val2.intValue();
            } else if (type == Long.class) {
                Long val3 = row.get(this.weightAttribute, Long.class);
                eValue = val3.longValue();
            } else if (type == Double.class && !(val = row.get(this.weightAttribute, Double.class)).isNaN()) {
                eValue = val;
            }
        }
        layoutEdge.setWeight(eValue);
        this.minWeight = Math.min(this.minWeight, eValue);
        this.maxWeight = Math.max(this.maxWeight, eValue);
        if (this.type == WeightTypes.GUESS || this.type == WeightTypes.LOG) {
            double logWeight;
            if (eValue == 0.0) {
                logWeight = this.logWeightCeiling;
                this.logOverflow = true;
            } else {
                logWeight = Math.min(-Math.log10(eValue), this.logWeightCeiling);
            }
            this.minLogWeight = Math.min(this.minLogWeight, logWeight);
            this.maxLogWeight = Math.max(this.maxLogWeight, logWeight);
            layoutEdge.setLogWeight(logWeight);
        }
    }

    public boolean normalizeWeight(LayoutEdge edge) {
        if (this.minWeight == this.maxWeight) {
            return true;
        }
        if (this.logOverflow) {
            this.maxLogWeight += 5.0;
            this.logOverflow = false;
        }
        if (edge.getWeight() <= this.minWeightCutoff || edge.getWeight() > this.maxWeightCutoff) {
            return false;
        }
        double weight = 0.0;
        switch (this.type) {
            case GUESS: {
                if (Math.abs(this.maxLogWeight - this.minLogWeight) > 3.0) {
                    weight = edge.getLogWeight();
                    if (weight == this.logWeightCeiling) {
                        weight = this.maxLogWeight;
                    }
                    weight = this.logNormalize(weight);
                    break;
                }
                weight = this.normalize(edge.getWeight());
                break;
            }
            case LOG: {
                weight = edge.getLogWeight();
                if (weight == this.logWeightCeiling) {
                    weight = this.maxLogWeight;
                }
                weight = this.logNormalize(weight);
                break;
            }
            case DISTANCE: {
                weight = edge.getWeight();
                weight = this.lowerBounds + this.upperBounds - this.normalize(weight);
                break;
            }
            case WEIGHT: {
                weight = this.normalize(edge.getWeight());
            }
        }
        edge.setWeight(weight);
        return true;
    }

    private double logNormalize(double weight) {
        if (this.normalFactor == Double.MAX_VALUE) {
            this.normalFactor = (this.upperBounds - this.lowerBounds) / (this.maxLogWeight - this.minLogWeight);
        }
        return (weight - this.minLogWeight) * this.normalFactor + this.lowerBounds;
    }

    private double normalize(double weight) {
        if (this.normalFactor == Double.MAX_VALUE) {
            this.normalFactor = (this.upperBounds - this.lowerBounds) / (this.maxWeight - this.minWeight);
        }
        return (weight - this.minWeight) * this.normalFactor + this.lowerBounds;
    }

    public void setMaxWeightCutoff(double maxWeight) {
        this.maxWeightCutoff = maxWeight;
    }

    public void setMinWeightCutoff(double minWeight) {
        this.minWeightCutoff = minWeight;
    }
}

