/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.layout;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.layout.AbstractLayoutTask;
import org.cytoscape.view.layout.EdgeWeighter;
import org.cytoscape.view.layout.LayoutPartition;
import org.cytoscape.view.layout.PartitionUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.UndoSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPartitionLayoutTask
extends AbstractLayoutTask {
    protected static Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    protected TaskMonitor taskMonitor;
    protected double incr = 100.0;
    protected List<LayoutPartition> partitionList = null;
    protected EdgeWeighter edgeWeighter;
    private final boolean singlePartition;
    protected double current_start = 0.0;
    protected double current_size = 0.0;
    protected double total_nodes = 0.0;

    public AbstractPartitionLayoutTask(String displayName, boolean singlePartition, CyNetworkView networkView, Set<View<CyNode>> nodesToLayOut, String layoutAttribute, UndoSupport undo) {
        super(displayName, networkView, nodesToLayOut, layoutAttribute, undo);
        this.singlePartition = singlePartition;
    }

    public abstract void layoutPartition(LayoutPartition var1);

    protected void setTaskStatus(int percent) {
        if (this.taskMonitor != null) {
            if (percent < 0 || percent > 100) {
                logger.warn("invalid percent value set for layout status (must be between 0 and 100): " + percent);
                return;
            }
            double nodesDone = this.current_size * (double)percent / 100.0;
            double pDone = (nodesDone + this.current_start) / this.total_nodes;
            this.taskMonitor.setProgress(pDone);
        }
    }

    @Override
    public void doLayout(TaskMonitor taskMonitor) {
        boolean useAllNodes;
        CyNetwork network = (CyNetwork)this.networkView.getModel();
        if (this.edgeWeighter != null) {
            this.edgeWeighter.reset();
        }
        this.taskMonitor = taskMonitor;
        long visibleNodeCount = this.networkView.getNodeViews().stream().filter(view -> view.getVisualProperty(BasicVisualLexicon.NODE_VISIBLE)).count();
        boolean bl = useAllNodes = (long)this.nodesToLayOut.size() == visibleNodeCount;
        if (this.singlePartition || !useAllNodes) {
            LayoutPartition partition = new LayoutPartition(this.networkView, this.nodesToLayOut, this.edgeWeighter);
            this.partitionList = new ArrayList<LayoutPartition>(1);
            this.partitionList.add(partition);
        } else {
            Set<CyNode> nodes = this.nodesToLayOut.stream().map(nv -> (CyNode)nv.getModel()).collect(Collectors.toSet());
            this.partitionList = PartitionUtil.partition(this.networkView, nodes, this.edgeWeighter);
        }
        this.total_nodes = network.getNodeCount();
        double screen_scale = this.networkView.getVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR);
        double screen_width = this.networkView.getVisualProperty(BasicVisualLexicon.NETWORK_WIDTH) / screen_scale;
        double screen_height = this.networkView.getVisualProperty(BasicVisualLexicon.NETWORK_HEIGHT) / screen_scale;
        double min_x = Double.MAX_VALUE;
        double max_x = Double.MIN_VALUE;
        double min_y = Double.MAX_VALUE;
        double max_y = Double.MIN_VALUE;
        for (LayoutPartition partition : this.partitionList) {
            min_x = Math.min(min_x, partition.getMinX());
            max_x = Math.max(max_x, partition.getMaxX());
            min_y = Math.min(min_y, partition.getMinY());
            max_y = Math.max(max_y, partition.getMaxY());
        }
        for (LayoutPartition partition : this.partitionList) {
            if (this.cancelled) break;
            this.current_size = partition.size();
            this.setTaskStatus(1);
            if (partition.nodeCount() > 1) {
                try {
                    partition.dontMove(true);
                    this.layoutPartition(partition);
                    partition.dontMove(false);
                }
                catch (Throwable _e) {
                    _e.printStackTrace();
                    partition.dontMove(false);
                    return;
                }
            }
            this.setTaskStatus(100);
            this.current_start += this.current_size;
        }
        double width = max_x - min_x;
        double height = max_y - min_y;
        double max_dimension = this.calculate_max_dimension(width, height, screen_width, screen_height, this.partitionList);
        double start_x = 0.0;
        double next_y_start = 0.0;
        double next_x_start = start_x;
        double y_max = 0.0;
        for (LayoutPartition partition : this.partitionList) {
            if (this.cancelled) break;
            partition.offset(next_x_start, next_y_start);
            next_x_start = partition.getMaxX() + this.incr;
            y_max = Math.max(y_max, partition.getMaxY());
            if (!(next_x_start > max_dimension)) continue;
            next_x_start = start_x;
            next_y_start = y_max + this.incr;
        }
    }

    protected double calculate_max_dimension(double width, double height, double screen_width, double screen_height, List<LayoutPartition> partitionList) {
        double max_dimension = Math.max(width, screen_width);
        double wh_ratio = screen_width / screen_height;
        int max_attempts = 10;
        for (int attempt = 0; attempt < max_attempts; ++attempt) {
            double next_y_start = 0.0;
            double next_x_start = 0.0;
            double y_max = 0.0;
            for (LayoutPartition partition : partitionList) {
                next_x_start += partition.getWidth() + this.incr;
                y_max = Math.max(y_max, partition.getHeight());
                if (!(next_x_start > max_dimension)) continue;
                next_x_start = 0.0;
                next_y_start += y_max + this.incr;
                y_max = 0.0;
            }
            double layout_ratio = max_dimension / (next_y_start + y_max);
            double ratio = wh_ratio / layout_ratio;
            max_dimension *= ratio;
        }
        return max_dimension;
    }
}

