/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.plaf.basic.BasicToolTipUI;

class TextWrapToolTipUI
extends BasicToolTipUI {
    private static TextWrapToolTipUI instance;
    private CellRendererPane rendererPane;
    private JTextPane textPane;

    private TextWrapToolTipUI() {
    }

    public static synchronized TextWrapToolTipUI getInstance() {
        if (instance == null) {
            instance = new TextWrapToolTipUI();
        }
        return instance;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.rendererPane = new CellRendererPane();
        c.add(this.rendererPane);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.remove(this.rendererPane);
        this.rendererPane = null;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Dimension size = c.getSize();
        this.textPane.setBackground(c.getBackground());
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.rendererPane.paintComponent(g2, this.textPane, c, 1, 1, size.width - 1, size.height - 1, true);
        g2.dispose();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            return new Dimension(0, 0);
        }
        this.textPane = new JTextPane();
        if (tipText.trim().startsWith("<html>")) {
            this.textPane.setContentType("text/html");
        }
        this.textPane.setText(tipText);
        if (c.getFont() != null) {
            this.textPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            this.textPane.setFont(c.getFont());
        }
        Dimension pref = super.getPreferredSize(c);
        Dimension max = c.getMaximumSize();
        int w = Math.min(max.width, pref.width);
        int h = Math.min(max.height, pref.height);
        JWindow win = new JWindow();
        win.getContentPane().add(this.textPane);
        win.setPreferredSize(new Dimension(w, h));
        win.setMaximumSize(new Dimension(w, max.height));
        win.pack();
        Dimension size = win.getSize();
        win.getContentPane().removeAll();
        this.textPane.setSize(size);
        Dimension dim = this.textPane.getPreferredSize();
        ++dim.height;
        ++dim.width;
        this.rendererPane.removeAll();
        this.rendererPane.add(this.textPane);
        return dim;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.textPane == null ? super.getMinimumSize(c) : this.textPane.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.textPane == null ? super.getMaximumSize(c) : this.textPane.getMaximumSize();
    }
}

