/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LookAndFeelUtil {
    private static String HELP_PREFIX = "https://manual.cytoscape.org/en/";
    private static String HELP_SUFFIX = ".html";
    private static final float AQUA_SMALL_FONT_SIZE;
    private static Font iconFont;
    private static final Logger logger;

    public static boolean isAquaLAF() {
        return UIManager.getLookAndFeel() != null && ("Mac".equals(UIManager.getLookAndFeel().getID()) || "Aqua".equals(UIManager.getLookAndFeel().getID()));
    }

    public static boolean isNimbusLAF() {
        return UIManager.getLookAndFeel() != null && "Nimbus".equals(UIManager.getLookAndFeel().getID());
    }

    public static boolean isWinLAF() {
        return UIManager.getLookAndFeel() != null && "Windows".equals(UIManager.getLookAndFeel().getID());
    }

    public static Color getInfoColor() {
        return UIManager.getColor("CyColor.complement(+2)");
    }

    public static Color getWarnColor() {
        return UIManager.getColor("CyColor.primary");
    }

    public static Color getErrorColor() {
        return UIManager.getColor("CyColor.secondary2(-1)");
    }

    public static Color getSuccessColor() {
        return UIManager.getColor("CyColor.secondary1(-1)");
    }

    public static float getSmallFontSize() {
        if (LookAndFeelUtil.isAquaLAF()) {
            return AQUA_SMALL_FONT_SIZE;
        }
        Font font = UIManager.getFont("Label.font");
        float regular = font == null ? 13.0f : font.getSize2D();
        float small = Math.round(regular * 0.84f);
        small = Math.max(11.0f, small);
        small = Math.min(regular, small);
        return small;
    }

    public static Border createPanelBorder() {
        Border border;
        Border border2 = border = LookAndFeelUtil.isAquaLAF() ? UIManager.getBorder("InsetBorder.aquaVariant") : null;
        if (border == null) {
            border = LookAndFeelUtil.isWinLAF() ? new TitledBorder("") : BorderFactory.createTitledBorder("SAMPLE").getBorder();
        }
        if (border == null) {
            border = BorderFactory.createLineBorder(UIManager.getColor("Separator.foreground"));
        }
        return border;
    }

    public static Border createTitledBorder(String title) {
        Border border;
        if (title == null || title.trim().isEmpty()) {
            Border aquaBorder = LookAndFeelUtil.isAquaLAF() ? UIManager.getBorder("InsetBorder.aquaVariant") : null;
            border = aquaBorder != null ? aquaBorder : BorderFactory.createTitledBorder("SAMPLE").getBorder();
        } else {
            TitledBorder tb;
            Border aquaBorder = LookAndFeelUtil.isAquaLAF() ? UIManager.getBorder("TitledBorder.aquaVariant") : null;
            TitledBorder titledBorder = tb = aquaBorder != null ? BorderFactory.createTitledBorder(aquaBorder, title) : BorderFactory.createTitledBorder(title);
            if (LookAndFeelUtil.isAquaLAF()) {
                tb.setTitleFont(UIManager.getFont("Label.font").deriveFont(LookAndFeelUtil.getSmallFontSize()));
            }
            border = tb;
        }
        return border;
    }

    public static JPanel createOkCancelPanel(JButton okBtn, JButton cancelBtn) {
        return LookAndFeelUtil.createOkCancelPanel(okBtn, cancelBtn, new JComponent[0]);
    }

    public static JPanel createOkCancelPanel(JButton okBtn, JButton cancelBtn, String helpStr) {
        return LookAndFeelUtil.createOkCancelPanel(okBtn, cancelBtn, helpStr, new JComponent[0]);
    }

    public static JPanel createOkCancelPanel(JButton okBtn, JButton cancelBtn, JComponent ... otherComponents) {
        return LookAndFeelUtil.createOkCancelPanel(okBtn, cancelBtn, null, otherComponents);
    }

    public static JPanel createOkCancelPanel(JButton okBtn, JButton cancelBtn, String helpStr, JComponent ... otherComponents) {
        JButton btn2;
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(true);
        GroupLayout.SequentialGroup hg = layout.createSequentialGroup();
        GroupLayout.ParallelGroup vg = layout.createParallelGroup(GroupLayout.Alignment.CENTER, false);
        if (helpStr != null && !helpStr.trim().isEmpty()) {
            JButton helpButton = LookAndFeelUtil.createHelpButton(helpStr);
            hg.addComponent(helpButton);
            vg.addComponent(helpButton);
        }
        if (otherComponents != null) {
            for (int i = 0; i < otherComponents.length; ++i) {
                JComponent c = otherComponents[i];
                hg.addComponent(c);
                vg.addComponent(c);
            }
        }
        hg.addGap(0, 0, Short.MAX_VALUE);
        JButton btn1 = LookAndFeelUtil.isMac() ? cancelBtn : okBtn;
        JButton jButton = btn2 = LookAndFeelUtil.isMac() ? okBtn : cancelBtn;
        if (btn1 != null) {
            hg.addComponent(btn1);
            vg.addComponent(btn1);
        }
        if (btn2 != null) {
            hg.addComponent(btn2);
            vg.addComponent(btn2);
        }
        layout.setHorizontalGroup(hg);
        layout.setVerticalGroup(vg);
        if (okBtn != null && cancelBtn != null) {
            LookAndFeelUtil.equalizeSize(okBtn, cancelBtn);
        }
        return panel;
    }

    public static JButton createHelpButton(String helpStr) {
        JButton helpButton = new JButton();
        helpButton.setToolTipText("Help...");
        if (LookAndFeelUtil.isAquaLAF()) {
            helpButton.putClientProperty("JButton.buttonType", "help");
        } else {
            helpButton.setText("\uf059");
            helpButton.setFont(LookAndFeelUtil.getIconFont(22.0f));
            helpButton.setBorderPainted(false);
            helpButton.setContentAreaFilled(false);
            helpButton.setFocusPainted(false);
            helpButton.setBorder(BorderFactory.createEmptyBorder());
            helpButton.setMinimumSize(new Dimension(22, 22));
        }
        helpButton.addActionListener(evt -> LookAndFeelUtil.launch(helpStr));
        return helpButton;
    }

    public static void setDefaultOkCancelKeyStrokes(JRootPane rootPane, Action okAction, Action cancelAction) {
        InputMap inputMap = rootPane.getInputMap(2);
        if (okAction != null) {
            String OK_ACTION_KEY = "OK_ACTION_KEY";
            KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0, false);
            inputMap.put(enterKey, "OK_ACTION_KEY");
            rootPane.getActionMap().put("OK_ACTION_KEY", okAction);
        }
        if (cancelAction != null) {
            String CANCEL_ACTION_KEY = "CANCEL_ACTION_KEY";
            KeyStroke escapeKey = KeyStroke.getKeyStroke(27, 0, false);
            inputMap.put(escapeKey, "CANCEL_ACTION_KEY");
            rootPane.getActionMap().put("CANCEL_ACTION_KEY", cancelAction);
        }
    }

    public static void equalizeSize(JComponent ... components) {
        if (components == null || components.length == 0) {
            return;
        }
        Dimension prefSize = components[0].getPreferredSize();
        Dimension maxSize = components[0].getMaximumSize();
        for (JComponent c : components) {
            LookAndFeelUtil.ensureSize(prefSize, c.getPreferredSize());
            LookAndFeelUtil.ensureSize(maxSize, c.getMaximumSize());
        }
        for (JComponent c : components) {
            c.setPreferredSize(prefSize);
            c.setMaximumSize(maxSize);
        }
    }

    public static void makeSmall(JComponent ... components) {
        if (components == null || components.length == 0) {
            return;
        }
        for (JComponent c : components) {
            if (LookAndFeelUtil.isAquaLAF()) {
                c.putClientProperty("JComponent.sizeVariant", "small");
            } else if (c.getFont() != null) {
                c.setFont(c.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
            }
            if (c instanceof MenuElement) {
                LookAndFeelUtil.makeSmall((MenuElement)((Object)c));
                continue;
            }
            if (c instanceof JList) {
                LookAndFeelUtil.makeSmall((JList)c);
                continue;
            }
            if (c instanceof JSpinner || c instanceof JTable || c instanceof JTree) {
                if (c.getFont() != null) {
                    c.setFont(c.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
                }
                if (!(c instanceof JTable)) continue;
                LookAndFeelUtil.makeSmall((JTable)c);
                continue;
            }
            if (!(c instanceof JSlider)) continue;
            LookAndFeelUtil.makeSmall((JSlider)c);
        }
    }

    private static void makeSmall(MenuElement c) {
        MenuElement[] elements;
        if (c instanceof JMenuItem && ((JMenuItem)c).getFont() != null) {
            ((JMenuItem)c).setFont(((JMenuItem)c).getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
        }
        if ((elements = c.getSubElements()) != null) {
            for (MenuElement item : elements) {
                LookAndFeelUtil.makeSmall(item);
            }
        }
    }

    private static void makeSmall(JList<?> list) {
        if (!(list.getCellRenderer() instanceof DefaultListCellRenderer)) {
            return;
        }
        final ListCellRenderer<?> renderer = list.getCellRenderer();
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> l, Object v, int idx, boolean sel, boolean focus) {
                Component c = renderer != null ? renderer.getListCellRendererComponent(l, v, idx, sel, focus) : super.getListCellRendererComponent(l, v, idx, sel, focus);
                c.setFont(this.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
                return c;
            }
        });
    }

    private static void makeSmall(JSlider slider) {
        try {
            Dictionary labelTable = slider.getLabelTable();
            if (labelTable != null) {
                Font tickFont = slider.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize());
                Enumeration enumeration = labelTable.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    JLabel lbl = (JLabel)labelTable.get(k);
                    lbl.setFont(tickFont);
                    lbl.setSize(lbl.getPreferredSize());
                }
            }
        }
        catch (Exception e) {
            logger.error("Cannot make slider labels smaller", (Throwable)e);
        }
    }

    private static void makeSmall(JTable table) {
        Class[] colTypes;
        JTableHeader header = table.getTableHeader();
        if (header != null && header.getFont() != null) {
            header.setFont(header.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
        }
        Enumeration<TableColumn> columns = table.getColumnModel().getColumns();
        HashSet<TableCellEditor> editors = new HashSet<TableCellEditor>();
        while (columns.hasMoreElements()) {
            editors.add(columns.nextElement().getCellEditor());
        }
        for (Class type : colTypes = new Class[]{Object.class, String.class, Boolean.class, Number.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class}) {
            editors.add(table.getDefaultEditor(type));
        }
        editors.forEach(ce -> LookAndFeelUtil.makeSmall(ce));
    }

    private static void makeSmall(TableCellEditor cellEditor) {
        Component c;
        if (cellEditor instanceof DefaultCellEditor && (c = ((DefaultCellEditor)cellEditor).getComponent()) instanceof JComponent) {
            LookAndFeelUtil.makeSmall((JComponent)c);
        }
    }

    public static boolean isMac() {
        return System.getProperty("os.name").startsWith("Mac OS X");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    private static void ensureSize(Dimension currentSize, Dimension minSize) {
        if (currentSize.height < minSize.height) {
            currentSize.height = minSize.height;
        }
        if (currentSize.width < minSize.width) {
            currentSize.width = minSize.width;
        }
    }

    private static URI helpStrToURI(String helpStr) {
        try {
            return new URL(LookAndFeelUtil.helpStrToURL(helpStr)).toURI();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String helpStrToURL(String rawString) {
        if (rawString.startsWith("http")) {
            return rawString;
        }
        String major = System.getProperty("cytoscape.version.major");
        String minor = System.getProperty("cytoscape.version.minor");
        String fix = System.getProperty("cytoscape.version.fix");
        String version = major != null && minor != null && fix != null ? String.format("%s.%s.%s/", major, minor, fix) : "stable/";
        return HELP_PREFIX + version + rawString + HELP_SUFFIX;
    }

    private static void launch(String helpStr) {
        try {
            URI uri = LookAndFeelUtil.helpStrToURI(helpStr);
            if (uri != null) {
                Desktop.getDesktop().browse(uri);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Font getIconFont(float size) {
        return iconFont.deriveFont(size);
    }

    private LookAndFeelUtil() {
    }

    static {
        if (LookAndFeelUtil.isAquaLAF()) {
            JLabel lbl = new JLabel();
            lbl.putClientProperty("JComponent.sizeVariant", "small");
            AQUA_SMALL_FONT_SIZE = lbl.getFont().getSize2D();
        } else {
            AQUA_SMALL_FONT_SIZE = 11.0f;
        }
        try {
            iconFont = Font.createFont(0, LookAndFeelUtil.class.getResourceAsStream("/fonts/fontawesome-webfont.ttf"));
        }
        catch (FontFormatException e) {
            throw new RuntimeException();
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    }
}

