/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

public class DropDownMenuButton
extends JButton {
    private static final int TEXT_ARROW_GAP = 6;
    private final Icon buttonIcon = new MenuArrowIcon();
    private ActionListener popupMenuActionListener;

    public DropDownMenuButton(AbstractAction action) {
        this();
        this.setAction(action);
    }

    public DropDownMenuButton(JPopupMenu popupMenu) {
        this();
        this.setPopupMenu(popupMenu);
    }

    public DropDownMenuButton() {
        this.setFocusPainted(false);
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4 + this.buttonIcon.getIconWidth()));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension dim = this.getSize();
        Insets ins = this.getInsets();
        int x = dim.width - this.buttonIcon.getIconWidth() - ins.right;
        int y = ins.top + (dim.height - ins.top - ins.bottom - this.buttonIcon.getIconHeight()) / 2;
        this.buttonIcon.paintIcon(this, g, x, y);
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        if (this.popupMenuActionListener != null) {
            this.removeActionListener(this.popupMenuActionListener);
        }
        if (popupMenu != null) {
            this.popupMenuActionListener = e -> {
                popupMenu.show(this, 0, this.getHeight());
                popupMenu.requestFocusInWindow();
            };
            this.addActionListener(this.popupMenuActionListener);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width += this.buttonIcon.getIconWidth() + 6;
        return d;
    }

    private static final class MenuArrowIcon
    implements Icon {
        private MenuArrowIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(UIManager.getColor(c.isEnabled() ? "Button.foreground" : "Button.disabledForeground"));
            int w = this.getIconWidth();
            int h = this.getIconHeight();
            int pad = 2;
            g2.translate(x, y);
            g2.fillPolygon(new int[]{pad, w - pad, w / 2}, new int[]{pad + 1, pad + 1, h - pad}, 3);
            g2.dispose();
        }

        @Override
        public int getIconWidth() {
            return 10;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }
    }
}

