/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.session.events;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.event.AbstractCyEvent;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.session.events.SessionAboutToBeSavedListener;

public final class SessionAboutToBeSavedEvent
extends AbstractCyEvent<CySessionManager> {
    private final Map<String, List<File>> appFileListMap = new HashMap<String, List<File>>();

    public SessionAboutToBeSavedEvent(CySessionManager source) {
        super(source, SessionAboutToBeSavedListener.class);
    }

    public void addAppFiles(String appName, List<File> files) throws Exception {
        if (appName == null) {
            throw new NullPointerException("app name is null");
        }
        if (appName == "") {
            throw new IllegalArgumentException("app name is empty");
        }
        if (this.appFileListMap.containsKey(appName)) {
            throw new IllegalArgumentException("The app file list already contains a list of files identified by the name: " + appName);
        }
        if (files == null) {
            throw new NullPointerException("file list is null");
        }
        this.appFileListMap.put(appName, new ArrayList<File>(files));
    }

    public Map<String, List<File>> getAppFileListMap() {
        return Collections.unmodifiableMap(this.appFileListMap);
    }
}

