/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.service.util.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.service.util.internal.utils.RegisterUtil;
import org.cytoscape.service.util.internal.utils.ServiceUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class CyServiceRegistrarImpl
implements CyServiceRegistrar {
    private final BundleContext bc;
    private Map<Class, Map<Object, ServiceRegistration>> serviceRegistrations;

    public CyServiceRegistrarImpl(BundleContext bc) {
        this.bc = bc;
        this.serviceRegistrations = new HashMap<Class, Map<Object, ServiceRegistration>>();
    }

    Map<Class, Map<Object, ServiceRegistration>> getServiceRegistrations() {
        return this.serviceRegistrations;
    }

    @Override
    public void registerAllServices(Object service, Properties props) {
        ServiceUtil.registerAllServices(this.bc, service, props, this.serviceRegistrations);
    }

    public void registerService(Object service, Class serviceClass, Properties props) {
        ServiceUtil.registerService(this.bc, service, serviceClass, props, this.serviceRegistrations);
    }

    @Override
    public void unregisterAllServices(Object o) {
        for (Class<?> c : RegisterUtil.getAllInterfaces(o.getClass())) {
            if (c.getName().startsWith("java")) continue;
            this.unregisterService(o, c);
        }
    }

    @Override
    public void unregisterService(Object o, Class c) {
        if (o == null) {
            throw new NullPointerException("service object is null");
        }
        if (c == null) {
            throw new NullPointerException("class is null");
        }
        Map<Object, ServiceRegistration> registrations = this.serviceRegistrations.get(c);
        if (registrations == null) {
            return;
        }
        ServiceRegistration s = registrations.get(o);
        if (s == null) {
            return;
        }
        s.unregister();
        this.serviceRegistrations.get(c).remove(o);
    }

    @Override
    public <S> S getService(Class<S> serviceClass) {
        return ServiceUtil.getService(this.bc, serviceClass, null);
    }

    @Override
    public <S> S getService(Class<S> serviceClass, String filter) {
        return ServiceUtil.getService(this.bc, serviceClass, filter, null);
    }

    @Override
    public void registerServiceListener(Object listener, String registerMethodName, String unregisterMethodName, Class<?> serviceClass, Class<?> methodClass, String additionalFilter) {
        ServiceUtil.registerServiceListener(this.bc, listener, registerMethodName, unregisterMethodName, serviceClass, methodClass, additionalFilter, null);
    }

    @Override
    public void registerServiceListener(Object listener, String registerMethodName, String unregisterMethodName, Class<?> serviceClass) {
        this.registerServiceListener(listener, registerMethodName, unregisterMethodName, serviceClass, serviceClass, null);
    }

    @Override
    public void registerServiceListener(Object listener, String registerMethodName, String unregisterMethodName, Class<?> serviceClass, String additionalFilter) {
        this.registerServiceListener(listener, registerMethodName, unregisterMethodName, serviceClass, serviceClass, additionalFilter);
    }

    @Override
    public void registerServiceListener(Object listener, String registerMethodName, String unregisterMethodName, Class<?> serviceClass, Class<?> methodClass) {
        this.registerServiceListener(listener, registerMethodName, unregisterMethodName, serviceClass, methodClass, null);
    }
}

