/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.jobs;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.cytoscape.jobs.CyJob;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;

public class SUIDUtil {
    public static void saveSUIDs(CyJob job, CyNetwork network, List<? extends CyIdentifiable> objs) {
        HashMap<Identifiable, CyTable> suidMap = new HashMap<Identifiable, CyTable>();
        String columnName = SUIDUtil.getColumnName(job);
        CyTable hiddenTable = SUIDUtil.createColumn(network, Identifiable.NETWORK, columnName);
        CyRow netRow = hiddenTable.getRow(network.getSUID());
        if (netRow != null) {
            netRow.set(columnName, network.getSUID());
        }
        for (CyIdentifiable cyIdentifiable : objs) {
            CyRow row;
            Identifiable type = SUIDUtil.getType(cyIdentifiable);
            if (!suidMap.containsKey((Object)type) && (hiddenTable = SUIDUtil.createColumn(network, type, columnName)) != null) {
                suidMap.put(type, hiddenTable);
            }
            if ((row = ((CyTable)suidMap.get((Object)type)).getRow(cyIdentifiable.getSUID())) == null) continue;
            row.set(columnName, cyIdentifiable.getSUID());
        }
    }

    public static CyNetwork restoreNetwork(CyJob job, CyNetworkManager netManager, Long networkSUID, boolean clear) {
        String columnName = SUIDUtil.getColumnName(job);
        for (CyNetwork network : netManager.getNetworkSet()) {
            CyTable table = network.getTable(CyNetwork.class, "HIDDEN");
            if (table.getColumn(columnName) == null || !table.getRow(network.getSUID()).get(columnName, Long.class).equals(networkSUID)) continue;
            if (clear) {
                table.deleteColumn(columnName);
            }
            return network;
        }
        return null;
    }

    public static Map<Long, CyIdentifiable> restoreSUIDs(CyJob job, CyNetwork network, List<Long> oldIds, boolean clear) {
        CyTable edgeTable;
        CyTable nodeTable;
        HashMap<Long, CyIdentifiable> objMap = new HashMap<Long, CyIdentifiable>();
        HashSet<Long> suidSet = new HashSet<Long>(oldIds);
        String columnName = SUIDUtil.getColumnName(job);
        CyTable networkTable = network.getTable(CyNetwork.class, "HIDDEN");
        if (networkTable.getColumn(columnName) != null) {
            Long id = network.getRow(network).get(columnName, Long.class);
            if (suidSet.contains(id)) {
                objMap.put(id, network);
            }
            if (clear) {
                networkTable.deleteColumn(columnName);
            }
        }
        if ((nodeTable = network.getTable(CyNode.class, "HIDDEN")).getColumn(columnName) != null) {
            for (CyNode node : network.getNodeList()) {
                Long id = nodeTable.getRow(node.getSUID()).get(columnName, Long.class);
                if (id == null || !suidSet.contains(id)) continue;
                objMap.put(id, node);
            }
            if (clear) {
                nodeTable.deleteColumn(columnName);
            }
        }
        if ((edgeTable = network.getTable(CyEdge.class, "HIDDEN")).getColumn(columnName) != null) {
            for (CyEdge edge : network.getEdgeList()) {
                Long id = edgeTable.getRow(edge.getSUID()).get(columnName, Long.class);
                if (id == null || !suidSet.contains(id)) continue;
                objMap.put(id, edge);
            }
            if (clear) {
                edgeTable.deleteColumn(columnName);
            }
        }
        return objMap;
    }

    private static Identifiable getType(CyIdentifiable cyId) {
        if (CyNetwork.class.isAssignableFrom(cyId.getClass())) {
            return Identifiable.NETWORK;
        }
        if (CyNode.class.isAssignableFrom(cyId.getClass())) {
            return Identifiable.NODE;
        }
        if (CyEdge.class.isAssignableFrom(cyId.getClass())) {
            return Identifiable.EDGE;
        }
        return Identifiable.UNKNOWN;
    }

    private static String getColumnName(CyJob job) {
        String columnName = job.getJobName() + "(" + job.getJobId() + ")_SUID";
        return columnName;
    }

    private static CyTable createColumn(CyNetwork network, Identifiable type, String columnName) {
        Class clazz = null;
        switch (type) {
            case NETWORK: {
                clazz = CyNetwork.class;
                break;
            }
            case NODE: {
                clazz = CyNode.class;
                break;
            }
            case EDGE: {
                clazz = CyEdge.class;
                break;
            }
            case UNKNOWN: {
                return null;
            }
        }
        CyTable table = network.getTable(clazz, "HIDDEN");
        if (table.getColumn(columnName) == null) {
            table.createColumn(columnName, Long.class, false);
        }
        return table;
    }

    static enum Identifiable {
        NETWORK,
        NODE,
        EDGE,
        UNKNOWN;

    }
}

